<?php
/**
* @package Language-File-Tool (com_languagefiletool)
* @version 1.2.3
* @copyright Copyright (C) 2010-2011 Carsten Engel. All rights reserved.
* @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html 
* @author http://www.pages-and-items.com
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class languagefiletoolViewcheckb extends JView{

	function display($tpl = null){
	
		$controller = new languagefiletoolController();	
		$this->assignRef('controller', $controller);
		
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');	
		
		$database = JFactory::getDBO();
		
		$database->setQuery("SELECT framework "
		." FROM #__languagefiletool "
		." WHERE user='$user_id' "	
		." LIMIT 1 "	
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){
			$framework = $row->framework;	
		}	
		if($framework=='1.5'){
			$core_lang_vars = $this->core_15_vars();
		}else{
			$core_lang_vars = $this->core_16_vars();
		}
		$this->assignRef('core_lang_vars', $core_lang_vars);
		
		
		parent::display($tpl);
	}
	
	function array_to_csv($array){	
		$return = '';	
		for($n = 0; $n < count($array); $n++){
			if($n){
				$return .= ',';
			}
			$row = each($array);
			$value = $row['value'];
			if(is_string($value)){
				$value = addslashes($value);
			}	
			$return .= '"'.$value.'"';		
		}		
		return $return;
	}
	
	function core_15_vars(){
		return array("DATE_FORMAT_LC","DATE_FORMAT_LC1","DATE_FORMAT_LC2","DATE_FORMAT_LC3","DATE_FORMAT_LC4","DATE_FORMAT_JS1","%Y-%M-%D","%A, %B %E","JANUARY_SHORT","JANUARY","FEBRUARY_SHORT","FEBRUARY","MARCH_SHORT","MARCH","APRIL_SHORT","APRIL","MAY_SHORT","MAY","JUNE_SHORT","JUNE","JULY_SHORT","JULY","AUGUST_SHORT","AUGUST","SEPTEMBER_SHORT","SEPTEMBER","OCTOBER_SHORT","OCTOBER","NOVEMBER_SHORT","NOVEMBER","DECEMBER_SHORT","DECEMBER","SAT","SATURDAY","SUN","SUNDAY","MON","MONDAY","TUE","TUESDAY","WED","WEDNESDAY","THU","THURSDAY","FRI","FRIDAY","(TODAY)","(SHIFT-)CLICK OR DRAG TO CHANGE VALUE","ABOUT THE CALENDAR","DISPLAY %S FIRST","DRAG TO MOVE","GO TODAY","NEXT MONTH (HOLD FOR MENU)","NEXT YEAR (HOLD FOR MENU)","PREV. MONTH (HOLD FOR MENU)","PREV. YEAR (HOLD FOR MENU)","SELECT DATE","TIME","TIME:","CLOSE","TODAY","WK","TIME ZONE","(UTC -12:00) INTERNATIONAL DATE LINE WEST","(UTC -11:00) MIDWAY ISLAND, SAMOA","(UTC -10:00) HAWAII","(UTC -09:30) TAIOHAE, MARQUESAS ISLANDS","(UTC -09:00) ALASKA","(UTC -08:00) PACIFIC TIME (US & CANADA)","(UTC -07:00) MOUNTAIN TIME (US & CANADA)","(UTC -06:00) CENTRAL TIME (US & CANADA), MEXICO CITY","(UTC -05:00) EASTERN TIME (US & CANADA), BOGOTA, LIMA","(UTC -04:30) VENEZUELA","(UTC -04:00) ATLANTIC TIME (CANADA), CARACAS, LA PAZ","(UTC -03:30) ST. JOHN'S, NEWFOUNDLAND, LABRADOR","(UTC -03:00) BRAZIL, BUENOS AIRES, GEORGETOWN","(UTC -02:00) MID-ATLANTIC","(UTC -01:00) AZORES, CAPE VERDE ISLANDS","(UTC 00:00) WESTERN EUROPE TIME, LONDON, LISBON, CASABLANCA","(UTC +01:00) AMSTERDAM, BERLIN, BRUSSELS, COPENHAGEN, MADRID, PARIS","(UTC +02:00) ISTANBUL, JERUSALEM, KALININGRAD, SOUTH AFRICA","(UTC +03:00) BAGHDAD, RIYADH, MOSCOW, ST. PETERSBURG","(UTC +03:30) TEHRAN","(UTC +04:00) ABU DHABI, MUSCAT, BAKU, TBILISI","(UTC +04:30) KABUL","(UTC +05:00) EKATERINBURG, ISLAMABAD, KARACHI, TASHKENT","(UTC +05:30) BOMBAY, CALCUTTA, MADRAS, NEW DELHI, COLOMBO","(UTC +05:45) KATHMANDU","(UTC +06:00) ALMATY, DHAKA","(UTC +06:30) YAGOON","(UTC +07:00) BANGKOK, HANOI, JAKARTA","(UTC +08:00) BEIJING, PERTH, SINGAPORE, HONG KONG","(UTC +08:00) ULAANBAATAR, WESTERN AUSTRALIA","(UTC +09:00) TOKYO, SEOUL, OSAKA, SAPPORO, YAKUTSK","(UTC +09:30) ADELAIDE, DARWIN, YAKUTSK","(UTC +10:00) EASTERN AUSTRALIA, GUAM, VLADIVOSTOK","(UTC +10:30) LORD HOWE ISLAND (AUSTRALIA)","(UTC +11:00) MAGADAN, SOLOMON ISLANDS, NEW CALEDONIA","(UTC +11:30) NORFOLK ISLAND","(UTC +12:00) AUCKLAND, WELLINGTON, FIJI, KAMCHATKA","(UTC +12:45) CHATHAM ISLAND","(UTC +13:00) TONGA","(UTC +14:00) KIRIBATI","PHPMAILER_PROVIDE_ADDRESS","PHPMAILER_MAILER_IS_NOT_SUPPORTED","PHPMAILER_EXECUTE","PHPMAILER_INSTANTIATE","PHPMAILER_AUTHENTICATE","PHPMAILER_FROM_FAILED","PHPMAILER_RECIPIENTS_FAILED","PHPMAILER_DATA_NOT_ACCEPTED","PHPMAILER_CONNECT_HOST","PHPMAILER_FILE_ACCESS","PHPMAILER_FILE_OPEN","PHPMAILER_ENCODING","PHPMAILER_SIGNING","A SHORT ALT ATTRIBUTE FOR IMAGE","ACCESS","ACCESS LEVEL","ADD","ADMINISTRATION","ADMINISTRATION MESSAGES","ADMINISTRATOR","ADMINISTRATOR FILES","ADVANCED PARAMETERS","ALERTNOTAUTH","ALIAS","ALIASTIP","ALIGN","ALL","ALPHABETICAL INDEX","ALREADY EXISTS","ALT TEXT","ANY","AN ERROR HAS OCCURRED","ANOTHER TEMPLATE IS ALREADY USING DIRECTORY","APPLY","ARCHIVE","ARCHIVED","ARCHIVED ARTICLE LIST LAYOUT DESC","ARTICLES","ARTICLE PREVIEW","ASSIGN","ATTEMPT TO DELETE BASE DIRECTORY","AUTHOR","AUTHOR ALIAS","AUTHOR EMAIL","AUTHOR URL","BACK","BACKUP EXISTING FILES","BACKUP SUFFIX","BANNER CATEGORIES","BANNER","BANNERS","BORDER","BOTTOM","BROWSE","BROWSER","BY","CANCEL","CANNOT GET OR PARSE CLASS NAME.","CATEGORIES","CATEGORY","CATEGSUBMENU","CENTER","CHANGE CREATOR","CHANGES TO X SAVED","CHECKED OUT","CHECKIN MANAGER","CLICK ON ICON TO TOGGLE STATE.","CLICK TO CHECK IN","CLICK TO SORT THIS COLUMN","CLIENTS","CLOSE ALL","CONFIGURATION","COMPONENT","COMPONENT MANAGER","Component Not Found","CONTACT","CONTACT CATEGORIES","CONTACTS","CONTENT","CONTENT IMAGES","CONTINUE","COPY","COPYRIGHT","COULD NOT CREATE DIRECTORY","COULD NOT DELETE FOLDER","COULD NOT MAKE CONFIGURATION.PHP UNWRITABLE","COULD NOT COPY SETUP FILE","CREATED DATE","CREATOR","CURRENT","DATE","DEFAULT","DELETE","DELETED","DELETING","DESCBEINGEDITTED","DESCNEWITEMSFIRST","DESCNEWITEMSLAST","DESCRIPTION","DESCUSEVALIDLOGIN","DETAILS","DIRECTORY PERMISSIONS","DISABLE","DISABLED","DISPLAY NUM","DO NOT USE","DONE","E_LOGIN_AUTHENTICATE","E_NOLOGIN_ACCESS","E_NOLOGIN_BLOCKED","EDIT","EDIT CATEGORY","EDIT CONTENT","EDIT FILE","EDITOR","EDIT PLUGIN","EDIT SECTION","EDIT USER","EDIT USER INFORMATION","EDIT XML","EDIT XML FILE","EMAIL","ENABLE","ENABLED","ENABLE PLUGIN","END","END PAGE","ENGLISH","ERROR","ERROR SAVING FILE","ERRORELEMENTNOTFOUND","ERRORNOADMINS","ERRORNOFILE","ERRORXMLNOTFOUND","EXCLUDE IN FILE SEARCH","EXISTING MENU LINKS","EXPIRED","EXPIRES","EXPORT","FAILED","FAILED TO CREATE DIRECTORY","FAILED TO OPEN XML FILE","FAX","FEED IMAGE","FEEDS","FILE","FILE NOT FOUND","FILE SAVED","FILE UPLOAD","FILES","FILTER","FILTERS","FINISH","FINISH PUBLISHING","FINISH: NO EXPIRY","FINISHED","FIRST","FIRST PAGE","FILE SETTINGS","FORCE USER LOGOUT","GALLERY IMAGES","GO","GO TO FULL COMPONENT LIST","GREEN","GROUP","HELP","HIDE","HITS","ICONS","ID","IGNORE","IMAGE","IMAGE ALREADY EXISTS","IMAGES","IN MENU","INSTALL","ITEM SAVED","ITEMS COPIED","ITEMS PUBLISHED","ITEMS UNPUBLISHED","ITEMS REMOVED","UNINSTALL","ISFREESOFTWARE","ITEM","ITEM CHECKED IN","ITEM DETAILS","ITEM TITLE","JOOMLA!","JOOMLA! ADMINISTRATION LOGIN","JOOMLA! LOGO","JOOMLA WARNING","JPAGE_CURRENT_OF_TOTAL","LANGUAGE","LAST","LAST MODIFIED","LATEST ITEMS","LAYOUT","LEFT","LEGACY PARAMETERS","LICENSE","LINK TO MENU","LINKS","LIST FILES","LIST LENGTH","LIST OF COMPONENTS","LIST PACKAGES","LOCAL","LOGIN","LOGIN_BLOCKED","LOGIN_INCOMPLETE","LOGIN_INCORRECT","LOGIN_NOADMINS","LOGGED IN USER","LOGGED","LOGOUT","MAIL","MAIL_FUNCTION_DISABLED","MANAGE BANNERS","MANAGE CLIENTS","MANAGE CONTACTS","MANAGE NEWS FEEDS","MANAGE CATEGORIES","MANAGER","MASS MAIL","MAX SIZE","MAXIMUM","MEDIA","MENU IMAGE","MENU ITEM NAME","MENU LINKS AVAILABLE WHEN SAVED","MENU MANAGER","MENU ITEM MANAGER","MENU SELECTION","MENUS","MESSAGE","META DATA","METHOD","MINUTES","MODULE","MODULE PREVIEW","MOVE","MOVE DOWN","MOVE UP","MUSTENABLELEGACY","NAME","NAVIGATOR","NEXT","NEW","NEW ORDERING SAVED","NEW WINDOW WITH BROWSER NAVIGATION","NEW WINDOW WITHOUT BROWSER NAVIGATION","NEWSFEED","NEWS FEEDS","NO","NO ITEMS SELECTED","NO RECORDS FOUND","NO USER","NONE","NOT A VALID COMPONENT","NOT FOUND","NOT FOUND IN FILE","NOT MODIFIED","NOT PUBLISHED","NOTICE","NUM","NUM ACTIVE","NUM CATEGORIES","NUM ITEMS","NUM PUBLISHED","NUM TRASH","NUM UNPUBLISHED","NUM LINKS","OF","OFF","ON","OPEN ALL","OPERATION FAILED","OPTION","OPTIONS","OR","ORDER","ORDER BY","ORDER BY CATEGORY NAME","ORDER BY ORDER","ORDER BY SECTION TITLE","ORDER BY TITLE","OTHER PARAMETERS","OVERRIDE WRITE PROTECTION WHILE SAVING","ORDERING","OVERWRITE EXISTING FILES","PACKAGE","PACKAGE FILE","PACKAGE MADE","PAGE","PAGE CLASS SUFFIX","PAGE TITLE","PAGE WAS GENERATED IN","PARAMETER CONTROL","PARAMETERS","PARAMENABLED","PARAMMENUIMAGE","PARAMPAGECLASSSFX","PARAMPAGETITLE","PARAMPAGEHEADER","PARENT ITEM","PARENT WINDOW WITH BROWSER NAVIGATION","PASSWORD","PENDING","PERMISSIONS","PLEASE ENTER A NAME FOR THIS MENU ITEM","PLEASE ENTER A PASSWORD","PLEASE MAKE A SELECTION FROM THE LIST TO","PLEASE MAKE CACHE DIRECTORY WRITABLE.","PLEASE SELECT A CATEGORY.","PLEASE SELECT A MENU","PLEASE SELECT A NEWS STORY TO","PLEASE SELECT AN IMAGE TO UPLOAD","PLEASE SELECT AN ITEM FROM THE LIST TO","PLEASE SELECT AN ITEM TO","PLEASE SELECT AN ITEM TO MAKE","POLL PREVIEW","POLLS","POSITION","POST STORE FAILED","PREFERENCES","PREV","PREVIEW","PREVIOUS","PREVIOUS PAGE","PRINT ICON","PROMPT_CLOSE","PROVIDES SYSTEM LOGGING","PROVIDES REMEMBER ME FUNCTIONALITY","PUBLIC","PUBLIC BACKEND","PUBLIC FRONTEND","PUBLISH","PUBLISH INFORMATION","PUBLISH ITEM","PUBLISHED","PUBLISHED AND IS","PUBLISHED, BUT HAS","PUBLISHED, BUT IS","PUBLISHER","PUBLISHING","PUBLISHING INFO","QUICK TIP","RIGHT","REFRESH FILES","REGISTER","REGISTERED","RELATED LINKS","REMEMBER TO RENAME HTACCESS.TXT TO .HTACCESS","REMIND","REORDER","RESET","RESOURCE NOT FOUND","RESTORE","RESULTS","RESULTS OF","RETURN TO SITE HOME PAGE","SAVE","SAVE ORDER","SEARCH","SECONDS","SECTION","SECURITY","SELECT CLIENT","SELECT A CATEGORY","SELECT A MENU","SELECT AUTHOR","SELECT AN ITEM TO","SELECT AN ITEM TO DELETE","SELECT AN ITEM TO EDIT","SELECT AN ITEM TO MOVE","SELECT AN ITEM TO PUBLISH","SELECT AN ITEM TO UNPUBLISH","SELECT CATEGORY","SELECT FROM LIST","SELECT IMAGE","SELECT ITEM","SELECT SECTION","SELECT STATE","SERVER OFFSET","SESSION_EXPIRED","SETTINGS","SHOW","SHOW PAGE TITLE","SHOW/HIDE THE PAGES TITLE","SITE","SITE FILES","SOURCE","SPECIAL","SQL ERROR","START","START PUBLISHING","START: ALWAYS","STATE","STORE FAILED","SUBJECT","SUCCESS","SUCCESSFUL","SUCCESSFULLY CREATED","SUCCESSFULLY SAVED","SUCCESSFULLY SAVED CHANGES","SUPER ADMINISTRATOR","SUPPORT","SYNDICATE","TASK","TELEPHONE","TEMPLATE","TEMPLATE NOT FOUND","TEMPLATES","TEXT","THE FILE MUST BE","THE ITEM","THE MODULE","THIS WILL COPY THE CATEGORIES LISTED","TIME ZONE FOR THIS USER","TIPTITLEFIELD","TITLE","TITLE ALIAS","TO","TOOLTIP","TOOLS","TOP","TRASH","TRASHED CONTENT","TRASHED MENU ITEMS","TRAWL","TYPE","UNABLE TO CONNECT TO DATABASE:","UNABLE TO LOAD DATABASE DRIVER:","UNABLE TO REMOVE LANGUAGE DIRECTORY","UNABLE TO REMOVE THE COMPONENT ADMIN DIRECTORY","UNABLE TO REMOVE THE COMPONENT SITE DIRECTORY","UNPUBLISH","UNPUBLISH ITEM","UNPUBLISHED","UNWRITABLE","UP","UPLOAD","UPLOAD A FILE","UPLOAD OF","UPLOAD OF IMAGE FAILED","UPLOAD OF IMAGE SUCCESSFUL","URL","USE DEFAULT","USE GLOBAL","USER","USERNAME","VALIDALPHANOSPACES","VALIDDELETEITEMS","VALIDUSERPASS","VALIDUSERPASSACCESS","VERSION","VIEW","VIEW ALL","VISIBLE","VOTE","WARNFS_ERR01","WARNFS_ERR02","WARNFS_ERR03","WARNFS_ERR04","WARNING","WARNJAVASCRIPT","WEB","WEBLINK","WEB LINKS","WEBLINK ITEMS","WEBLINK CATEGORIES","WELCOME TO JOOMLA!","WIDTH","WRITABLE","YES","YOU MUST SELECT A CATEGORY","YOU MUST SELECT A SECTION","(UTC -08:00) PACIFIC TIME (US &AMP; CANADA)","(UTC -07:00) MOUNTAIN TIME (US &AMP; CANADA)","(UTC -06:00) CENTRAL TIME (US &AMP; CANADA), MEXICO CITY","(UTC -05:00) EASTERN TIME (US &AMP; CANADA), BOGOTA, LIMA","&LT","A USER SUBMITTED","ACCESS DENIED","ACCESS FORBIDDEN","AN ERROR HAS OCCURED","AN ERROR HAS OCCURRED WHILE PROCESSING YOUR REQUEST.","AN OUT-OF-DATE BOOKMARK/FAVOURITE","ARE YOU SURE YOU WANT TO DELETE SELECTED ITEMS.","A SEARCH ENGINE THAT HAS AN OUT-OF-DATE LISTING FOR THIS SITE","A MIS-TYPED ADDRESS","ATTENTION OPEN IN A NEW WINDOW","CACHE DIRECTORY UNWRITABLE","CANNOT FIND SOURCE FILE","CLOAKING","CLOSE WINDOW","COMPONENT NOT FOUND","CONTRIBUTED BY","COPY FAILED","DIRECTORY UNWRITABLE","EDIT CSS","EDIT HTML","ERROR LOADING FEED DATA","ERROR LOADING MODULES","ERRORXMLSETUP","FAILED TO SET LDAP_OPT_REFERRALS OPTION","FAILED TO SET LDAP PROTOCOL V3","GENERATED","GO TO THE HOME PAGE","HAS BEEN JUST SUBMITTED BY USER","HANDLER NOT DEFINED FOR TYPE","HOME","HOME PAGE","ICON_SEP","IF DIFFICULTIES PERSIST, PLEASE CONTACT THE SYSTEM ADMINISTRATOR OF THIS SITE.","ITEMS","LAST UPDATED","LAST_UPDATED2","LDAP_START_TLS FAILED","LIBRARY","LINK IS MISSING","LOGIN_SUCCESS","LOGOUT_SUCCESS","MAIL_MSG","MAIL_MSG_ADMIN","METHOD NOT FOUND:","MONTH","MORE ARTICLES...","MUST CONTAIN A TITLE","MUST HAVE A NAME","NO SORTING","NOT AUTHORISED","NOT_EXIST","PAGE COULD NOT BE FOUND","PAGEBREAK","PATH IS NOT A FOLDER","PARAMADMINLANGUAGE","PARAMLANGUAGE","PLEASE ENTER A USER NAME.","PLEASE ENTER A VALID E-MAIL ADDRESS.","PLEASE ENTER YOUR NAME.","PLEASE GO TO","PLEASE TRY ONE OF THE FOLLOWING PAGES:","POWERED BY","PRINT","READMORE","READ MORE...","REMEMBER ME","SELECT A SECTION","SELECT EDITOR","SELECT LANGUAGE","SORT ASCENDING","SORT DESCENDING","SUBURB","TEMPLATE_WARN","THE MEMCACHE EXTENSION IS NOT AVAILABLE","THE APC EXTENSION IS NOT AVAILABLE","THE EACCELERATOR EXTENSION IS NOT AVAILABLE","THERE ARE NO PARAMETERS FOR THIS ITEM","THE REQUESTED RESOURCE WAS NOT FOUND","TO VIEW AND APPROVE THIS","UNABLE TO ROUTE REQUEST","UNABLE TO CONNECT TO THE DATABASE:","UNARCHIVE","UNKNOWN","UPLOAD IMAGE","USER SUBMITTED","VALID_AZ09","VIEW NOT FOUND [NAME, TYPE, PREFIX]:","WARNINSTALL","WARNNAMETRYAGAIN","WARNMOSUSER","WARNREG_EMAIL_INUSE","WARNREG_INUSE","WARNREG_MAIL","WARNSUPERADMINCREATE","WRITTEN BY","WYSIWYG EDITOR FOR THIS USER","YEAR","YOU HAVE NO ACCESS TO THIS PAGE","YOU MAY NOT BE ABLE TO VISIT THIS PAGE BECAUSE OF:","YOU MUST LOGIN FIRST","YOU NEED TO LOGIN.","YOUR");
	}
	
	//updated to 1.7.0 keys
	function core_16_vars(){
		return array("J1","J2","J3","J4","J5","J6","J7","J8","J9","J10","J15","J20","J25","J30","J50","J100","JH1","JH2","JH3","JH4","JH5","JH6","ERROR","MESSAGE","NOTICE","WARNING","JADMINISTRATION","JADMINISTRATOR","JALL","JALL_LANGUAGE","JAPPLY","JARCHIVED","JAUTHOR","JCANCEL","JCATEGORIES","JCATEGORY","JCLEAR","JCLIENT","JCONFIG_PERMISSIONS_DESC","JCONFIG_PERMISSIONS_LABEL","JCURRENT","JDATE","JDEFAULT","JDETAILS","JDISABLED","JENABLED","JFALSE","JFEATURED","JHELP","JHIDE","JINVALID_TOKEN","JLOGIN","JLOGOUT","JMODIFY","JNEVER","JNEXT","JNO","JNONE","JOFF","JON","JOPTIONS","JPREV","JPREVIOUS","JPUBLISHED","JRECORD_NUMBER","JREGISTER","JSAVE","JSELECT","JSTATUS","JSHOW","JSITE","JSUBMIT","JTRASH","JTRASHED","JTRUE","JUNARCHIVE","JUNDEFINED","JUNPUBLISHED","JVERSION","JYES","JACTION_ADMIN","JACTION_ADMIN_COMPONENT_DESC","JACTION_ADMIN_GLOBAL","JACTION_ADMIN_GLOBAL_DESC","JACTION_COMPONENT_SETTINGS","JACTION_CREATE","JACTION_CREATE_COMPONENT_DESC","JACTION_DELETE","JACTION_DELETE_COMPONENT_DESC","JACTION_EDIT","JACTION_EDIT_COMPONENT_DESC","JACTION_EDITOWN","JACTION_EDITOWN_COMPONENT_DESC","JACTION_EDITSTATE","JACTION_EDITSTATE_COMPONENT_DESC","JACTION_LOGIN_ADMIN","JACTION_LOGIN_OFFLINE","JACTION_LOGIN_SITE","JACTION_MANAGE","JACTION_MANAGE_COMPONENT_DESC","JBROWSERTARGET_MODAL","JBROWSERTARGET_NEW","JBROWSERTARGET_PARENT","JBROWSERTARGET_POPUP","JERROR_ALERTNOAUTHOR","JERROR_AN_ERROR_HAS_OCCURRED","JERROR_CORE_DELETE_NOT_PERMITTED","JERROR_INVALID_CONTROLLER","JERROR_INVALID_CONTROLLER_CLASS","JERROR_LOADFILE_FAILED","JERROR_LOADING_MENUS","JERROR_LOGIN_DENIED","JERROR_NO_ITEMS_SELECTED","JERROR_NOLOGIN_BLOCKED","JERROR_SAVE_FAILED","JFIELD_ACCESS_DESC","JFIELD_ACCESS_LABEL","JFIELD_ALIAS_DESC","JFIELD_ALIAS_LABEL","JFIELD_ALT_COMPONENT_LAYOUT_DESC","JFIELD_ALT_LAYOUT_LABEL","JFIELD_ALT_MODULE_LAYOUT_DESC","JFIELD_ALT_PAGE_TITLE_DESC","JFIELD_ALT_PAGE_TITLE_LABEL","JFIELD_BASIS_LOGIN_DESCRIPTION_DESC","JFIELD_BASIS_LOGIN_DESCRIPTION_LABEL","JFIELD_BASIS_LOGIN_DESCRIPTION_SHOW_DESC","JFIELD_BASIS_LOGIN_DESCRIPTION_SHOW_LABEL","JFIELD_BASIS_LOGOUT_DESCRIPTION_DESC","JFIELD_BASIS_LOGOUT_DESCRIPTION_LABEL","JFIELD_BASIS_LOGOUT_DESCRIPTION_SHOW_DESC","JFIELD_BASIS_LOGOUT_DESCRIPTION_SHOW_LABEL","JFIELD_CATEGORY_DESC","JFIELD_ENABLED_DESC","JFIELD_LANGUAGE_DESC","JFIELD_LANGUAGE_LABEL","JFIELD_LOGIN_IMAGE_DESC","JFIELD_LOGIN_IMAGE_LABEL","JFIELD_LOGIN_REDIRECT_URL_DESC","JFIELD_LOGIN_REDIRECT_URL_LABEL","JFIELD_LOGOUT_IMAGE_DESC","JFIELD_LOGOUT_IMAGE_LABEL","JFIELD_LOGOUT_REDIRECT_URL_DESC","JFIELD_LOGOUT_REDIRECT_URL_LABEL","JFIELD_META_DESCRIPTION_DESC","JFIELD_META_DESCRIPTION_LABEL","JFIELD_META_KEYWORDS_DESC","JFIELD_META_KEYWORDS_LABEL","JFIELD_META_RIGHTS_DESC","JFIELD_META_RIGHTS_LABEL","JFIELD_METADATA_AUTHOR_DESC","JFIELD_METADATA_RIGHTS_DESC","JFIELD_METADATA_RIGHTS_LABEL","JFIELD_METADATA_ROBOTS_DESC","JFIELD_METADATA_ROBOTS_LABEL","JFIELD_METADATA_XREFERENCE_DESC","JFIELD_METADATA_XREFERENCE_LABEL","JFIELD_MODULE_LANGUAGE_DESC","JFIELD_NOTE_DESC","JFIELD_NOTE_LABEL","JFIELD_OPTION_NONE","JFIELD_ORDERING_DESC","JFIELD_ORDERING_LABEL","JFIELD_PARAMS_LABEL","JFIELD_PLG_SEARCH_ALL_DESC","JFIELD_PLG_SEARCH_ALL_LABEL","JFIELD_PLG_SEARCH_ARCHIVED_DESC","JFIELD_PLG_SEARCH_ARCHIVED_LABEL","JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC","JFIELD_PLG_SEARCH_SEARCHLIMIT_LABEL","JFIELD_PUBLISHED_DESC","JFIELD_READMORE_DESC","JFIELD_READMORE_LABEL","JFIELD_SPACER_LABEL","JFIELD_TITLE_DESC","JFIELD_XREFERENCE_DESC","JFIELD_XREFERENCE_LABEL","JGLOBAL_ACROSS","JGLOBAL_ACTION_PERMISSIONS_LABEL","JGLOBAL_ACTION_PERMISSIONS_DESCRIPTION","JGLOBAL_ALL_ARTICLE","JGLOBAL_ALL_LIST","JGLOBAL_ALLOW_COMMENTS_DESC","JGLOBAL_ALLOW_COMMENTS_LABEL","JGLOBAL_ALLOW_RATINGS_DESC","JGLOBAL_ALLOW_RATINGS_LABEL","JGLOBAL_ARCHIVE_ARTICLES_FIELD_INTROTEXTLIMIT_DESC","JGLOBAL_ARCHIVE_ARTICLES_FIELD_INTROTEXTLIMIT_LABEL","JGLOBAL_ARCHIVE_OPTIONS","JGLOBAL_ARTICLE_COUNT_DESC","JGLOBAL_ARTICLE_COUNT_LABEL","JGLOBAL_ARTICLE_MANAGER_ORDER","JGLOBAL_ARTICLE_MUST_HAVE_TEXT","JGLOBAL_ARTICLE_ORDER_DESC","JGLOBAL_ARTICLE_ORDER_LABEL","JGLOBAL_ARTICLES","JGLOBAL_AUTH_ACCESS_DENIED","JGLOBAL_AUTH_ACCESS_GRANTED","JGLOBAL_AUTH_BIND_FAILED","JGLOBAL_AUTH_CANCEL","JGLOBAL_AUTH_EMPTY_PASS_NOT_ALLOWED","JGLOBAL_AUTH_FAIL","JGLOBAL_AUTH_FAILED","JGLOBAL_AUTH_INCORRECT","JGLOBAL_AUTH_INVALID_PASS","JGLOBAL_AUTH_NO_BIND","JGLOBAL_AUTH_NO_CONNECT","JGLOBAL_AUTH_NO_REDIRECT","JGLOBAL_AUTH_NO_USER","JGLOBAL_AUTH_NOT_CREATE_DIR","JGLOBAL_AUTH_PASS_BLANK","JGLOBAL_AUTH_UNKNOWN_ACCESS_DENIED","JGLOBAL_AUTH_USER_BLACKLISTED","JGLOBAL_AUTH_USER_NOT_FOUND","JGLOBAL_AUTHOR_ALPHABETICAL","JGLOBAL_AUTHOR_REVERSE_ALPHABETICAL","JGLOBAL_AUTO","JGLOBAL_BATCH_MOVE_PARENT_NOT_FOUND","JGLOBAL_BATCH_PROCESS","JGLOBAL_BLOG","JGLOBAL_BLOG_LAYOUT_OPTIONS","JGLOBAL_CATEGORIES_OPTIONS","JGLOBAL_CATEGORY_LAYOUT_DESC","JGLOBAL_CATEGORY_LAYOUT_LABEL","JGLOBAL_CATEGORY_MANAGER_ORDER","JGLOBAL_CATEGORY_NOT_FOUND","JGLOBAL_CATEGORY_OPTIONS","JGLOBAL_CATEGORY_ORDER_DESC","JGLOBAL_CATEGORY_ORDER_LABEL","JGLOBAL_CENTER","JGLOBAL_CHOOSE_CATEGORY_DESC","JGLOBAL_CHOOSE_CATEGORY_LABEL","JGLOBAL_CLICK_TO_SORT_THIS_COLUMN","JGLOBAL_CLICK_TO_TOGGLE_STATE","JGLOBAL_COPY","JGLOBAL_CREATED","JGLOBAL_CREATED_DATE","JGLOBAL_DATE_FORMAT_DESC","JGLOBAL_DATE_FORMAT_LABEL","JGLOBAL_DESCRIPTION","JGLOBAL_DISPLAY_NUM","JGLOBAL_DISPLAY_SELECT_DESC","JGLOBAL_DISPLAY_SELECT_LABEL","JGLOBAL_DOWN","JGLOBAL_EDIT_ITEM","JGLOBAL_EDIT_PREFERENCES","JGLOBAL_EMAIL","JGLOBAL_EMPTY_CATEGORIES_DESC","JGLOBAL_EMPTY_CATEGORIES_LABEL","JGLOBAL_FEED_SUMMARY_DESC","JGLOBAL_FEED_SUMMARY_LABEL","JGLOBAL_FIELD_CATEGORIES_CHOOSE_CATEGORY_DESC","JGLOBAL_FIELD_CATEGORIES_CHOOSE_CATEGORY_LABEL","JGLOBAL_FIELD_CATEGORIES_DESC_DESC","JGLOBAL_FIELD_CATEGORIES_DESC_LABEL","JGLOBAL_FIELD_CREATED_BY_ALIAS_DESC","JGLOBAL_FIELD_CREATED_BY_ALIAS_LABEL","JGLOBAL_FIELD_CREATED_BY_DESC","JGLOBAL_FIELD_CREATED_BY_LABEL","JGLOBAL_FIELD_CREATED_DESC","JGLOBAL_FIELD_CREATED_LABEL","JGLOBAL_FIELD_FIELD_CACHETIME_DESC","JGLOBAL_FIELD_FIELD_ORDERING_LABEL","JGLOBAL_FIELD_ID_DESC","JGLOBAL_FIELD_ID_LABEL","JGLOBAL_FIELD_LAYOUT_DESC","JGLOBAL_FIELD_LAYOUT_LABEL","JGLOBAL_FIELD_MODIFIED_LABEL","JGLOBAL_FIELD_MODIFIED_BY_DESC","JGLOBAL_FIELD_MODIFIED_BY_LABEL","JGLOBAL_FIELD_NUM_CATEGORY_ITEMS_DESC","JGLOBAL_FIELD_NUM_CATEGORY_ITEMS_LABEL","JGLOBAL_FIELD_PUBLISH_DOWN_DESC","JGLOBAL_FIELD_PUBLISH_DOWN_LABEL","JGLOBAL_FIELD_PUBLISH_UP_DESC","JGLOBAL_FIELD_PUBLISH_UP_LABEL","JGLOBAL_FIELD_SHOW_BASE_DESCRIPTION_DESC","JGLOBAL_FIELD_SHOW_BASE_DESCRIPTION_LABEL","JGLOBAL_FIELDSET_DISPLAY_OPTIONS","JGLOBAL_FIELDSET_METADATA_OPTIONS","JGLOBAL_FIELDSET_OPTIONS","JGLOBAL_FIELDSET_PUBLISHING","JGLOBAL_FILTER_ATTRIBUTES_DESC","JGLOBAL_FILTER_ATTRIBUTES_LABEL","JGLOBAL_FILTER_CLIENT","JGLOBAL_FILTER_FIELD_DESC","JGLOBAL_FILTER_FIELD_LABEL","JGLOBAL_FILTER_GROUPS_DESC","JGLOBAL_FILTER_GROUPS_LABEL","JGLOBAL_FILTER_TAGS_DESC","JGLOBAL_FILTER_TAGS_LABEL","JGLOBAL_FILTER_TYPE_DESC","JGLOBAL_FILTER_TYPE_LABEL","JGLOBAL_FULL_TEXT","JGLOBAL_GT","JGLOBAL_HITS","JGLOBAL_INDEX_FOLLOW","JGLOBAL_INDEX_NOFOLLOW","JGLOBAL_INHERIT","JGLOBAL_INTEGRATION_LABEL","JGLOBAL_INTRO_TEXT","JGLOBAL_ISFREESOFTWARE","JGLOBAL_LEAST_HITS","JGLOBAL_LEFT","JGLOBAL_LINK_AUTHOR_DESC","JGLOBAL_LINK_AUTHOR_LABEL","JGLOBAL_LINK_CATEGORY_DESC","JGLOBAL_LINK_CATEGORY_LABEL","JGLOBAL_LINK_PARENT_CATEGORY_DESC","JGLOBAL_LINK_PARENT_CATEGORY_LABEL","JGLOBAL_LINKED_TITLES_DESC","JGLOBAL_LINKED_TITLES_LABEL","JGLOBAL_LIST","JGLOBAL_LIST_ALIAS","JGLOBAL_LIST_ALIAS_NOTE","JGLOBAL_LIST_AUTHOR_DESC","JGLOBAL_LIST_AUTHOR_LABEL","JGLOBAL_LIST_HITS_DESC","JGLOBAL_LIST_HITS_LABEL","JGLOBAL_LIST_LAYOUT_OPTIONS","JGLOBAL_LIST_NOTE","JGLOBAL_LIST_TITLE_DESC","JGLOBAL_LIST_TITLE_LABEL","JGLOBAL_LT","JGLOBAL_MAXIMUM_CATEGORY_LEVELS_DESC","JGLOBAL_MAXIMUM_CATEGORY_LEVELS_LABEL","JGLOBAL_MAXLEVEL_DESC","JGLOBAL_MAXLEVEL_LABEL","JGLOBAL_MENU_SELECTION","JGLOBAL_MODIFIED","JGLOBAL_MOST_HITS","JGLOBAL_MOST_RECENT_FIRST","JGLOBAL_MULTI_COLUMN_ORDER_DESC","JGLOBAL_MULTI_COLUMN_ORDER_LABEL","JGLOBAL_MULTI_LEVEL","JGLOBAL_NEWITEMSFIRST_DESC","JGLOBAL_NEWITEMSLAST_DESC","JGLOBAL_NO_ITEM_SELECTED","JGLOBAL_NO_ORDER","JGLOBAL_NOINDEX_FOLLOW","JGLOBAL_NOINDEX_NOFOLLOW","JGLOBAL_NUM_COLUMNS_DESC","JGLOBAL_NUM_COLUMNS_LABEL","JGLOBAL_NUM_INTRO_ARTICLES_DESC","JGLOBAL_NUM_INTRO_ARTICLES_LABEL","JGLOBAL_NUM_LEADING_ARTICLES_DESC","JGLOBAL_NUM_LEADING_ARTICLES_LABEL","JGLOBAL_NUM_LINKS_DESC","JGLOBAL_NUM_LINKS_LABEL","JGLOBAL_NUMBER_CATEGORY_ITEMS_DESC","JGLOBAL_NUMBER_CATEGORY_ITEMS_LABEL","JGLOBAL_NUMBER_ITEMS_LIST_DESC","JGLOBAL_NUMBER_ITEMS_LIST_LABEL","JGLOBAL_OLDEST_FIRST","JGLOBAL_ORDERING","JGLOBAL_ORDERING_DATE_DESC","JGLOBAL_ORDERING_DATE_LABEL","JGLOBAL_PAGINATION_DESC","JGLOBAL_PAGINATION_LABEL","JGLOBAL_PAGINATION_RESULTS_DESC","JGLOBAL_PAGINATION_RESULTS_LABEL","JGLOBAL_PASSWORD","JGLOBAL_PERMISSIONS_ANCHOR","JGLOBAL_PREVIEW","JGLOBAL_RECORD_NUMBER","JGLOBAL_REMEMBER_ME","JGLOBAL_RIGHT","JGLOBAL_ROOT","JGLOBAL_ROOT_PARENT","JGLOBAL_SELECT_ALLOW_DENY_GROUP","JGLOBAL_SELECTION_INVERT","JGLOBAL_SELECTION_ALL","JGLOBAL_SELECTION_NONE","JGLOBAL_SHOW_AUTHOR_DESC","JGLOBAL_SHOW_AUTHOR_LABEL","JGLOBAL_SHOW_CATEGORY_DESC","JGLOBAL_SHOW_CATEGORY_DESCRIPTION_DESC","JGLOBAL_SHOW_CATEGORY_DESCRIPTION_LABEL","JGLOBAL_SHOW_CATEGORY_IMAGE_DESC","JGLOBAL_SHOW_CATEGORY_IMAGE_LABEL","JGLOBAL_SHOW_CATEGORY_LABEL","JGLOBAL_SHOW_CATEGORY_TITLE","JGLOBAL_SHOW_CATEGORY_TITLE_DESC","JGLOBAL_SHOW_CREATE_DATE_DESC","JGLOBAL_SHOW_CREATE_DATE_LABEL","JGLOBAL_SHOW_DATE_DESC","JGLOBAL_SHOW_DATE_LABEL","JGLOBAL_SHOW_EMAIL_ICON_DESC","JGLOBAL_SHOW_EMAIL_ICON_LABEL","JGLOBAL_SHOW_EMPTY_CATEGORIES_DESC","JGLOBAL_SHOW_EMPTY_CATEGORIES_LABEL","JGLOBAL_SHOW_FEED_LINK_DESC","JGLOBAL_SHOW_FEED_LINK_LABEL","JGLOBAL_SHOW_HEADINGS_DESC","JGLOBAL_SHOW_HEADINGS_LABEL","JGLOBAL_SHOW_HITS_DESC","JGLOBAL_SHOW_HITS_LABEL","JGLOBAL_SHOW_ICONS_DESC","JGLOBAL_SHOW_ICONS_LABEL","JGLOBAL_SHOW_INTRO_DESC","JGLOBAL_SHOW_INTRO_LABEL","JGLOBAL_SHOW_MODIFY_DATE_DESC","JGLOBAL_SHOW_MODIFY_DATE_LABEL","JGLOBAL_SHOW_NAVIGATION_DESC","JGLOBAL_SHOW_NAVIGATION_LABEL","JGLOBAL_SHOW_PARENT_CATEGORY_DESC","JGLOBAL_SHOW_PARENT_CATEGORY_LABEL","JGLOBAL_SHOW_PRINT_ICON_DESC","JGLOBAL_SHOW_PRINT_ICON_LABEL","JGLOBAL_SHOW_PUBLISH_DATE_DESC","JGLOBAL_SHOW_PUBLISH_DATE_LABEL","JGLOBAL_SHOW_READMORE_DESC","JGLOBAL_SHOW_READMORE_LABEL","JGLOBAL_SHOW_READMORE_TITLE_DESC","JGLOBAL_SHOW_READMORE_TITLE_LABEL","JGLOBAL_SHOW_READMORE_LIMIT_DESC","JGLOBAL_SHOW_READMORE_LIMIT_LABEL","JGLOBAL_SHOW_SUBCATEGORIES_DESCRIPTION_DESC","JGLOBAL_SHOW_SUBCATEGORIES_DESCRIPTION_LABEL","JGLOBAL_SHOW_SUBCATEGORY_CONTENT_LABEL","JGLOBAL_SHOW_SUBCATEGORY_CONTENT_DESC","JGLOBAL_SHOW_TITLE_DESC","JGLOBAL_SHOW_TITLE_LABEL","JGLOBAL_SHOW_UNAUTH_LINKS_DESC","JGLOBAL_SHOW_UNAUTH_LINKS_LABEL","JGLOBAL_SHOW_VOTE_DESC","JGLOBAL_SHOW_VOTE_LABEL","JGLOBAL_SINGLE_LEVEL","JGLOBAL_SUBHEADING_DESC","JGLOBAL_SUBHEADING_LABEL","JGLOBAL_SUBMENU_CHECKIN","JGLOBAL_SUBMENU_CLEAR_CACHE","JGLOBAL_SUBMENU_PURGE_EXPIRED_CACHE","JGLOBAL_SUBSLIDER_BLOG_EXTENDED_LABEL","JGLOBAL_SUBSLIDER_BLOG_LAYOUT_LABEL","JGLOBAL_SUBSLIDER_DRILL_CATEGORIES_LABEL","JGLOBAL_TITLE","JGLOBAL_TITLE_ALPHABETICAL","JGLOBAL_TITLE_REVERSE_ALPHABETICAL","JGLOBAL_TOP","JGLOBAL_TPL_CPANEL_LINK_TEXT","JGLOBAL_USE_GLOBAL","JGLOBAL_USERNAME","JGLOBAL_VALIDATION_FORM_FAILED","JGLOBAL_VIEW_SITE","JGLOBAL_WARNJAVASCRIPT","JGLOBAL_WIDTH","JGLOBAL_CHECK_ALL","JGRID_HEADING_ACCESS","JGRID_HEADING_CREATED_BY","JGRID_HEADING_ID","JGRID_HEADING_LANGUAGE","JGRID_HEADING_MENU_ITEM_TYPE","JGRID_HEADING_ORDERING","JGRID_HEADING_ROW_NUMBER","JGRID_CHECKBOX_ROW_N","JHELP_COMPONENTS_BANNERS_BANNERS","JHELP_COMPONENTS_BANNERS_BANNERS_EDIT","JHELP_COMPONENTS_BANNERS_CATEGORIES","JHELP_COMPONENTS_BANNERS_CATEGORY_ADD","JHELP_COMPONENTS_BANNERS_CATEGORY_EDIT","JHELP_COMPONENTS_BANNERS_CLIENTS","JHELP_COMPONENTS_BANNERS_CLIENTS_EDIT","JHELP_COMPONENTS_BANNERS_TRACKS","JHELP_COMPONENTS_CONTACT_CATEGORIES","JHELP_COMPONENTS_CONTACT_CATEGORY_ADD","JHELP_COMPONENTS_CONTACT_CATEGORY_EDIT","JHELP_COMPONENTS_CONTACTS_CONTACTS","JHELP_COMPONENTS_CONTACTS_CONTACTS_EDIT","JHELP_COMPONENTS_CONTENT_CATEGORIES","JHELP_COMPONENTS_CONTENT_CATEGORY_ADD","JHELP_COMPONENTS_CONTENT_CATEGORY_EDIT","JHELP_COMPONENTS_MESSAGING_INBOX","JHELP_COMPONENTS_MESSAGING_READ","JHELP_COMPONENTS_MESSAGING_WRITE","JHELP_COMPONENTS_NEWSFEEDS_CATEGORIES","JHELP_COMPONENTS_NEWSFEEDS_CATEGORY_ADD","JHELP_COMPONENTS_NEWSFEEDS_CATEGORY_EDIT","JHELP_COMPONENTS_NEWSFEEDS_FEEDS","JHELP_COMPONENTS_NEWSFEEDS_FEEDS_EDIT","JHELP_COMPONENTS_REDIRECT_MANAGER","JHELP_COMPONENTS_REDIRECT_MANAGER_EDIT","JHELP_COMPONENTS_SEARCH","JHELP_COMPONENTS_WEBLINKS_CATEGORIES","JHELP_COMPONENTS_WEBLINKS_CATEGORY_ADD","JHELP_COMPONENTS_WEBLINKS_CATEGORY_EDIT","JHELP_COMPONENTS_WEBLINKS_LINKS","JHELP_COMPONENTS_WEBLINKS_LINKS_EDIT","JHELP_CONTENT_ARTICLE_MANAGER","JHELP_CONTENT_ARTICLE_MANAGER_EDIT","JHELP_CONTENT_FEATURED_ARTICLES","JHELP_CONTENT_MEDIA_MANAGER","JHELP_EXTENSIONS_EXTENSION_MANAGER_DISCOVER","JHELP_EXTENSIONS_EXTENSION_MANAGER_INSTALL","JHELP_EXTENSIONS_EXTENSION_MANAGER_MANAGE","JHELP_EXTENSIONS_EXTENSION_MANAGER_UPDATE","JHELP_EXTENSIONS_EXTENSION_MANAGER_WARNINGS","JHELP_EXTENSIONS_LANGUAGE_MANAGER_CONTENT","JHELP_EXTENSIONS_LANGUAGE_MANAGER_EDIT","JHELP_EXTENSIONS_LANGUAGE_MANAGER_INSTALLED","JHELP_EXTENSIONS_MODULE_MANAGER","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_CUSTOM","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_FEED","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_LATEST","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_LOGGED","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_LOGIN","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_MENU","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_ONLINE","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_POPULAR","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_QUICKICON","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_STATUS","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_SUBMENU","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_TITLE","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_TOOLBAR","JHELP_EXTENSIONS_MODULE_MANAGER_ADMIN_UNREAD","JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_ARCHIVE","JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_CATEGORIES","JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_CATEGORY","JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_NEWSFLASH","JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_RELATED","JHELP_EXTENSIONS_MODULE_MANAGER_BANNERS","JHELP_EXTENSIONS_MODULE_MANAGER_BREADCRUMBS","JHELP_EXTENSIONS_MODULE_MANAGER_CUSTOM_HTML","JHELP_EXTENSIONS_MODULE_MANAGER_EDIT","JHELP_EXTENSIONS_MODULE_MANAGER_FEED_DISPLAY","JHELP_EXTENSIONS_MODULE_MANAGER_FOOTER","JHELP_EXTENSIONS_MODULE_MANAGER_LANGUAGE_SWITCHER","JHELP_EXTENSIONS_MODULE_MANAGER_LATEST_NEWS","JHELP_EXTENSIONS_MODULE_MANAGER_LATEST_USERS","JHELP_EXTENSIONS_MODULE_MANAGER_LOGIN","JHELP_EXTENSIONS_MODULE_MANAGER_MENU","JHELP_EXTENSIONS_MODULE_MANAGER_MOST_READ","JHELP_EXTENSIONS_MODULE_MANAGER_RANDOM_IMAGE","JHELP_EXTENSIONS_MODULE_MANAGER_SEARCH","JHELP_EXTENSIONS_MODULE_MANAGER_STATISTICS","JHELP_EXTENSIONS_MODULE_MANAGER_SYNDICATION_FEEDS","JHELP_EXTENSIONS_MODULE_MANAGER_WEBLINKS","JHELP_EXTENSIONS_MODULE_MANAGER_WHO_ONLINE","JHELP_EXTENSIONS_MODULE_MANAGER_WRAPPER","JHELP_EXTENSIONS_PLUGIN_MANAGER","JHELP_EXTENSIONS_PLUGIN_MANAGER_EDIT","JHELP_EXTENSIONS_TEMPLATE_MANAGER_STYLES","JHELP_EXTENSIONS_TEMPLATE_MANAGER_STYLES_EDIT","JHELP_EXTENSIONS_TEMPLATE_MANAGER_TEMPLATES","JHELP_EXTENSIONS_TEMPLATE_MANAGER_TEMPLATES_EDIT","JHELP_EXTENSIONS_TEMPLATE_MANAGER_TEMPLATES_EDIT_SOURCE","JHELP_GLOSSARY","JHELP_MENUS_MENU_ITEM_ARTICLE_ARCHIVED","JHELP_MENUS_MENU_ITEM_ARTICLE_CATEGORIES","JHELP_MENUS_MENU_ITEM_ARTICLE_CATEGORY_BLOG","JHELP_MENUS_MENU_ITEM_ARTICLE_CATEGORY_LIST","JHELP_MENUS_MENU_ITEM_ARTICLE_CREATE","JHELP_MENUS_MENU_ITEM_ARTICLE_FEATURED","JHELP_MENUS_MENU_ITEM_ARTICLE_SINGLE_ARTICLE","JHELP_MENUS_MENU_ITEM_CONTACT_CATEGORIES","JHELP_MENUS_MENU_ITEM_CONTACT_CATEGORY","JHELP_MENUS_MENU_ITEM_CONTACT_FEATURED","JHELP_MENUS_MENU_ITEM_CONTACT_SINGLE_CONTACT","JHELP_MENUS_MENU_ITEM_EXTERNAL_URL","JHELP_MENUS_MENU_ITEM_MANAGER","JHELP_MENUS_MENU_ITEM_MANAGER_EDIT","JHELP_MENUS_MENU_ITEM_MENU_ITEM_ALIAS","JHELP_MENUS_MENU_ITEM_NEWSFEED_CATEGORIES","JHELP_MENUS_MENU_ITEM_NEWSFEED_CATEGORY","JHELP_MENUS_MENU_ITEM_NEWSFEED_SINGLE_NEWSFEED","JHELP_MENUS_MENU_ITEM_SEARCH_RESULTS","JHELP_MENUS_MENU_ITEM_TEXT_SEPARATOR","JHELP_MENUS_MENU_ITEM_USER_LOGIN","JHELP_MENUS_MENU_ITEM_USER_PASSWORD_RESET","JHELP_MENUS_MENU_ITEM_USER_PROFILE","JHELP_MENUS_MENU_ITEM_USER_PROFILE_EDIT","JHELP_MENUS_MENU_ITEM_USER_REGISTRATION","JHELP_MENUS_MENU_ITEM_USER_REMINDER","JHELP_MENUS_MENU_ITEM_WEBLINK_CATEGORIES","JHELP_MENUS_MENU_ITEM_WEBLINK_CATEGORY","JHELP_MENUS_MENU_ITEM_WEBLINK_SUBMIT","JHELP_MENUS_MENU_ITEM_WRAPPER","JHELP_MENUS_MENU_MANAGER","JHELP_MENUS_MENU_MANAGER_EDIT","JHELP_SITE_GLOBAL_CONFIGURATION","JHELP_SITE_MAINTENANCE_CLEAR_CACHE","JHELP_SITE_MAINTENANCE_GLOBAL_CHECK-IN","JHELP_SITE_MAINTENANCE_PURGE_EXPIRED_CACHE","JHELP_SITE_SYSTEM_INFORMATION","JHELP_START_HERE","JHELP_USERS_ACCESS_LEVELS","JHELP_USERS_ACCESS_LEVELS_EDIT","JHELP_USERS_DEBUG_USERS","JHELP_USERS_GROUPS","JHELP_USERS_GROUPS_EDIT","JHELP_USERS_MASS_MAIL_USERS","JHELP_USERS_USER_MANAGER","JHELP_USERS_USER_MANAGER_EDIT","JLIB_DATABASE_ERROR_ADAPTER_MYSQL","JLIB_DATABASE_ERROR_ADAPTER_MYSQLI","JLIB_DATABASE_ERROR_CONNECT_DATABASE","JLIB_DATABASE_ERROR_CONNECT_MYSQL","JLIB_DATABASE_ERROR_DATABASE_CONNECT","JLIB_DATABASE_ERROR_LOAD_DATABASE_DRIVER","JLIB_ERROR_INFINITE_LOOP","JOPTION_ACCESS_SHOW_ALL_ACCESS","JOPTION_ACCESS_SHOW_ALL_GROUPS","JOPTION_ACCESS_SHOW_ALL_LEVELS","JOPTION_ALL_CATEGORIES","JOPTION_ANY_CATEGORY","JOPTION_ANY","JOPTION_DO_NOT_USE","JOPTION_FROM_COMPONENT","JOPTION_FROM_MODULE","JOPTION_FROM_TEMPLATE","JOPTION_FROM_STANDARD","JOPTION_MENUS","JOPTION_NO_USER","JOPTION_OPTIONAL","JOPTION_ORDER_FIRST","JOPTION_ORDER_LAST","JOPTION_REQUIRED","JOPTION_SELECT_ACCESS","JOPTION_SELECT_AUTHOR_ALIAS","JOPTION_SELECT_AUTHOR_ALIASES","JOPTION_SELECT_AUTHOR","JOPTION_SELECT_AUTHORS","JOPTION_SELECT_CATEGORY","JOPTION_SELECT_EDITOR","JOPTION_SELECT_IMAGE","JOPTION_SELECT_LANGUAGE","JOPTION_SELECT_MENU","JOPTION_SELECT_MENU_ITEM","JOPTION_SELECT_PUBLISHED","JOPTION_SELECT_TEMPLATE","JOPTION_UNASSIGNED","JOPTION_USE_DEFAULT_MODULE_SETTING","JOPTION_USE_DEFAULT","JOPTION_USE_MENU_REQUEST_SETTING","JSEARCH_FILTER_LABEL","JSEARCH_FILTER_CLEAR","JSEARCH_FILTER_SUBMIT","JSEARCH_FILTER","JSEARCH_TITLE","JSEARCH_RESET","JTOOLBAR_APPLY","JTOOLBAR_ARCHIVE","JTOOLBAR_ASSIGN","JTOOLBAR_BACK","JTOOLBAR_CANCEL","JTOOLBAR_CHECKIN","JTOOLBAR_CLOSE","JTOOLBAR_DEFAULT","JTOOLBAR_DELETE","JTOOLBAR_DISABLE","JTOOLBAR_DUPLICATE","JTOOLBAR_EDIT","JTOOLBAR_EDIT_CSS","JTOOLBAR_EDIT_HTML","JTOOLBAR_EMPTY_TRASH","JTOOLBAR_ENABLE","JTOOLBAR_EXPORT","JTOOLBAR_HELP","JTOOLBAR_INSTALL","JTOOLBAR_NEW","JTOOLBAR_OPTIONS","JTOOLBAR_PUBLISH","JTOOLBAR_PURGE_CACHE","JTOOLBAR_REBUILD","JTOOLBAR_REFRESH_CACHE","JTOOLBAR_REMOVE","JTOOLBAR_SAVE","JTOOLBAR_SAVE_AND_NEW","JTOOLBAR_SAVE_AS_COPY","JTOOLBAR_UNARCHIVE","JTOOLBAR_UNINSTALL","JTOOLBAR_UNPUBLISH","JTOOLBAR_UPLOAD","JTOOLBAR_TRASH","JTOOLBAR_REBUILD_SUCCESS","JWARNING_PUBLISH_MUST_SELECT","JWARNING_ARCHIVE_MUST_SELECT","JWARNING_UNPUBLISH_MUST_SELECT","JWARNING_TRASH_MUST_SELECT","JWARNING_DELETE_MUST_SELECT","JWARNING_REMOVE_ROOT_USER","DATE_FORMAT_LC","DATE_FORMAT_LC1","DATE_FORMAT_LC2","DATE_FORMAT_LC3","DATE_FORMAT_LC4","DATE_FORMAT_JS1","JANUARY_SHORT","JANUARY","FEBRUARY_SHORT","FEBRUARY","MARCH_SHORT","MARCH","APRIL_SHORT","APRIL","MAY_SHORT","MAY","JUNE_SHORT","JUNE","JULY_SHORT","JULY","AUGUST_SHORT","AUGUST","SEPTEMBER_SHORT","SEPTEMBER","OCTOBER_SHORT","OCTOBER","NOVEMBER_SHORT","NOVEMBER","DECEMBER_SHORT","DECEMBER","SAT","SATURDAY","SUN","SUNDAY","MON","MONDAY","TUE","TUESDAY","WED","WEDNESDAY","THU","THURSDAY","FRI","FRIDAY","TIME_ZONE","UTC__12_00__INTERNATIONAL_DATE_LINE_WEST","UTC__11_00__MIDWAY_ISLAND__SAMOA","UTC__10_00__HAWAII","UTC__09_30__TAIOHAE__MARQUESAS_ISLANDS","UTC__09_00__ALASKA","UTC__08_00__PACIFIC_TIME__US__AMP__CANADA_","UTC__07_00__MOUNTAIN_TIME__US__AMP__CANADA_","UTC__06_00__CENTRAL_TIME__US__AMP__CANADA___MEXICO_CITY","UTC__05_00__EASTERN_TIME__US__AMP__CANADA___BOGOTA__LIMA","UTC__04_30__VENEZUELA","UTC__04_00__ATLANTIC_TIME__CANADA___CARACAS__LA_PAZ","UTC__03_30__ST__JOHN_S__NEWFOUNDLAND__LABRADOR","UTC__03_00__BRAZIL__BUENOS_AIRES__GEORGETOWN","UTC__02_00__MID_ATLANTIC","UTC__01_00__AZORES__CAPE_VERDE_ISLANDS","UTC_00_00__WESTERN_EUROPE_TIME__LONDON__LISBON__CASABLANCA","UTC__01_00__AMSTERDAM__BERLIN__BRUSSELS__COPENHAGEN__MADRID__PARIS","UTC__02_00__ISTANBUL__JERUSALEM__KALININGRAD__SOUTH_AFRICA","UTC__03_00__BAGHDAD__RIYADH__MOSCOW__ST__PETERSBURG","UTC__03_30__TEHRAN","UTC__04_00__ABU_DHABI__MUSCAT__BAKU__TBILISI","UTC__04_30__KABUL","UTC__05_00__EKATERINBURG__ISLAMABAD__KARACHI__TASHKENT","UTC__05_30__BOMBAY__CALCUTTA__MADRAS__NEW_DELHI__COLOMBO","UTC__05_45__KATHMANDU","UTC__06_00__ALMATY__DHAKA","UTC__06_30__YAGOON","UTC__07_00__BANGKOK__HANOI__JAKARTA__PHNOM_PENH","UTC__08_00__BEIJING__PERTH__SINGAPORE__HONG_KONG","UTC__08_00__WESTERN_AUSTRALIA","UTC__09_00__TOKYO__SEOUL__OSAKA__SAPPORO__YAKUTSK","UTC__09_30__ADELAIDE__DARWIN__YAKUTSK","UTC__10_00__EASTERN_AUSTRALIA__GUAM__VLADIVOSTOK","UTC__10_30__LORD_HOWE_ISLAND__AUSTRALIA_","UTC__11_00__MAGADAN__SOLOMON_ISLANDS__NEW_CALEDONIA","UTC__11_30__NORFOLK_ISLAND","UTC__12_00__AUCKLAND__WELLINGTON__FIJI__KAMCHATKA","UTC__12_45__CHATHAM_ISLAND","UTC__13_00__TONGA","UTC__14_00__KIRIBATI","PHPMAILER_PROVIDE_ADDRESS","PHPMAILER_MAILER_IS_NOT_SUPPORTED","PHPMAILER_EXECUTE","PHPMAILER_INSTANTIATE","PHPMAILER_AUTHENTICATE","PHPMAILER_FROM_FAILED","PHPMAILER_RECIPIENTS_FAILED","PHPMAILER_DATA_NOT_ACCEPTED","PHPMAILER_CONNECT_HOST","PHPMAILER_FILE_ACCESS","PHPMAILER_FILE_OPEN","PHPMAILER_ENCODING","PHPMAILER_SIGNING_ERROR");
	}
	
}

jimport( 'joomla.filesystem.folder' );

class find_all_langvars{

	public $source_dir = '_languagefiletool_extensionfiles';	
	public $all_lang_vars = array();
	
	function find_all_langvars(){	
		$this->folders($this->source_dir);									
	}
	
	function file_find_all_langvars($file){
		
		if (!$fp = @fopen(JPATH_ROOT.DS.$file, "r")) {			
			die('not reradable');
			return false;
		}						
		$filename = JPATH_ROOT.DS.$file;					
		$fstring = fread($fp, filesize($filename));
		fclose ($fp);
		
		$regex = "/JText::_\('(.*?)'\)/is";
			
		preg_match_all($regex, $fstring, $matches); 	
		//echo $string;
							

		for($n = 0; $n < count($matches[0]); $n++){
			$thing = $matches[1][$n];
			
			if(strpos($thing, "'")){
				$pos = strpos($thing, "'");
				$thing = substr($thing, 0, $pos);
			}
			
			if(!in_array($thing, $this->all_lang_vars)){
				$this->all_lang_vars[] = $thing;
			}
			
		}
		
		$regex = "/JHtml::_\('grid.sort'\,(.*?)\,/is";
			
		preg_match_all($regex, $fstring, $matches);							

		for($n = 0; $n < count($matches[0]); $n++){
			$thing = $matches[1][$n];
			if((strpos($thing, "'") || strpos($thing, '"')) && !strpos($thing, 'Text::_')){
				//there is a string, not a $label or so
				$thing = str_replace('"', '' ,$thing);			
				$thing = str_replace("'", '' ,$thing);	
				$thing = trim($thing);
				if(!in_array($thing, $this->all_lang_vars)){
					$this->all_lang_vars[] = $thing;
				}
			}
			
		}
		
	}	
	
	function files($currentfolder){
		$files = JFolder::files(JPATH_ROOT.DS.$currentfolder);	
		foreach($files as $file){
			//echo 'file= '.$currentfolder.DS.$file.'<br />';
			if(strpos($file, '.php')){
				$this->file_find_all_langvars($currentfolder.DS.$file);
			}
		}
	}
	
	
	function folders($currentfolder){									
		
		$this->files($currentfolder);								
		$folders = JFolder::folders(JPATH_ROOT.DS.$currentfolder);								
		foreach($folders as $folder){
			//echo 'dir= '.$folder.'<br />';										
			$this->folders($currentfolder.DS.$folder);
		}
	}

}

class check_langfiles{
							
	public $source_dir = '_languagefiletool_langfiles_processed';
	public $all_lang_vars = array();
	public $all_too_many_lang_vars = array();
	public $target_dir = '_languagefiletool_langfiles_processed';
	public $core_lang_vars = array();
	public $report = '';
	public $result = '';
	public $used_core_vars = '';	
	
	
	function check_langfiles_thing($all_lang_vars, $core_lang_vars){	
	
		$this->core_lang_vars = $core_lang_vars;
		
			//print_r($core_lang_vars);	
			//exit;		
		$this->all_lang_vars = $all_lang_vars;				
		$this->folders($this->source_dir);	
		
							
	}
	
	function file_check_langfiles($file){		
		
		if (!$fp = @fopen(JPATH_ROOT.DS.$file, "r")) {			
			die('not reradable');
			return false;
		}						
		$filename = JPATH_ROOT.DS.$file;					
		$fstring = fread($fp, filesize($filename));
		fclose ($fp);
		
		$lines = explode("\n", $fstring);	
		
		$varnames_in_this_file = array();					
		foreach($lines as $line){
			//filter stuff
			if(strpos($line, '=')){											
				
				$temp = $line;											
				$pos = strpos($temp, '=');
				$varname = substr($temp, 0, $pos);
				$varnames_in_this_file[] = $varname;			
				
			}
		}
		
		$missing = 0;	
		//check if there are language strings missing
		foreach($this->all_lang_vars as $all_lang_var){
			if(in_array($all_lang_var, $this->core_lang_vars)){
				//$this->result .= '<p style="color: purple;">using core language var = '.$all_lang_var.'</p>';
				$this->used_core_vars .= $all_lang_var."\n";
			}
			if(!in_array($all_lang_var, $varnames_in_this_file) && !in_array($all_lang_var, $this->core_lang_vars)){
				//var is not in core file and language file, so is missing
				$this->result .= '<p style="color: red;">'.JText::_('COM_LANGUAGEFILETOOL_MISSING').' = '.$all_lang_var.'</p>';
				$missing = 1;	
						
			}
		}
		
		$too_many = 0;
		//check if there are too many vars in there
		foreach($varnames_in_this_file as $varname_in_this_file){
			if(!in_array($varname_in_this_file, $this->all_lang_vars)){
				$this->result .= '<p style="color: red;">'.JText::_('COM_LANGUAGEFILETOOL_NOT_USED').' = '.$varname_in_this_file.'</p>';
				$too_many = 1;
				if(!in_array($varname_in_this_file, $this->all_too_many_lang_vars)){	
					$this->all_too_many_lang_vars[] = $varname_in_this_file;
				}	
			}
		}
		
		$temp = str_replace('_languagefiletool_langfiles_processed'.DS,'',$file);
		$this->report .= '<br /><p>'.$temp.' <a href="#'.$temp.'">'.JText::_('COM_LANGUAGEFILETOOL_DETAILS').'</a></p>';
		if(!$missing){
			$this->report .= '<p style="color: green;">'.JText::_('COM_LANGUAGEFILETOOL_FILE_IS_COMPLETE').'</p>';
		}else{
			$this->report .= '<p style="color: red;">'.JText::_('COM_LANGUAGEFILETOOL_FILE_MISSING_TRANSLATIONS').'</p>';
		}
		
		if(!$missing){
			$this->result .= '<p style="color: green;">'.JText::_('COM_LANGUAGEFILETOOL_FILE_IS_COMPLETE').'</p>';
		}
	}
	
	
	function files($currentfolder){
		$files = JFolder::files(JPATH_ROOT.DS.$currentfolder);	
		foreach($files as $file){
			$temp = $currentfolder;
			$temp = str_replace('_languagefiletool_langfiles_processed','',$temp);
			$this->result .= '<a name="'.$file.'"></a><br />';
			$this->result .= '<h3 style="padding-bottom: 0; margin-bottom: 0;">'.$file.'</h3>';
			$this->file_check_langfiles($currentfolder.DS.$file);
		}
	}
	
	
	function folders($currentfolder){									
		
		$this->files($currentfolder);								
		$folders = JFolder::folders(JPATH_ROOT.DS.$currentfolder);								
		foreach($folders as $folder){
												
			$this->folders($currentfolder.DS.$folder);
		}
	}	
	
	/*
	function do_string_replacement($string){
									
		$lines = explode("\n", $string);
			
		$freshlines = '
# Note : All ini files need to be saved as UTF-8
	
';
		
		foreach($lines as $line){
			//filter stuff
			if(strpos($line, '=')){											
				
				$temp = $line;											
				$pos = strpos($temp, '=');
				$varname = substr($temp, 0, $pos); 				
				
				
				$value = substr($temp, $pos+1, 999); 
				$value = str_replace('"', '', $value);											
				$value = trim($value);															
				
				$freshline = $varname.'="'.$value.'"';
				
				$freshlines .= $freshline."						
";
				
			}
		}									
		$freshlines .= "#end_lang";
		//echo $freshlines;
		$string = $freshlines;
		
		return $string;
	}
	*/
		
	
	
	
	
	

}

?>