﻿<?php
/**
* @package Language-File-Tool (com_languagefiletool)
* @version 1.2.3
* @copyright Copyright (C) 2010-2011 Carsten Engel. All rights reserved.
* @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html 
* @author http://www.pages-and-items.com
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class languagefiletoolController extends JController{	
	
	public $lang_array = array();	
	public $version = '1.2.2';
	
	function get_language_array(){	
			
		$this->lang_array[] = array('af','af-ZA','Afrikaans');
		$this->lang_array[] = array('sq','sq-AL','Albanian');
		$this->lang_array[] = array('ar','ar-EG','Arabic');
		$this->lang_array[] = array('be','be-BE','Belarusian');
		$this->lang_array[] = array('bg','bg-BG','Bulgarian');
		$this->lang_array[] = array('ca','ca-ES','Catalan');		
		$this->lang_array[] = array('zh-CN','zh-CN','Chinese (Simplified)');
		$this->lang_array[] = array('zh-TW','zh-TW','Chinese (Traditional)');
		$this->lang_array[] = array('hr','hr-HR','Croatian');
		$this->lang_array[] = array('cs','cs-CZ','Czech');
		$this->lang_array[] = array('da','da-DK','Danish');	
		$this->lang_array[] = array('nl','nl-NL','Dutch');
		$this->lang_array[] = array('en','en-GB','English');			
		$this->lang_array[] = array('et','et-EE','Estonian');
		$this->lang_array[] = array('tl','tl-PH','Filipino');
		$this->lang_array[] = array('fi','fi-FI','Finnish');
		$this->lang_array[] = array('fr','fr-FR','French');
		$this->lang_array[] = array('gl','gl-ES','Galician');
		$this->lang_array[] = array('de','de-DE','German');
		$this->lang_array[] = array('el','el-GR','Greek');
		$this->lang_array[] = array('ht','ht-NG','Haitian Creole');
		$this->lang_array[] = array('iw','he-IL','Hebrew');
		$this->lang_array[] = array('hi','hi-IN','Hindi');
		$this->lang_array[] = array('hu','hu-HU','Hungarian');
		$this->lang_array[] = array('is','is-IS','Icelandic');		
		$this->lang_array[] = array('id','id-ID','Indonesian');
		$this->lang_array[] = array('ga','ga-IE','Irish');
		$this->lang_array[] = array('it','it-IT','Italian');
		$this->lang_array[] = array('ja','ja-JP','Japanese');
		$this->lang_array[] = array('ko','ko-KR','Korean');
		$this->lang_array[] = array('lv','lv-LV','Latvian');
		$this->lang_array[] = array('lt','lt-LT','Lithuanian');
		$this->lang_array[] = array('mk','mk-MK','Macedonian');
		$this->lang_array[] = array('ms','ms-MY','Malay');
		$this->lang_array[] = array('mt','mt-MT','Maltese');
		$this->lang_array[] = array('no','no-NO','Norwegian');
		$this->lang_array[] = array('fa','fa-IR','Persian');		
		$this->lang_array[] = array('pl','pl-PL','Polish');
		$this->lang_array[] = array('pt','pt-PT','Portuguese');
		$this->lang_array[] = array('pt','pt-BR','Portuguese Brasil');
		$this->lang_array[] = array('ro','ro-RO','Romanian');
		$this->lang_array[] = array('ru','ru-RU','Russian');
		$this->lang_array[] = array('sr','sr-RS','Serbian');
		$this->lang_array[] = array('sk','sk-SK','Slovak');
		$this->lang_array[] = array('sl','sl-SI','Slovenian');
		$this->lang_array[] = array('es','es-ES','Spanish');
		$this->lang_array[] = array('sw','sw-TZ','Swahili');
		$this->lang_array[] = array('sv','sv-SE','Swedish');
		$this->lang_array[] = array('th','th-TH','Thai');
		$this->lang_array[] = array('tr','tr-TR','Turkish');
		$this->lang_array[] = array('uk','uk-UA','Ukrainian');
		$this->lang_array[] = array('vi','vi-VN','Vietnamese');
		$this->lang_array[] = array('cy','cy-GB','Welsh');		
		$this->lang_array[] = array('yi','yi-IL','Yiddish');
		
	}

	function display(){	
	
		global $mainframe;		
		
		// Set a default view if none exists
		$view_from_url = JRequest::getVar('view', '', 'get');			
		if(!$view_from_url){					
			JRequest::setVar('view', 'checka');			
		}
		
		// Load the submenu.
		require_once JPATH_COMPONENT.'/helpers/languagefiletool.php';
		languagefiletoolHelper::addSubmenu(JRequest::getWord('view', 'languagefiletool'));	
		
		//set header		
		JToolBarHelper::title('Language File Tool', 'lft_icon');	
		
		parent::display();
				
	}
	
	function submenu(){
		
		$view = JRequest::getVar('view', '');
		$on = '<span style="font-size: 40px; line-height: 20px;">&#149;</span>';
		$html = '<style>.submenutable td{padding-right: 20px; text-align: center;}</style>';
		$html .= '<div style="margin-bottom: 20px;"><table class="submenutable">';
		$html .= '<tr><td>';
		if($view=='checka'){		
			$html .= $on;
		}
		$html .= '</td><td>';
		if($view=='checkab'){		
			$html .= $on;
		}
		$html .= '</td><td>';
		if($view=='checkb'){		
			$html .= $on;
		}
		$html .= '</td><td>';
		if($view=='checkc'){		
			$html .= $on;
		}
		$html .= '</td></tr>';
		$html .= '<tr><td>';
		$html .= '1. ';
		$html .= '<a href="index.php?option=com_languagefiletool&view=checka">';		
		$html .= JText::_('COM_LANGUAGEFILETOOL_PREPARE');
		$html .= '</a>';
		$html .= '</td><td>';
		$html .= '2. ';
		$html .= '<a href="index.php?option=com_languagefiletool&view=checkab">';	
		$html .= JText::_('COM_LANGUAGEFILETOOL_REBUILD_FILES');
		$html .= '</a>';
		$html .= '</td><td>';
		$html .= '3. ';
		if($view=='checkab' || $view=='checkb' || $view=='checkc'){
			$html .= '<a href="index.php?option=com_languagefiletool&view=checkb">';	
		}
		$html .= JText::_('COM_LANGUAGEFILETOOL_CHECK_FILES');
		if($view=='checkab' || $view=='checkb' || $view=='checkc'){
			$html .= '</a>';
		}
		$html .= '</td><td>';
		$html .= '4. ';
		if($view=='checkb'){
			$html .= '<a href="javascript:are_you_sure();">';	
		}
		$html .= JText::_('COM_LANGUAGEFILETOOL_CLEANUP_UNUSED_LINES');
		if($view=='checkb' || $view=='checkc'){
			$html .= '</a>';
		}
		$html .= '</td></tr></table></div>';
		
		return $html;
	}
	
	function submenu_trans($is_ready_for_translation){
		
		$view = JRequest::getVar('view', '');
		$on = '<span style="font-size: 40px; line-height: 20px;">&#149;</span>';
		$html = '<style>.submenutable td{padding-right: 20px; text-align: center;}</style>';
		$html .= '<div style="margin-bottom: 20px;"><table class="submenutable">';
		$html .= '<tr><td>';
		if($view=='translatea'){		
			$html .= $on;
		}
		$html .= '</td><td>';
		if($view=='translatec'){		
			$html .= $on;
		}
		$html .= '</td>';		
		$html .= '</td></tr>';
		$html .= '<tr><td>';
		$html .= '1. ';
		$html .= '<a href="index.php?option=com_languagefiletool&view=translatea">';		
		$html .= JText::_('COM_LANGUAGEFILETOOL_SETTINGS');
		$html .= '</a>';
		$html .= '</td><td>';
		$html .= '2. ';
		if($is_ready_for_translation){
			$html .= '<a href="index.php?option=com_languagefiletool&view=translatec">';	
		}
		$html .= JText::_('COM_LANGUAGEFILETOOL_TRANSLATE');
		if($is_ready_for_translation){
			$html .= '</a>';
		}
		$html .= '</td>';		
		$html .= '</tr></table></div>';
		
		return $html;
	}
	
	function save_check_setting(){
	
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');
		
		
		$database = JFactory::getDBO();
		
		//check if there already is a row for this user
		$id = 0;
		$database->setQuery("SELECT id "
		."FROM #__languagefiletool "
		."WHERE user='$user_id' "		
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$id = $row->id;	
		}
		
		$lang_format = JRequest::getVar('lang_format', '1.6');
		$prefix = JRequest::getVar('prefix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$prefix_db = addslashes($prefix);
		$suffix = JRequest::getVar('suffix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$suffix_db = addslashes($suffix);
		$framework = JRequest::getVar('framework', '1.6');
		$comments = JRequest::getVar('comments', '');
		
		//if there is already a users row for this user do update
		if($id){			
			$database->setQuery( "UPDATE #__languagefiletool SET lang_format='$lang_format', prefix='$prefix', suffix='$suffix', framework='$framework', comments='$comments' WHERE user='$user_id' ");
			$database->query();
		}else{				
			$database->setQuery( "INSERT INTO #__languagefiletool SET user='$user_id', lang_format='$lang_format', prefix='$prefix', suffix='$suffix',  framework='$framework', comments='$comments' ");
			$database->query();
		}
		
		$url = 'index.php?option=com_languagefiletool&view=checka';
		$this->setRedirect($url, JText::_('COM_LANGUAGEFILETOOL_SETTINGS_SAVED'));
	}
	
	function translate_save(){		
		
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');		
		
		$database = JFactory::getDBO();
		
		//check if there already is a row for this user
		$id = 0;
		$database->setQuery("SELECT id "
		."FROM #__languagefiletool "
		."WHERE user='$user_id' "		
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$id = $row->id;	
		}
		
		$lang_format_trans = JRequest::getVar('lang_format_trans', '1.6');
		$ori_lang = JRequest::getVar('ori_lang', 'en');
		//$original_file = JRequest::getVar('original_file', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$original_file = JRequest::getVar('original_file', '' ,'POST', 'STRING', JREQUEST_ALLOWRAW);		
		
		$original_file_db = addslashes($original_file);
		$filename = JRequest::getVar('filename', '');
		$prefix = JRequest::getVar('prefix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$prefix_db = addslashes($prefix);
		$suffix = JRequest::getVar('suffix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$suffix_db = addslashes($suffix);
		$only_new_strings = JRequest::getVar('only_new_strings', '');
		$comments = JRequest::getVar('comments', '');
		
		$lines = explode("\n", $original_file);		
		
		$language_var_names = '';
		$language_values = '';
		
		$separator = '<br />';
		
			
		$first = 1;	
		$lft_comment_number = 0;					
		foreach($lines as $line){
		
			
			
			//filter stuff
			if(strpos($line, '=')){											
				//no comment
				
				if(!$first){
					$language_values .=  $separator;
				}
			
				$temp = $line;											
				$pos = strpos($temp, '=');
				$varname = substr($temp, 0, $pos);
				$value = substr($temp, $pos+1, 999); 	
				
				$language_var_names .= $varname.'
';
				$value = trim($value);	
				$value = str_replace('"','',$value);				
				$value = str_replace('<br />', ' ', $value);																	
				$language_values .= $value;	
				$first = 0;
							
			}elseif($comments){
				//comment
				
				if(!$first){
					$language_values .=  $separator;
				}
				
				$lft_comment_number++;
				$varname = '_lft_comment_'.$lft_comment_number;
				$line = str_replace('#', ';', $line);
				$line = trim($line);
				$value = '<span class="notranslate">'.$line.'</span>';
				
				$language_var_names .= $varname.'
';
				$value = trim($value);	
				$value = str_replace('"','',$value);				
				$value = str_replace('<br />', ' ', $value);																	
				$language_values .= $value;	
				$first = 0;
				
			}
			
		}
		
		$strings = addslashes($language_values);
		$varnames_trans = addslashes($language_var_names);
		
		//if there is already a users row for this user do update
		if($id){			
			$database->setQuery( "UPDATE #__languagefiletool SET ori_lang='$ori_lang', original_file='$original_file_db', lang_format_trans='$lang_format_trans', filename='$filename', strings='$strings', varnames_trans='$varnames_trans', prefix='$prefix', suffix='$suffix', only_new_strings='$only_new_strings', comments='$comments' WHERE user='$user_id' ");
			$database->query();
		}else{				
			$database->setQuery( "INSERT INTO #__languagefiletool SET user='$user_id', ori_lang='$ori_lang', original_file='$original_file_db', lang_format_trans='$lang_format_trans', filename='$filename', strings='$strings', varnames_trans='$varnames_trans', prefix='$prefix', suffix='$suffix', only_new_strings='$only_new_strings', comments='$comments' ");
			$database->query();
		}	
		
		$url = 'index.php?option=com_languagefiletool&view=translatea';
		$this->setRedirect($url, JText::_('COM_LANGUAGEFILETOOL_SETTINGS_SAVED'));	
		
	}
	
	//deprecated google stuff
	/*
	function translate_string($string, $to_lang, $from_lang){
	
		require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_languagefiletool'.DS.'helpers'.DS.'googleTranslate.class.php');

		$gt = new GoogleTranslateWrapper();			
	
		//textstring needs to be less then 5000 characters, so split it up if needed
		$limit = 5000;
		$max_chars = $limit-10;
		$chunks = str_split($string, $max_chars);
		$total_chunks = count($chunks);	
		//echo $total_chunks;			
		$add_to_next_chunk = '';
		$translated_string = '';
		for($n = 0; $n < count($chunks); $n++){	
			$chunks[$n] = $add_to_next_chunk.$chunks[$n];
			if(substr($chunks[$n], $max_chars-1, $max_chars)=='<'){	
				//take out that last incomplete br-tag and add it to the next chunk
				$chunks[$n] = substr($chunks[$n], 0, $max_chars-1);
				$add_to_next_chunk = '<';					
			}
			if(substr($chunks[$n], $max_chars-2, $max_chars)=='<b'){					
				$chunks[$n] = substr($chunks[$n], 0, $max_chars-2);
				$add_to_next_chunk = '<b';
			}
			if(substr($chunks[$n], $max_chars-3, $max_chars)=='<br'){
				$chunks[$n] = substr($chunks[$n], 0, $max_chars-3);
				$add_to_next_chunk = '<br';
			}
			if(substr($chunks[$n], $max_chars-4, $max_chars)=='<br '){					
				$chunks[$n] = substr($chunks[$n], 0, $max_chars-4);
				$add_to_next_chunk = '<br ';
			}
			if(substr($chunks[$n], $max_chars-5, $max_chars)=='<br /'){
				$chunks[$n] = substr($chunks[$n], 0, $max_chars-5);
				$add_to_next_chunk = '<br /';
			}
			
			//translate the string with google
			$translated_string .= $gt->translate($chunks[$n], $to_lang, $from_lang);				
		}
		
		return $translated_string;
		
	}
		
	
	function translate_string($string, $to_lang, $from_lang){
	
		require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_languagefiletool'.DS.'helpers'.DS.'simple_html_dom.php');
		$uri = JFactory::getURI();
		$url = $uri->base().'index.php?option=com_languagefiletool&view=translatec&layout=translation_text&tmpl=component&source_lang='.$from_lang.'&target_lang='.$to_lang;
		
		$html = file_get_html($url);
		
		
		
		//echo $html;
		//exit;
		//$html->find('div[id=hello]', 0)->innertext = 'foo';

		//$translated_string = ;		
		
		return $translated_string;
		
	}
	*/
	
	function do_convert(){
	
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');		
		
		$database = JFactory::getDBO();
		
		//check if there already is a row for this user
		$id = 0;
		$database->setQuery("SELECT id "
		."FROM #__languagefiletool "
		."WHERE user='$user_id' "		
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$id = $row->id;	
		}
		
		$lang_format_convert = JRequest::getVar('lang_format_convert', '5to6');		
		$extensionname = JRequest::getVar('extensionname', '');
		$prefix = JRequest::getVar('prefix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$prefix_db = addslashes($prefix);
		$suffix = JRequest::getVar('suffix', '' ,'post', 'string', JREQUEST_ALLOWHTML);
		$suffix_db = addslashes($suffix);
		$searchstring = JRequest::getVar('searchstring', '');		
		$searchstring = addslashes($searchstring);
		$comments = JRequest::getVar('comments', '');
		
		//if there is already a users row for this user do update
		if($id){			
			$database->setQuery( "UPDATE #__languagefiletool SET lang_format_convert='$lang_format_convert', extensionname='$extensionname', prefix='$prefix', suffix='$suffix', searchstring='$searchstring', comments='$comments' WHERE user='$user_id' ");
			$database->query();
		}else{				
			$database->setQuery( "INSERT INTO #__languagefiletool SET user='$user_id', lang_format_convert='$lang_format_convert', extensionname='$extensionname', prefix='$prefix', suffix='$suffix', searchstring='$searchstring', comments='$comments' ");
			$database->query();
		}
		
		//do converting in view
			
		$url = 'index.php?option=com_languagefiletool&view=convert&convert=go';
		$this->setRedirect($url, JText::_('COM_LANGUAGEFILETOOL_FILES_CONVERTED'));
	}
	
	function do_convertphp(){
	
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');		
		
		$database = JFactory::getDBO();
		
		//check if there already is a row for this user
		$id = 0;
		$database->setQuery("SELECT id "
		."FROM #__languagefiletool "
		."WHERE user='$user_id' "		
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$id = $row->id;	
		}		
			
		$searchstring = JRequest::getVar('searchstring', '');		
		$searchstring = addslashes($searchstring);
		$extensionname = JRequest::getVar('extensionname', '');
		$lang_format_convert = JRequest::getVar('lang_format_convert', '');	
		
		//if there is already a users row for this user do update
		if($id){			
			$database->setQuery( "UPDATE #__languagefiletool SET searchstring='$searchstring', extensionname='$extensionname', lang_format_convert='$lang_format_convert' WHERE user='$user_id' ");
			$database->query();
		}else{				
			$database->setQuery( "INSERT INTO #__languagefiletool SET user='$user_id', searchstring='$searchstring', extensionname='$extensionname', lang_format_convert='$lang_format_convert' ");
			$database->query();
		}
		
		//do converting in view
		
		//redirect	
		$url = 'index.php?option=com_languagefiletool&view=convertphp&convert=go';		
		$this->setRedirect($url, JText::_('COM_LANGUAGEFILETOOL_FILES_CONVERTED'));
	}	
	
	function display_footer(){		
		echo '<div class="smallgrey" id="lft_footer">';
		?>
		<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but04.gif" border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!">
<img alt="" border="0" src="https://www.paypal.com/nl_NL/i/scr/pixel.gif" width="1" height="1">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
">
		</form>
		<br />
		<?php		
		echo '<table>';
		echo '<tr>';
		echo '<td class="text_right">';
		echo '<a href="http://www.pages-and-items.com/extensions/language-file-tool" target="_blank">Language File Tool</a>';
		echo '</td>';
		echo '<td class="five_pix">';
		echo '&copy;';
		echo '</td>';
		echo '<td>';
		echo '2010 - 2011 Carsten Engel';		
		echo '</td>';
		echo '</tr>';
		echo '<tr>';
		echo '<td class="text_right">';
		echo JText::_('JVERSION');
		echo '</td>';
		echo '<td class="five_pix">';
		echo '=';
		echo '</td>';
		echo '<td>';
		echo $this->version.' ';		
		echo ' <a href="http://www.gnu.org/licenses/gpl-2.0.html" target="blank">GNU/GPL License</a>';		
		echo '</td>';
		echo '</tr>';
		//version checker
		//if($this->fua_config['version_checker']){
			echo '<tr>';
			echo '<td class="text_right">';
			echo JText::_('COM_LANGUAGEFILETOOL_LATEST_VERSION');
			echo '</td>';
			echo '<td class="five_pix">';
			echo '=';
			echo '</td>';
			echo '<td>';
			$app = &JFactory::getApplication();
			$latest_version_message = $app->getUserState( "com_languagefiletool.latest_version_message", '');
			if($latest_version_message==''){
				$latest_version_message = JText::_('COM_LANGUAGEFILETOOL_VERSION_CHECKER_NOT_AVAILABLE');
				$url = 'http://www.pages-and-items.com/latest_version_lft_j1.6.txt';		
				$file_object = @fopen($url, "r");		
				if($file_object == TRUE){
					$version = fread($file_object, 1000);
					$latest_version_message = $version;
					if($this->version!=$version){
						$latest_version_message .= ' <span style="color: red;">'.JText::_('COM_LANGUAGEFILETOOL_NEWER_VERSION').'</span>';						
						$download_url = 'http://www.pages-and-items.com/extensions/language-file-tool';						
						$latest_version_message .= ' <a href="'.$download_url.'" target="_blank">'.JText::_('COM_LANGUAGEFILETOOL_DOWNLOAD').'</a>';
					}else{
						$latest_version_message .= ' <span style="color: #5F9E30;">'.JText::_('COM_LANGUAGEFILETOOL_IS_LATEST_VERSION').'</span>';
					}
					fclose($file_object);
				}				
				$app->setUserState( "com_languagefiletool.latest_version_message", $latest_version_message );
			}
			echo $latest_version_message;
			echo '</td>';
			echo '</tr>';
			echo '</table>';	
		//}						
		echo '</div>';		
	}
	
	function convert_to_utf8($content){
		if(!mb_check_encoding($content, 'UTF-8') || !($content === mb_convert_encoding(mb_convert_encoding($content, 'UTF-32', 'UTF-8' ), 'UTF-8', 'UTF-32'))){
		
			$content = mb_convert_encoding($content, 'UTF-8');			
		}
		return $content;
	} 
	
	function create_file_and_write($target_file, $string){
	
		//make sure string is utf-8
		$string = $this->convert_to_utf8($string);
	
		//to make sure the file is a proper utf8.ini file we copy an empty file
		$empty_file = JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_languagefiletool'.DS.'empty_file.ini';		
		JFile::copy($empty_file, $target_file);	
		
		//write to the file		
		JFile::write($target_file, $string);
	
	}
	
	
}
?>