<?php
/**
* @package Language-File-Tool (com_languagefiletool)
* @version 1.2.3
* @copyright Copyright (C) 2010-2011 Carsten Engel. All rights reserved.
* @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html 
* @author http://www.pages-and-items.com
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class languagefiletoolViewconvert extends JView{

	function display($tpl = null){
	
		$controller = new languagefiletoolController();	
		$this->assignRef('controller', $controller);
		
		//get settings for this user is exist
		//get user id		
		$user =& JFactory::getUser();
		$user_id = $user->get('id');
		
		
		$database = JFactory::getDBO();
		
		//check if there already is a row for this user
		$extensionname = '';
		$prefix = '';
		$suffix = '';	
		$lang_format_convert = '';
		$searchstring = '';
		$comments = '';	
		$database->setQuery("SELECT lang_format_convert, extensionname, prefix, suffix, searchstring, comments "
		."FROM #__languagefiletool "
		."WHERE user='$user_id' "		
		);
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$lang_format_convert = $row->lang_format_convert;			
			$extensionname = $row->extensionname;	
			$prefix = $row->prefix;	
			$suffix = $row->suffix;	
			$searchstring = $row->searchstring;	
			$comments = $row->comments;
		}	
		if($lang_format_convert==''){
			$lang_format_convert = '5to6';
		}		
		$this->assignRef('lang_format_convert', $lang_format_convert);			
		$this->assignRef('extensionname', $extensionname);
		$this->assignRef('prefix', $prefix);
		$this->assignRef('suffix', $suffix);
		$this->assignRef('searchstring', $searchstring);
		$this->assignRef('comments', $comments);
		
		$this->controller->get_language_array();
		$lang_array = $this->controller->lang_array;		
		$this->assignRef('lang_array', $lang_array);	
		
		//check if we are ready for conversion
		$convert = JRequest::getVar('convert', '');
		$this->assignRef('convert', $convert);
				
		parent::display($tpl);
	}
	
}

jimport( 'joomla.filesystem.folder' );

class convert_language_files{
							
	public $source_dir = '_languagefiletool_langfiles_original';	
	public $target_dir = '_languagefiletool_langfiles_processed';
	public $lang_format_convert = '5to6';
	public $extension = '';
	public $prefix = '';
	public $suffix = '';
	public $searchstring = '';
	public $comments = '';
	public $lang_array = array();
	
	function convert_language_files($lang_format_convert, $extension, $prefix, $suffix, $searchstring, $lang_array, $comments){		
		$this->lang_format_convert = $lang_format_convert;
		$this->extension = $extension;
		$this->prefix = $prefix;
		$this->suffix = $suffix;
		$this->searchstring = $searchstring;
		$this->lang_array = $lang_array;
		$this->comments = $comments;
		$this->folders($this->source_dir);	
		
							
	}
	
	function file_convert_language_files($file){
		
		$filename_array = explode(DS, $file);		
		$filename_array = array_reverse($filename_array);		
		$file_name_old = $filename_array[0];		
		$renamed = 0;
		if(strpos($file_name_old, '.php')){
			//converting from joomla 1.0 php files, so rename to new format
			$pos = strpos($file_name_old, '.php');
			$temp = substr($file_name_old, 0, $pos);			
			for($n = 0; $n < count($this->lang_array); $n++){				
				if(strtolower($temp)==strtolower($this->lang_array[$n][2])){
					$file_name_new = $this->lang_array[$n][1].'.'.$this->extension.'.ini';					
					$renamed = 1;
				}
			}
		}
		
		if (!$fp = @fopen(JPATH_ROOT.DS.$file, "r")) {			
			die('not reradable');
			return false;
		}						
		$filename = JPATH_ROOT.DS.$file;					
		$fstring = fread($fp, filesize($filename));
		fclose ($fp);				
		
		$fstring = $this->do_string_replacement($fstring);		
										
		$target = str_replace($this->source_dir, $this->target_dir, $file);	
		
		//if converting from joomla 1.0 format with .php to .ini rename files
		if($renamed){
			$target = str_replace($file_name_old, $file_name_new, $target);
		}	
		
		$target_file = JPATH_ROOT.DS.$target;
		
		$controller = new languagefiletoolController();	
		$controller->create_file_and_write($target_file, $fstring);	
		
	}
	
	
	
	function files($currentfolder){
		$files = JFolder::files(JPATH_ROOT.DS.$currentfolder);	
		foreach($files as $file){			
			echo '<p>'.$file.'</p>';
			$this->file_convert_language_files($currentfolder.DS.$file);
		}
	}
	
	
	function folders($currentfolder){									
		
		$this->files($currentfolder);								
		$folders = JFolder::folders(JPATH_ROOT.DS.$currentfolder);								
		foreach($folders as $folder){
												
			$this->folders($currentfolder.DS.$folder);
		}
	}	
	
	function do_string_replacement($string){
									
		$lines = explode("\n", $string);		
			
		$br = '
';
		$freshlines = $br;
		$freshlines .= $this->prefix;
		$freshlines .= $br.$br;
			
		$extension = strtoupper($this->extension);
		foreach($lines as $line){
				
			//filter out empty lines and comments
			if(
			(($this->lang_format_convert=='5to6' || $this->lang_format_convert=='6to5') && strpos($line, '='))
			||
			(($this->lang_format_convert=='1to5' || $this->lang_format_convert=='1to6') && strpos($line, 'efine('))
			){									
				
				$temp = $line;
				
				if($this->lang_format_convert=='5to6' || $this->lang_format_convert=='6to5'){									
					$pos = strpos($temp, '=');
					$varname = substr($temp, 0, $pos);	
					$varname = str_replace(' ', '_', $varname);					
					
					$value = substr($temp, $pos+1, 999); 
					$value = str_replace('"', '', $value);						
				}else{
					//from 1.0 format														
					$temp = str_replace('define(\'','',$temp);					
					$temp = str_replace('\');','[end888]',$temp);					
					if(strpos($temp, '\',\'')){
						//no space
						$temp = str_replace('\',\'','[start888]',$temp);
					}elseif(strpos($temp, '\', \'')){
						//got the extra space
						$temp = str_replace('\', \'','[start888]',$temp);
					}
					
					$pos = strpos($temp, '[start888]');
					$varname = substr($temp, 0, $pos); 
					$varname = str_replace($this->searchstring ,'',$varname);						
					$varname = strtoupper($varname);
					$varname = str_replace(' ', '_', $varname);
											
					
					$value = substr($temp, $pos+10, 999); 
					$pos_end = strpos($value, '[end888]');
					$value = substr($value, 0, $pos_end); 
					
				}
																		
				$varname = trim($varname);
				$value = trim($value);
				
				
				//lang line
				if($this->lang_format_convert=='5to6' || $this->lang_format_convert=='1to6'){
					//from 1.5 to 1.6						
					$freshline = $extension.'_'.strtoupper($varname).'="'.$value.'"';
				}elseif($this->lang_format_convert=='6to5' || $this->lang_format_convert=='1to5'){
					//from 1.6 to 1.5
					$varname = str_replace($extension.'_', '', $varname);
					$freshline = strtoupper($varname).'='.$value;
				}	
					
				
				$freshlines .= $freshline.$br;
				
			}elseif($this->comments){				
				
				//comment
				$freshline = str_replace('#', ';', $line);
				$freshline = trim($freshline);
				$freshline = $freshline;
				$freshlines .= $freshline.$br;
				
			}	
				
				
				
		}			
									
		$freshlines .= $this->suffix;
		
		$string = $freshlines;
		
		return $string;
	}

}
?>