<?php
defined('_JEXEC') or die;
// Create component view for Joomla! 1.5 or 1.6.
// The classes are defined in ../../../functions.php file and encapsulate 
// version-specific queries and formatting.
if ($GLOBALS['version']->RELEASE == '1.6') {
    $component = new ArtxContent16($this, $this->params);
    $article = $component->articleListItem($this->item);
    JHtml::addIncludePath(JPATH_COMPONENT . DS . 'helpers');
} else {
    $component = new ArtxContent15($this, $this->params);
    $article = $component->articleListItem($this->item);
}


$params = $article->getArticleViewParameters();
if ($article->titleVisible) {
    $params['header-text'] = $this->escape($article->title);
    if (strlen($article->titleLink))
        $params['header-link'] = $article->titleLink;
}
// Build article content
$content = '';
if (!$article->isPublished)
    $content .= $article->beginUnpublishedArticle();
if (!$article->showIntro)
    $content .= $article->event('afterDisplayTitle');
$content .= $article->event('beforeDisplayContent');
$content .= $article->introText();
if ($article->showReadmore)
    $content .= $article->readmore();
$content .= $article->event('afterDisplayContent');
if (!$article->isPublished)
    $content .= $article->endUnpublishedArticle();
$params['content'] = $content;
// Change the order of "if" statements to change the order of article metadata footer items.
if ($article->showParentCategory || $article->showCategory)
  $params['metadata-footer-icons'][] = $article->categories();
// Render article
echo $article->article($params);

