<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

global $mainframe;
if(!is_object($mainframe)) {
	$app =& JFactory::getApplication();
}
else
{
	$app = $mainframe;
}
$app->registerEvent( 'onSearch', 'plgSearchDjcatalog2Items' );
$app->registerEvent( 'onSearchAreas', 'plgSearchDjcatalog2Areas' );

JPlugin::loadLanguage( 'plg_search_djcatalog2', JPATH_ADMINISTRATOR );

/**
 * @return array An array of search areas
 */
function &plgSearchDjcatalog2Areas()
{
	static $areas = array(
		'djcatalog2' => 'PLG_SEARCH_DJCATALOG2_DJCATALOGITEMS'
	);
	return $areas;
}

function plgSearchDjcatalog2Items( $text, $phrase='', $ordering='', $areas=null )
{
	$db		=& JFactory::getDBO();
	$searchText = $text;

	require_once(JPATH_SITE.DS.'components'.DS.'com_djcatalog2'.DS.'helpers'.DS.'route.php');

	if (is_array( $areas )) {
		if (!array_intersect( $areas, array_keys( plgSearchDjcatalog2Areas() ) )) {
			return array();
		}
	}

	// load plugin params info
 	$plugin =& JPluginHelper::getPlugin('search', 'djcatalog2');
 	$pluginParams = new JParameter( $plugin->params );

	$limit = $pluginParams->def( 'search_limit', 50 );

	$text = trim( $text );
	if ( $text == '' ) {
		return array();
	}

	switch ( $ordering ) {
		case 'alpha':
			$order = 'i.name ASC';
			break;

		case 'category':
		case 'popular':
		case 'newest':
		case 'oldest':
		default:
			$order = 'i.name DESC';
	}


	$text	= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
	$query = ' SELECT i.id AS id, i.name AS title, i.intro_desc AS intro, c.id AS ccategory_id, c.name AS category, i.description as text, i.metakey as metakey, i.metadesc as metadesc, '
			. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug, '
			. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug '
			. ' FROM #__djc2_items AS i '
			. ' LEFT JOIN #__djc2_categories AS c ON c.id = i.cat_id '
			. ' WHERE ( i.name LIKE '.$text
			. ' OR i.intro_desc LIKE '.$text
			. ' OR i.description LIKE '.$text
			. ' OR i.metadesc LIKE '.$text
			. ' OR i.metakey LIKE '.$text.' )'
			. ' AND i.published = 1'
			. ' GROUP BY id'
			. ' ORDER BY '. $order
		;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();
	
	$count = count( $rows );
	for ( $i = 0; $i < $count; $i++ )
	{
		$rows[$i]->href 	= JRoute::_(DJCatalogHelperRoute::getItemRoute($rows[$i]->slug, $rows[$i]->catslug));
		$rows[$i]->section 	= JText::_('PLG_SEARCH_DJCATALOG2_DJCATALOGITEMS').': '.$rows[$i]->category;
	}
	$return = array();
	
	foreach($rows as $key => $section) {
		if(searchHelper::checkNoHTML($section, $searchText, array('title', 'text', 'intro', 'metadesc', 'metakey'))) {
			$return[] = $section;
		}
	}
	return $return;
}
