<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');
require_once(dirname(__FILE__).DS.'helper.php');
require_once(JPATH_BASE.DS.'components'.DS.'com_djcatalog2'.DS.'helpers'.DS.'route.php');
$lang =& JFactory::GetLanguage();
$lang->load('com_djcatalog2');
$p = new DJCatalog2ModProducer();
$producers = $p->getProducers();
$cid = null;

if (JRequest::getVar('cid',0,'default','int') != 0 && !$params->get('filter')) {
	$cid = JRequest::getVar('cid',0,'default','int');
}
else $cid = 0;

$order = JRequest::getVar('order','i.ordering','default','string');
$orderDir = JRequest::getVar('dir','asc','default','cmd');
$prod_id = JRequest::getVar('pid', 0, 'default', 'string');
$search = JRequest::getVar('search', '', 'default', 'string');

$Itemid = JRequest::getVar('Itemid', 0, 'default','int');

$layout = $params->get('layout', 0);
if ($layout == 1)	$layout = 'items';
else $layout ='itemstable';

?>

<form action="index.php" method="post" name="producersForm" id="producersForm" >
	<input type="hidden" name="option" value="com_djcatalog2" />
	<input type="hidden" name="view" value="<?php echo $layout; ?>" />
	<input type="hidden" name="limitstart" value="0" />
	<input type="hidden" name="order" value="<?php echo $order; ?>" />
	<input type="hidden" name="dir" value="<?php echo $orderDir; ?>" />
	<input type="hidden" name="cid" value="<?php echo $cid; ?>" />
	<input type="hidden" name="task" value="search" />
    <?php
		$options = array();
		$options[] = JHTML::_('select.option', 0,JText::_('MOD_DJC2PRODUCERS_CHOOSE_PRODUCER') );
		foreach($producers as $producer){
			$options[] = JHTML::_('select.option', $producer['prodslug'], $producer['name']);
			
		}

		echo JHTML::_('select.genericlist', $options, 'pid', 'onchange="producersForm.submit()"', 'value', 'text', $prod_id);
?>
<input type="submit" style="display: none;"/>
</form>
