<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

function DJC2renderMenu(&$root, $catid, $layout = 1, $expand) {
		
	$levels = array();
	DJC2makeDjCatTree(0, $levels, $root);
	if ($layout == 1)
		$lay = 'items';
	else $lay ='itemstable';
	if (count($levels))
		DJC2renderList($levels, 0, $catid, $lay, $expand);
}

function DJC2renderList(&$list, $current, $catid, $lay, $expand, $level=0) {
	
	foreach ($list[$current] as $key=>$value) {
		$active = false;
		$activeChildren = 0;
		$class='class="';
		$id='';
		DJC2checkIfActive($list, $key, $catid, $activeChildren);
		if ($key == $catid || $activeChildren) {
			$active = true;
			$class.='active';
			if ($key == $catid)
				$id='id="djcurrent"';
		}
		if (isset($list[$key]))
			if (count($list[$key]))
				$class.=' parent';
		$class.=' level'.$level.'"';
		echo('<li '.$class.' '.$id.'>');
		echo JHTML::link(JRoute::_(DJCatalogHelperRoute::getCategoryRoute($value['catslug'], $lay)), '<span>'.$value['name'].'</span>');
		if (isset($list[$key]) && ($active || $expand))
			if (count($list[$key])) {
			echo('<ul>');
			DJC2renderList($list, $key, $catid, $lay, $expand, $level+1);
			echo('</ul>');
		}
		echo('</li>');
	}
}

function DJC2checkIfActive (&$list, $current, $catid, &$check) {

	if (isset($list[$current]))
			if (count($list[$current])) {
		foreach ($list[$current] as $key=>$value) {
			if ($key == $catid) {
				$check++;
			}
			elseif (isset($list[$key]))
				if (count($list[$key]))
					DJC2checkIfActive($list, $key, $catid,$check);
		}
	}
}

function DJC2renderSelect(&$root, $catid) {
		
	$levels = array();
	DJC2makeDjCatTree(0, $levels, $root);
	if (count($levels))
		DJC2renderOptions($levels, 0, $catid, $selected);
}

function DJC2renderOptions(&$list, $current, $catid, $level=0) {
	
	foreach ($list[$current] as $key=>$value) {		
		if ($key == $catid)
			$selected='selected="selected"';
		$indent='';
		for ($i = 0; $i < $level; $i++) {
			$indent .= '--';
		}
		echo '<option value="'.$key.'">'.$indent.' '.$value.'</option>';
		if (count($list[$key])) {
			renderOptions($list, $key, $catid, $level+1);
		}
	}
}

function DJC2makeDjCatTree($parentid, &$tab, $table) {
	
	foreach($table as $value) {
		if ($value->parent_id == $parentid) {
			$catid = $value->id;
			$tab[$parentid][$catid]= array('catslug' => $value->catslug,  'name' => $value->name);
			DJC2makeDjCatTree($value->id, $tab, $table);
		}
	}	
}



class Djcatalog2ModelCategories{
	
	var $_categories;
	
	function getCategories(){
		$db= &JFactory::getDBO();
			$query = ' SELECT *, '
					.' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(":", id, alias) ELSE id END as catslug '
					.' FROM #__djc2_categories '
					.' WHERE published = 1 '
					.' ORDER BY ordering';
			$db->setQuery($query);
			$_categories=$db->loadObjectList();
		

		return $_categories;
	}
}
?>
