<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');
JHTML::_( 'behavior.modal' );

class DJCatalog2ViewProducer extends JView {
	function display($tpl = null) {
		$app =& JFactory::getApplication();
		
		$document=& JFactory::getDocument();
		$params		=& $app->getParams('com_djcatalog2');
		$model =& $this->getModel();
	   	$menus = &JSite::getMenu();
		$menu  = $menus->getActive();
		$dispatcher	=& JDispatcher::getInstance();
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		
		$item = & $model->getData();
		
		/* If Item not published set 404 */
		if (($item->id == 0))
		{
			$id = JRequest::getVar( 'pid', '', 'default', 'int' );
			return JError::raiseError( 404, JText::_( 'COM_DJCATALOG2_PRODUCER_NOT_FOUND') );
		}
		
		/* Get/set page title */
		if (is_object( $menu ) && isset($menu->query['view']) && $menu->query['view'] == 'showproducer' && isset($menu->query['pid']) && $menu->query['pid'] == $item->id) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	$item->name);
			}
		} else {
			$params->set('page_title',	$item->name);
		}
		$document->setTitle( $params->get( 'page_title' ) );
		
		if ($app->getCfg('MetaTitle') == '1') {
			$app->addMetaTag('title', $item->name);
		}

		/* pathway */
		if ( (JRequest::getInt('pid') != $item->id) || (is_object( $menu ) && isset($menu->query['view']) && $menu->query['view'] != 'producer' )) {
			$pathway =& $app->getPathWay();
			$pathway->addItem($item->name, '');
		}
		
		/* Images, files & price format */
		$images = new DJCatalogImage();
		
		/* plugins */
		JPluginHelper::importPlugin('djcatalog2');
		$results = $dispatcher->trigger('onPrepareItemDescription', array (& $item, & $params, $limitstart));
		
		$this->assignref('item', $item);
		$this->assignref('images', $images);
		$this->assignref('params', $params);
		
		parent::display($tpl);
	}
}

?>