<?php
/**
* @version 2.13
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');
JHTML::_( 'behavior.modal' );

class DJCatalog2ViewItemstable extends JView {
	function display($tpl = null) {
		$view = JRequest::getVar('view', 'itemstable');
		$app = JFactory::getApplication();
		$document= JFactory::getDocument();
		$params =  JComponentHelper::getParams( 'com_djcatalog2' );
		$model = $this->getModel();
	    $menus = JSite::getMenu();
		$menu  = $menus->getActive();
		$layout = JRequest::getVar('layout', 'default', 'default', 'string');
		$dispatcher	= JDispatcher::getInstance();
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		$cid = (int) @$menu->query['cid'];
		
		$limit_items_show = $params->get('limit_items_show',10);
		JRequest::setVar('limit', $limit_items_show);
		
		$filter_catid		= JRequest::getVar( 'cid',0,'default','int' );
		$filter_producerid	= JRequest::getVar( 'pid',0,'default','string' );
		$filter_order		= JRequest::getVar( 'order',$params->get('items_default_order','i.ordering'),'default','cmd' );
		$filter_order_Dir	= JRequest::getVar( 'dir',	$params->get('items_default_order_dir','asc'),'default','word' );
		$search				= JRequest::getVar( 'search','','default','string' );
		$search				= JString::strtolower( $search );
		if (strlen($search) > 0 && (strlen($search)) < 3 || strlen($search) > 20) {
			 JError::raiseNotice(  E_USER_NOTICE, JText::_( 'COM_DJCATALOG2_SEARCH_RESTRICTION') );
		}
		
		if ($filter_order_Dir == '' || $filter_order_Dir == 'desc') {
			$lists['order_Dir'] = 'asc';			
		} else {
			$lists['order_Dir'] = 'desc';
		}
		$lists['order'] = $filter_order;
		
		$model = $this->getModel();
		$list = $model->getList();
		$total = $model->getTotal();
		
		$pagination = $model->getPagination();
		
		$javascript 	= 'onchange="document.djcatalogForm.submit();"';
		
		// search filter
		$lists['search']= $search;
		
		// category filter
		$categories = $model->getCategories();
		$tree = new CatTree();
        $tree->buildTree($categories);
        $root = & $tree->getRoot();
		
		$options = renderCategoryFilter($root);
		$lists['categories'] = JHTML::_('select.genericlist', $options, 'cid', $javascript, 'value', 'text', $filter_catid);
		
		// producer filter
		$producers_first_option = new stdClass();
		$producers_first_option->value = '';
		$producers_first_option->text = '- '.JText::_('COM_DJCATALOG2_SELECT_PRODUCER').' -';
		$producers_first_option->disabled = null;
		$prodList = $model->getProducers();
		$producers = count($prodList) ? array_merge(array($producers_first_option),$prodList) : array($producers_first_option);
		$lists['producers'] = JHTML::_('select.genericlist', $producers, 'pid', $javascript, 'value', 'text', $filter_producerid);
		
		$images = new DJCatalogImage();
		$files = new DJCatalogFile();
		
		// price settings
		$price_decimal_separator = null;
		$price_thousands_separator = null;
		
		switch($params->get('thousand_separator',0)) {
			case 0: $price_thousands_separator=''; break;
			case 1: $price_thousands_separator=' '; break;
			case 2: $price_thousands_separator='\''; break;
			case 3: $price_thousands_separator=','; break;
			default: $price_thousands_separator=''; break;
		}
		
		switch($params->get('decimal_separator',0)) {
			case 0: $price_decimal_separator=','; break;
			case 1: $price_decimal_separator='.'; break;
			default: $price_decimal_separator=','; break;
		}
		
		$category = $model->getCategory();
		$subcategories = $model->getSubCategories();
		
		/* If Cateogory not published set 404 */
		if ($category) {
			if ($category->published == 0)
			{
				return JError::raiseError( 404, JText::_( 'COM_DJCATALOG2_PRODUCT_NOT_FOUND') );
			}
		}
		
		/* Get/set page title */
		if (is_object( $menu ) && isset($menu->query['view']) && $category && (($menu->query['view'] == 'items' && isset($menu->query['cid']) && $menu->query['cid'] == $category->id))) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	$category->name);
			}
		} else if ($category){
			$params->set('page_title',	$category->name);
		}
		$document->setTitle( $params->get( 'page_title' ) );
		
		if ($menu && (@$menu->query['option'] != 'com_djcatalog2' || $cid != @$category->id)) {
			$categories = Djc2Categories::getInstance(array('state'=>'1'));			
			$batchCategory = $categories->get($item->cat_id);
			$path = array(array('title' => $category->name, 'link' => ''));
			$batchCategory = $categories->get($category->parent_id);
			while ((@$menu->query['option'] != 'com_djcatalog2' || $id != @$category->id) && $batchCategory->id > 0)
			{
				$path[] = array('title' => $batchCategory->name, 'link' => DJCatalogHelperRoute::getCategoryRoute($batchCategory->catslug, 'itemstable'));
				$batchCategory = $categories->get($batchCategory->parent_id);
			}

			$path = array_reverse($path);
			$pathway = $app->getPathway();
			
			foreach ($path as $pathitem)
			{
				$pathway->addItem($pathitem['title'], $pathitem['link']);
			}
		}
		
		/* plugins */
		if ($category) {
			JPluginHelper::importPlugin('djcatalog2');
			$results = $dispatcher->trigger('onPrepareItemDescription', array (& $category, & $params, $limitstart));
		}
		
		$this->assignref('category',$category);
		$this->assignref('subcategories',$subcategories);
		
		$this->assignref('lists', $lists);
		$this->assignref('images', $images);
		$this->assignref('files', $files);
		$this->assignref('items', $list);
		$this->assignRef('lists',	$lists);
		$this->assignref('total', $total);
		$this->assignRef('pagination',	$pagination);
		$this->assignRef('params',	$params);
		$this->assignRef('price_decimal_separator',	$price_decimal_separator);
		$this->assignRef('price_thousands_separator',	$price_thousands_separator);

        parent::display($tpl);
	}
	
	function _orderDirImage ($order_current, $order='i.ordering', $dir='asc') {
		if ($dir == 'desc') $dir='asc';
		else $dir = 'desc';
		if ($order_current == $order) {
			return '<img class="djcat_order_dir" alt="'.$dir.'" src="'.JURI::base().'components/com_djcatalog2/theme/images/'.$dir.'.png'.'" />';			
		}
		else {
			return false;
		}
	}

}




