<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');
JHTML::_( 'behavior.modal' );

class DJCatalog2ViewItem extends JView {
	function display($tpl = null) {
		$app = JFactory::getApplication();
		$document= JFactory::getDocument();
		$params		= $app->getParams('com_djcatalog2');
		$model = $this->getModel();
	   	$menus = JSite::getMenu();
		$menu  = $menus->getActive();
		$dispatcher	=& JDispatcher::getInstance();
		$id = (int) @$menu->query['id'];
		$cid = (int) @$menu->query['cid'];
		
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		
		$item = $model->getData();
		/* If Item not published set 404 */
		if (($item->id == 0))
		{
			$id = JRequest::getVar( 'id', '', 'default', 'int' );
			return JError::raiseError( 404, JText::_( 'COM_DJCATALOG2_PRODUCT_NOT_FOUND') );
		}
		if (($item->cat_id)) {
			JRequest::setVar('cid',$item->cat_id);
		}
		
		/* Get/set page title */
		if (is_object( $menu ) && isset($menu->query['view']) && (($menu->query['view'] == 'item' && isset($menu->query['id']) && $menu->query['id'] == $item->id) || ($menu->query['view'] == 'items' && isset($menu->query['cid']) && $menu->query['cid'] == $item->cat_id) || ($menu->query['view'] == 'itemstable' && isset($menu->query['cid']) && $menu->query['cid'] == $item->cat_id))) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	$item->name);
			}
		} else {
			$params->set('page_title',	$item->name);
		}
		$document->setTitle( $params->get( 'page_title' ) );
		
		if ($item->metadesc) {
			$document->setDescription( $item->metadesc );
		}
		if ($item->metakey) {
			$document->setMetadata('keywords', $item->metakey);
		}

		if ($app->getCfg('MetaTitle') == '1') {
			$app->addMetaTag('title', $item->name);
		}

		if ($menu && (@$menu->query['option'] != 'com_djcatalog2' || @$menu->query['view'] == 'items' || @$menu->query['view'] == 'itemstable' || $id != $item->id )) {
			$categories = Djc2Categories::getInstance(array('state'=>'1'));			
			$category = $categories->get($item->cat_id);
			$view = ($menu->query['view'] == 'items' || $menu->query['view'] =='itemstable') ? $menu->query['view'] : 'items';
			$path = array(array('title' => $item->name, 'link' => ''));
			while ((@$menu->query['option'] != 'com_djcatalog2' || ( (@$menu->query['view'] == 'items' || @$menu->query['view'] == 'itemstable') && $cid != $category->id)) && $category->id > 0)
			{
				$path[] = array('title' => $category->name, 'link' => DJCatalogHelperRoute::getCategoryRoute($category->catslug, $view));
				$category = $categories->get($category->parent_id);
			}

			$path = array_reverse($path);
			$pathway = $app->getPathway();
			foreach ($path as $pathitem)
			{
				$pathway->addItem($pathitem['title'], $pathitem['link']);
			}
			
		}
		
		
		/* Images, files & price format */
		$images = new DJCatalogImage();
		$files = new DJCatalogFile();
		
		$price_decimal_separator = null;
		$price_thousands_separator = null;
		
		switch($params->get('thousand_separator',0)) {
			case 0: $price_thousands_separator=''; break;
			case 1: $price_thousands_separator=' '; break;
			case 2: $price_thousands_separator='\''; break;
			case 3: $price_thousands_separator=','; break;
			default: $price_thousands_separator=''; break;
		}
		
		switch($params->get('decimal_separator',0)) {
			case 0: $price_decimal_separator=','; break;
			case 1: $price_decimal_separator='.'; break;
			default: $price_decimal_separator=','; break;
		}
		
		/* plugins */
		JPluginHelper::importPlugin('djcatalog2');
		$results = $dispatcher->trigger('onPrepareItemDescription', array (& $item, & $params, $limitstart));
		
		$item->event = new stdClass();
		$results = $dispatcher->trigger('onAfterDJCatalogDisplayTitle', array (&$item, &$params, $limitstart));
		$item->event->afterDJCatalogDisplayTitle = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onBeforeDJCatalogDisplayContent', array (&$item, &$params, $limitstart));
		$item->event->beforeDJCatalogDisplayContent = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onAfterDJCatalogDisplayContent', array (&$item, &$params, $limitstart));
		$item->event->afterDJCatalogDisplayContent = trim(implode("\n", $results));
		
		$this->assignref('item', $item);
		$this->assignref('images', $images);
		$this->assignref('files', $files);
		$this->assignref('params', $params);
		$this->assignRef('price_decimal_separator',	$price_decimal_separator);
		$this->assignRef('price_thousands_separator',	$price_thousands_separator);
		
		parent::display($tpl);
	}
}

?>