/**
* @version 2.1
* @package DJ Catalog 2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
* DJ Catalog 2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ Catalog 2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ Catalog 2. If not, see <http://www.gnu.org/licenses/>.
*
*/
(function($){
function DJCatMatchModules(className){
	var maxHeight = 0;
	if ($$(className)) {
		var divs = $$(className);
		divs.each(function(element){
			maxHeight = Math.max(maxHeight, parseInt(element.getStyle('height')));
		});
		
		divs.setStyle('height', maxHeight);
	}
}

window.addEvent('load', function(){
	DJCatMatchModules('.djcat_blog_subcategory_bg');
    DJCatMatchModules('.djcat_blog_item_bg');
	
	var djcatpagebreak_acc = new Accordion('h3.djcat_h3acc', 'div.djcat_rowacc', {
		alwaysHide: false,
		display: 0,
		duration: 150,
		onActive: function(toggler){
			toggler.addClass('djcat_h3acc_active');
		},
    	onBackground: function(toggler){
			toggler.removeClass('djcat_h3acc_active');
		}
	});
	var djcatpagebreak_tab = new Accordion('li.djcat_litab', 'div.djcat_rowtab', {
		alwaysHide: false,
		display: 0,
		duration: 150,
		onActive: function(toggler){
			toggler.addClass('djcat_litab_active');
		},
    	onBackground: function(toggler){
			toggler.removeClass('djcat_litab_active'); 
		}
	});
});
})(document.id);

