<?php
/**
* @version 2.13
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class DJCatalog2ModelModfrontpage extends JModel {
	
	function getXml() {
		$moduleclass_sfx = JRequest::getVar( 'moduleclass_sfx', null, 'get', 'string', 0);
		$mid = (int)JRequest::getVar( 'moduleId', null, 'get', 'int', 0);
		$stitle = JRequest::getVar( 'stitle', null, 'get', 'string', 0);
		$scattitle = JRequest::getVar( 'scattitle', null, 'get', 'string', 0);
		$spag = JRequest::getVar( 'spag', null, 'get', 'int', 0);
		$orderby = JRequest::getVar( 'orderby', null, 'get', 'int', 0);
		$orderdir = JRequest::getVar( 'orderdir', 0, 'get', 'int', 0);
		$cols = (int)JRequest::getVar( 'cols', null, 'get', 'int', 0);
		$rows = (int)JRequest::getVar( 'rows', null, 'get', 'int', 0);
		$mainimage = JRequest::getVar( 'mainimg', 'large', 'get', 'string', 0);
		$trunc = (int)JRequest::getVar( 'trunc', '0', 'get', 'int', 0);
		$trunclimit = (int)JRequest::getVar( 'trunclimit', '0', 'get', 'int', 0);
		$paginationStart = (int)JRequest::getVar( 'pagstart', null, 'get', 'int', 0);
		$categories = JRequest::getVar( 'categories', null, 'get', 'string', 0);
		$catsw = JRequest::getVar( 'catsw', 0, 'get', 'int', 0);
		$categories = explode('|', $categories);
		
		$Itemid = JRequest::getVar('Itemid',0, 'get', 'int', 0);
		$path = JURI::base();
		/*
		 * Pagination
		 */
		
		$paginationQuery = 	'SELECT COUNT(*) '
							.' FROM #__djc2_items i '
							.' LEFT JOIN #__djc2_categories AS c ON c.id = i.cat_id '
							.' WHERE i.published=1 AND c.published=1 AND (';
		if ($catsw) {
			$paginationQueryFlag = 0;
			foreach ($categories as $value) {
				if ($paginationQueryFlag)
					$paginationQuery .= " OR i.cat_id='".$value."'";
				else {
					$paginationQuery .= "i.cat_id='".$value."'";
					$paginationQueryFlag = 1;
				}
			}
		}
		else {
			$paginationQuery .= '1';
		}
		$paginationQuery .= ');';
		$db =  JFactory::getDBO();
		$db->setQuery($paginationQuery);
		
		$itemsCount = $db->loadResult();
		$itemsPerPage = $rows * $cols;
		if ($spag == 1) {
			$paginationBar ='<pagination><![CDATA[';
			if ($itemsCount > $itemsPerPage && $itemsPerPage > 0) {
				for ($i = 0; $i < $itemsCount; $i = $i + $itemsPerPage) {
					$counter = (int)(($i+$itemsPerPage)/$itemsPerPage);
					if ($paginationStart == $i) $active='active';
					else $active='';
					$paginationBar .= '<span class="button '.$active.'" style="cursor: pointer;" onclick="DJFrontpage_'.$mid.'.loadPage('.$i.'); return false;">'.$counter.'</span>&nbsp;';
				}
				
			}
			$paginationBar .= ']]></pagination>';
		}
		
		$orderbydir = ($orderdir == 0) ? ' ASC':' DESC'; 
		$orderbyQuery='';	
		switch ($orderby) {
			case '0':
				$orderbyQuery = 'ORDER BY i.ordering'.$orderbydir.', i.name';
				break;
			case '1':
				$orderbyQuery = 'ORDER BY i.name'.$orderbydir.', i.ordering';
				break;
			case '2':
				$orderbyQuery = 'ORDER BY c.ordering'.$orderbydir.', i.ordering';
				break;
			case '3':
				$orderbyQuery = 'ORDER BY p.ordering'.$orderbydir.', i.ordering';
				break;
			case '4':
				$orderbyQuery = 'ORDER BY i.price'.$orderbydir.', i.ordering';
				break;
			case '5':
				$orderbyQuery = 'ORDER BY i.id'.$orderbydir.', i.ordering';
				break;
			default:
				$orderbyQuery = 'ORDER BY i.ordering'.$orderbydir.', i.name';
				break;
		}
		
		$categoriesQuery = 	'SELECT i.*, c.id AS ccategory_id, c.name AS cat_name, p.id AS pproducer_id, '
							.' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug, '
							.' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug '
							.' FROM #__djc2_items i '
							.' LEFT JOIN #__djc2_categories AS c ON c.id = i.cat_id '
							.' LEFT JOIN #__djc2_producers AS p ON p.id = i.producer_id '
							.' WHERE i.published=1  AND c.published=1 AND (';
		if ($catsw) {
			$categoriesQueryFlag = 0;
			foreach ($categories as $value) {
				if ($categoriesQueryFlag)
					$categoriesQuery .= " OR i.cat_id='".$value."'";
				else {
					$categoriesQuery .= "i.cat_id='".$value."'";
					$categoriesQueryFlag = 1;
				}
			}
		}
		else {
			$categoriesQuery .= "1";
		}
		$categoriesQuery .= ") ".$orderbyQuery." LIMIT ".$paginationStart.", ".$itemsPerPage.";";
		$db->setQuery($categoriesQuery);
		$items = $db->loadObjectList();
		
		
		$output = '<?xml version="1.0"?><contents>';
		$gallery ='';
		for ($i = 0; $i  < count($items); $i++) {
			$field_controller	= new DJCatalogImage();
			$images = $field_controller->getImages($items[$i]->image_url);
			
			$title = '';
			if($stitle == 1) 
				{
					$title='<h3>'.$items[$i]->name.'</h3>';
				}
	
			$cattitle = '';
			if($scattitle == 1) 
				{
					$cattitle='<h2>'.$items[$i]->cat_name.'</h2>';
				}
			
			$readmore = JRoute::_(DJCatalogHelperRoute::getItemRoute($items[$i]->slug, $items[$i]->catslug));
			if ($trunc > 0 && $trunclimit >0) {
				$items[$i]->intro_desc = DJCatalogHelper::trimText($items[$i]->intro_desc, $trunclimit);
			}
			
			$output .= '<content>';
			if($scattitle == 1)
				$output .= '<category><![CDATA['.$cattitle.']]></category>';
			$output .= '<text><![CDATA['.$title.'<div class="djf_desc">'.$items[$i]->intro_desc.'</div>'.'<a class="readon" href="'.$readmore.'">'.JText::_('COM_DJCATALOG2_READMORE').'</a>]]></text>';
			//$output .= '<image><![CDATA[<img src="'.$images[0]['medium'].'" alt="'.$items[$i]->name.'" />]]></image>';
			$output .= '<image><![CDATA['.$images[0][$mainimage].']]></image>';
			$output .= '<src><![CDATA['.$images[0]['original'].']]></src>';
			$output .= '</content>';
			
			$gallery .=	'<thumb><![CDATA[<a href="'.$readmore.'" onclick="DJFrontpage_'.$mid.'.loadItem('.$i.'); return false;"><img src="'.$images[0]['small'].'" alt="'.$items[$i]->name.'" /></a>]]></thumb>';
		}
		
		$all = $output.$gallery.$paginationBar;
		$all .= '</contents>';
		return $all;
	}
	
}

