<?php
/**
* @version 2.13
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class DJCatalog2ModelItems extends JModel {
	var $_list = null;
	var $_data = null;
	var $_pagination = null;
	var $_total = null;
	var $_categories = null;
	var $_subcategories = null;
	var $_category = null;
	var $_producers = null;
	var $_catpath = null;
		
	function __construct()
	{
		parent::__construct();

		$params = JComponentHelper::getParams( 'com_djcatalog2' );
		
		$view = JRequest::getVar('view');
		
		$limit		= JRequest::getVar( 'limit', $params->get('limit_items_show',10), 'default', 'int' );
		$limitstart	= JRequest::getVar( 'limitstart', 0, 'default', 'int' );

		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
	}
	function getList()
	{
		if (empty($this->_list))
		{
			$query = $this->_buildQuery();
			$this->_list = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}

		return $this->_list;
	}

	function getTotal()
	{
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}

	function getPagination()
	{
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	function _buildQuery()
	{
		$where		= $this->_buildContentWhere();
		$orderby	= $this->_buildContentOrderBy();

		$query = ' SELECT i.*, c.id AS ccategory_id, p.id AS pproducer_id, c.name AS category, p.name AS producer, '
			. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug, '
			. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug, '
			. ' CASE WHEN CHAR_LENGTH(p.alias) THEN CONCAT_WS(":", p.id, p.alias) ELSE p.id END as prodslug '
			. ' FROM #__djc2_items AS i '
			. ' LEFT JOIN #__djc2_categories AS c ON c.id = i.cat_id '
			. ' LEFT JOIN #__djc2_producers AS p ON p.id = i.producer_id '
			. $where
			. $orderby
		;
		return $query;
	}

	function _buildContentOrderBy()
	{
		$params = JComponentHelper::getParams( 'com_djcatalog2' );
		$filter_order		= JRequest::getVar( 'order',$params->get('items_default_order','i.ordering'),'default','cmd' );
		$filter_order_Dir	= JRequest::getVar( 'dir',	$params->get('items_default_order_dir','asc'),'default','word' );
		
		if ($filter_order != 'i.ordering' && $filter_order != 'category' && $filter_order != 'producer' && $filter_order != 'i.price' && $filter_order != 'i.name') {
			$filter_order = 'i.ordering';
		}
		if ($filter_order_Dir != 'asc' && $filter_order_Dir != 'desc') {
			$filter_order_Dir = 'asc';
		}
		
		
		if ($filter_order == 'i.ordering'){
			$orderby 	= ' ORDER BY i.ordering '.$filter_order_Dir.', c.ordering '.$filter_order_Dir;
		} else {
			$orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir.' , i.ordering, c.ordering ';
		}

		return $orderby;
	}

	function _buildContentWhere()
	{
		$view = JRequest::getVar('view');
		$db					=  JFactory::getDBO();
		
		$filter_catid		= (int) JRequest::getVar( 'cid',0,'default','string' );
		$filter_producerid	= (int) JRequest::getVar( 'pid',0,'default','string' );
		$search				= JRequest::getVar( 'search','','default','string' );
		$search				= JString::strtolower( $search );
		$search 			= trim(str_replace(array('#','>','<','\\'), '', $search));
		if (substr($search,0,1) == '"' && substr($search, -1) == '"') { 
			$search = substr($search,1,-1);
		}
		if (strlen($search) > 0 && (strlen($search)) < 3 || strlen($search) > 20) {
			 $search = null;
		}

		$where = array();

		if ($filter_catid >= 0) {
			$params = JComponentHelper::getParams( 'com_djcatalog2' );
			
			if ($params->get('product_catalogue')) {
				$where[] = 'i.cat_id = '.(int) $filter_catid;
			}
			else {
				$this->_db->setQuery("SELECT * FROM #__djc2_categories");
				$catlist = $this->_db->loadObjectList();
		    	$tree = new CatTree();
				$tree->buildTree($catlist);
		    	$root = $tree->getRoot();
				$categoryList = getChildrenList($root,$filter_catid);
				if ($categoryList) {
					$cids = implode(',', $categoryList);
					$where[] = 'i.cat_id IN ( '.$cids.' )';
				}
				else if ($filter_catid != 0){
					JError::raiseError( 404, JText::_("COM_DJCATALOG2_PAGE_NOT_FOUND") );
				}
			}
			
		}
		if ($filter_producerid > 0) {
			$where[] = 'i.producer_id = '.(int) $filter_producerid;
		}
		if ($search) {
			$where[] = '( LOWER(i.name) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false )
						.' OR LOWER(i.description) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false )
						.' OR LOWER(i.intro_desc) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ).')';
		}
		$where[] = 'i.published = 1';
		$where[] = 'c.published = 1';
		$where 		= ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );
		return $where;
	}
	function getCategory(){
		
		if(!$this->_category){
			if (!$id = (int) JRequest::getVar('cid',0,'default','default')) return false;
			
			$db= JFactory::getDBO();
			$query = "SELECT * FROM #__djc2_categories WHERE id = '".$id."'";

			$db->setQuery($query);
			$this->_category=$db->loadObject();

		}
		return $this->_category;
	}
	function getCategories(){
		if(!$this->_categories){
			$query = 'SELECT *, '
					.' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(":", id, alias) ELSE id END as catslug '
					.' FROM #__djc2_categories WHERE published=1 ORDER BY name';
			$this->_categories = $this->_getList($query,0,0);
		}
		return $this->_categories;
	}
	function getSubCategories(){
		if(!$this->_subcategories){
			$id = (int) JRequest::getInt('cid','0','default','default');
			$query = ' SELECT *, '
					.' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(":", id, alias) ELSE id END as catslug '
					.' FROM #__djc2_categories '
					.' WHERE parent_id="'.$id.'" AND published=1 ORDER BY ordering ';
			$this->_subcategories = $this->_getList($query,0,0);
		}
		return $this->_subcategories;
	}
	function getProducers(){
		if(!$this->_producers){
			$query = 'SELECT id, name as text, published as disabled, '
					. ' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(":", id, alias) ELSE id END as value '
					.' FROM #__djc2_producers ORDER BY text';
			$this->_producers = $this->_getList($query,0,0);
		}
		return $this->_producers;
	}	
	function getPath($catid){
		if(!$this->_catpath){
			$db= JFactory::getDBO();
			$query = "SELECT * FROM #__djc2_categories";
			$db->setQuery($query);
			$categories = $db->loadObjectList();
			$this->buildPath($categories, $catid,$this->_catpath);
		}
		return $this->_catpath;
	}
	
	function buildPath(&$categories, $catid, &$pathTable) {
		foreach ($categories as $row) {
			if ($row->id == $catid) {
				if ($row->parent_id == 0) {
					$pathTable[]= Array('id' => $row->id, 'name'=> $row->name);
					return true;
				}
				else {
					$pathTable[]= Array('id' => $row->id, 'name'=> $row->name);
					$this->buildPath($categories, $row->parent_id, $pathTable);
				}
			}
		}
		return false;
	}
	
}

