<?php
/**
* @version 2.12
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/
defined ('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.controller');
jimport('joomla.filesystem.file');
JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');
$lang =& JFactory::GetLanguage();
$lang->load('com_djcatalog2');

class DJCatalog2Controller extends JController
{
	
	function __construct($config = array())
	{
		parent::__construct($config);

		$this->registerTask( 'modfp',  'getFrontpageXMLData' );
	}
	
	function display()
	{	
		$app =& JFactory::getApplication();
		$document=& JFactory::getDocument();
		$db = & JFactory::getDBO();
		$params		=& $app->getParams('com_djcatalog2');
		
		$cssStyle = (int)$params->get('css',0);
		$cssFile = null;
		switch($cssStyle) {
			case 0:
			case 1:
			default: {
				$cssFile = 'djcatalog.css'; 
				break;
			}
			case 2: {
				$cssFile = 'djcatalog_light.css';
				break;
			} 
		}
		// include templates/template_name/css/djcatalog.css if exists, otherwise load default css
		$db->setQuery('SELECT template FROM #__templates_menu WHERE client_id = \'0\' LIMIT 1');
		$template = $db->loadResult();
		$styleSheet = null;
		if ($cssStyle == 1 && $template && file_exists(JPATH_BASE.DS.'templates'.DS.$template.DS.'css'.DS.$cssFile)) {
			$styleSheet = JURI::base().'templates/'.$template.'/css/'.$cssFile;
		}
		else {
			$styleSheet = JURI::base().'components/com_djcatalog2/theme/css/'.$cssFile;
		}
		if ($styleSheet) {
			$document->addStyleSheet($styleSheet);
		}
		
		// include component's JavaScript
		$js = JURI::base().'components/com_djcatalog2/theme/js/djcatalog2.js';
		$document->addScript($js);
		
		// include SlimBox
		/*   for Mootools 1.1
		  ----------------
		 Slimbox v1.58 - The ultimate lightweight Lightbox clone
		 (c) 2007-2009 Christophe Beyls <http://www.digitalia.be>
		 MIT-style license.
		 
		 for Mootools 1.2
		  ----------------
		 Slimbox v1.71a - The ultimate lightweight Lightbox clone
		 (c) 2007-2009 Christophe Beyls <http://www.digitalia.be>
		 MIT-style license.
		*/
		
		$plugin =& JPluginHelper::getPlugin('system', 'mtupgrade');
		if(is_object($plugin)) $slimbox_ver = 'slimbox-1.71a';
		else $slimbox_ver = 'slimbox-1.58';
		$slimboxJs = JURI::base().'components/com_djcatalog2/theme/js/'.$slimbox_ver.'/js/slimbox.js';
		$slimboxCss = JURI::base().'components/com_djcatalog2/theme/js/'.$slimbox_ver.'/css/slimbox.css';
		$document->addScript($slimboxJs);
		$document->addStyleSheet($slimboxCss);
		
		// design-joomla.eu footer
		define('DJCATFOOTER', '<div style="text-align: center; padding: 5px 0px;"><a style="font-size:10px;" target="_blank" href="http://design-joomla.eu">Joomla! templates &amp; addons</a></div>');
		
		parent::display();
	}
	function getFrontpageXMLData() {
		$model = $this->getModel('modfrontpage');
		$xml = $model->getXml();
		echo $xml;
	}
	function search() {
		global $mainframe;
		if(!is_object($mainframe)) {
			$app =& JFactory::getApplication();
		}
		else
		{
			$app = $mainframe;
		}
		
		$post = JRequest::get('post');
		$params = array();
		foreach($post as $key => $value) {
			if ($key != 'task' && $key != 'option' && $key != 'view' && $key != 'cid') {
				$params[] = $key.'='.$value;
			}
		}
		$uri = JRoute::_( DJCatalogHelperRoute::getCategoryRoute( JRequest::getVar( 'cid',0,'default','string' ) , JRequest::getVar('view','items')), false );
		
		if (strpos($uri,'?') === false ) {
			$get = (count($params)) ? '?'.implode('&',$params) : '';
		} else {
			$get = (count($params)) ? '&'.implode('&',$params) : '';
		}
		
		$app->redirect( $uri.$get.'#tlb' );
	}
}