<?php
/**
* @package Admin-User-Access (mod_admin_user_access_backend)
* @version 2.2.1
* @copyright Copyright (C) 2007-2008 Carsten Engel. All rights reserved.
* @license GPL available versions: free, trial and pro
* @author http://www.pages-and-items.com
* @joomla Joomla is Free Software
*/

//no direct access
if(!defined('_VALID_MOS') && !defined('_JEXEC')){
	die('Restricted access');
}

global $pi_ua_config, $my, $database, $componentsAccessRights, $aua_usergroup, $option, $path_root;

//path to root
if( defined('_JEXEC') ){
	//joomla 1.5.x
	$path_root = dirname(__FILE__).'/../../..';
}else{
	//joomla 1.0.x
	$path_root = dirname(__FILE__).'/../..';
}

//get database for 1.5.x
if( defined('_JEXEC') ){
	//joomla 1.5
	$database = JFactory::getDBO();
}

//get usertype and id
if( defined('_JEXEC') ){
	//joomla 1.5
	$user =& JFactory::getUser();
	$user_type = $user->get('usertype');	
	$user_id = $user->get('id');	
}else{
	//joomla 1.0.x
	$user_type = $my->usertype;
	$user_id = $my->id;
}

//get option
if( defined('_JEXEC') ){
	//joomla 1.5
	$framework = '1.5.x';
	$option = JRequest::getVar('option', '');
	$task = JRequest::getVar('task', '');	
}else{
	//joomla 1.0.x
	$framework = '1.0.x';
	$option = mosGetParam( $_REQUEST, 'option', '' );
	$task = mosGetParam( $_REQUEST, 'task', '' );
}

//get config to see what needs to be done
if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/class.php')){
				
	$database->setQuery("SELECT config "
	."FROM #__pi_aua_config "
	."WHERE id='aua' "
	."LIMIT 1"
	);
	$temp = $database->loadObjectList();
	$temp = $temp[0];
	$raw = $temp->config;			
	
	$params = explode( "\n", $raw);
	
	for($n = 0; $n < count($params); $n++){		
		$temp = explode('=',$params[$n]);
		$var = $temp[0];
		$value = '';
		if(count($temp)==2){
			$value = trim($temp[1]);
			if($value=='false'){
				$value = false;
			}
			if($value=='true'){
				$value = true;
			}
		}							
		$pi_ua_config[$var] = $value;		
	}	
	
	//reformat array components
	$components = explode(',',$pi_ua_config['components']);
	$temp = array();
	if(strpos($pi_ua_config['components'],';')){		
		for($n = 0; $n < count($components); $n++){			
			$component = explode(';',$components[$n]);	
			$component = str_replace('[newline]','
	',$component);
			$component = str_replace('[equal]','=',$component);	
			if(isset($component[4])){
				$component_array = array($component[0],$component[1],$component[2],$component[3], $component[4]);
			}else{				
				$component_array = array($component[0],$component[1],$component[2],$component[3], 'nothing');
			}
			array_push($temp,$component_array);
		}
	}	
	$pi_ua_config['components'] = $temp;			
	
	//reformat array dropdown_buttons
	$dropdown_buttons = explode(',',$pi_ua_config['dropdown_buttons']);			
	$temp = array();
	if(strpos($pi_ua_config['dropdown_buttons'],';')){
		for($n = 0; $n < count($dropdown_buttons); $n++){			
			$dropdown_button = explode(';',$dropdown_buttons[$n]);			
			$dropdown_button_array = array($dropdown_button[0],$dropdown_button[1]);			
			array_push($temp,$dropdown_button_array);
		}	
	}		
	$pi_ua_config['dropdown_buttons'] = $temp;	
	
	//reformat array extra_buttons	
	$temp_extra_buttons = $pi_ua_config['extra_buttons'];		
	$temp_extra_buttons_array = explode('-||-', $temp_extra_buttons);			
	if(count($temp_extra_buttons_array)==1){
		$temp_extra_buttons_array = array($temp_extra_buttons);
	}	
	$temp_extra_buttons_array = str_replace('[newline]','
',$temp_extra_buttons_array);
	$temp_extra_buttons_array = str_replace('[equal]','=',$temp_extra_buttons_array);
	$pi_ua_config['extra_buttons'] = $temp_extra_buttons_array;	
	
	//reformat module
	if(isset($pi_ua_config['module_list_redirect_url'])){	
		$pi_ua_config['module_list_redirect_url'] = str_replace('[equal]','=',$pi_ua_config['module_list_redirect_url']);
	}else{
		$pi_ua_config['module_list_redirect_url'] = '';
	}
	
	
					
}else{	
	echo '<span style="color: red;">component Admin-User-Access is not installed. module Admin-User-Access needs this component.</span>';	
}

//get class
$class_aua_module_superding = new class_aua_module_superding();

//redirect to Pages-and-Items	
################################################## deprecated, but is still in current version

if($pi_ua_config['redirect_to_pi'] && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){
	if( defined('_JEXEC') ){
		//joomla 1.5
		$control_panel = 'com_cpanel';
	}else{
		//joomla 1.0.x
		$control_panel = '';
	}
	if($option==$control_panel){
		$url = 'index2.php?option=com_pi_pages_and_items';		
		if(defined('_JEXEC')){
			//joomla 1.5
			$mainframe->redirect($url);
		}else{
			//joomla 1.0.x
			mosRedirect($url);
		}
	}
}

############################################## end depricated

//get aua_usergroup if needed
if(($pi_ua_config['active_sections'] || $pi_ua_config['active_actions'] || $pi_ua_config['active_categories'] || $pi_ua_config['active_pagesaccess'] || $pi_ua_config['use_toolbar'] || $pi_ua_config['activate_modules'] || ($pi_ua_config['use_componentaccess'] && $user_type!='Super Administrator' && $option!='com_login' && $option!='com_cpanel')) && $user_type!='Super Administrator'){	

	//get aua_usergroup		
	$database->setQuery("SELECT group_id FROM #__pi_aua_userindex WHERE user_id='$user_id' LIMIT 1 ");
	$rows_userindex = $database->loadObjectList();
	if(count($rows_userindex)!=0){
		$row_userindex = $rows_userindex[0];	
		$aua_usergroup = $row_userindex->group_id;
	}else{
		$aua_usergroup = '';
	}
	
	//echo 'aua_usergroup='.$aua_usergroup;
}

//get item_id	
if(JRequest::getVar('id')){
	$item_id = JRequest::getVar('id');
}else{
	$item_id = JRequest::getVar('cid', null, 'get', 'array');
	$item_id = intval($item_id[0]);	
}	


//take out when free
//check if user has access to backend at all
if($pi_ua_config['active_actions'] && $user_type!='Super Administrator'){
	$workflow_rights = $class_aua_module_superding->aua_get_workflow_rights();
	//print_r($workflow_rights);
	$workflow_right = '30__'.$aua_usergroup;
	
	if(!in_array($workflow_right, $workflow_rights) && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){			
		if(defined('_JEXEC')){
			//joomla 1.5
			$url = 'index2.php?option=com_login&task=logout';	
			$mainframe->redirect($url);
		}else{
			//joomla 1.0.x
			$url = 'index2.php?option=logout';
			mosRedirect($url);
		}
	}
}

//check module access
//if($option=='com_modules' && $pi_ua_config['active_modules'] && $item_id){
if(($option=='com_modules' || $option=='com_advancedmodules') && $item_id && $user_type!='Super Administrator'){
	$class_aua_module_superding->check_module_access($item_id, $aua_usergroup, $pi_ua_config);
}
//if module manager hide links and buttons
if(($option=='com_modules' || $option=='com_advancedmodules') && !$item_id){
	//if redirect away from module-list- in module manager is active, do redirect
	if($pi_ua_config['activate_module_list_redirect'] && $pi_ua_config['module_list_redirect_url']!='' && $user_type!='Super Administrator'){
		$url = $pi_ua_config['module_list_redirect_url'];	
		$mainframe->redirect($url);
	}
	$class_aua_module_superding->module_manager($user_type, $pi_ua_config, $aua_usergroup);	
}



//check plugin access
if((($framework=='1.5.x' && $option=='com_plugins') || ($framework=='1.0.x' && $option=='com_mambots')) && $item_id && $user_type!='Super Administrator'){
	$class_aua_module_superding->check_plugin_access($item_id, $aua_usergroup, $pi_ua_config);
}
//if plugin manager, disable functionality on the plugin manager page
if((($framework=='1.5.x' && $option=='com_plugins') || ($framework=='1.0.x' && $option=='com_mambots')) && !$item_id && $user_type!='Super Administrator'){	
	$class_aua_module_superding->plugin_manager($user_type, $pi_ua_config, $aua_usergroup);
}

//start content restrictions
if(($framework=='1.5.x' && !$item_id && $option=='com_content' && !$task) || ($framework=='1.0.x' && !$task)){
	$class_aua_module_superding->article_manager($user_type, $pi_ua_config, $aua_usergroup);
}

//if moving or copying an article
if($option=='com_content' && ($task=='movesect' || $task=='copy') && $user_type!='Super Administrator' && ($pi_ua_config['active_sections'] || $pi_ua_config['active_categories'])){
	$class_aua_module_superding->article_move_copy($pi_ua_config, $aua_usergroup);
}

if($framework=='1.5.x' && $item_id && $option=='com_content'){
	$admin_page = 'edit';
	//$pi_ua_config['use_toolbar'] = 0;
}

//if workflow access restrictions are activated and editting item
if($pi_ua_config['active_actions'] && (($framework=='1.5.x' && ($task=='add' || $task=='edit')) || ($framework=='1.0.x' && ($task=='new' || $task=='edit'))) && $user_type!='Super Administrator' && $option=='com_content'){
	$class_aua_module_superding->aua_disable_stuff();
}

//new item and section restrictions are active, so rip out sections out of section selector
if($pi_ua_config['active_sections'] && (($framework=='1.5.x' && $task=='add') || ($framework=='1.0.x' && $task=='new')) && $user_type!='Super Administrator' && $option=='com_content'){
	$class_aua_module_superding->rip_sections_out($database, $item_id, $aua_usergroup);
}
//echo 'task='.$task;
//new item and category restrictions are active, so rip out categories out of category selector
if($pi_ua_config['active_categories'] && ($framework=='1.5.x' && $task=='add') && $user_type!='Super Administrator' && $option=='com_content'){
	//echo 'new';
	$class_aua_module_superding->rip_categories_out($database, $aua_usergroup);
}

//check menu manager access stuff
if($pi_ua_config['activate_menus'] && $option=='com_menus' && $user_type!='Super Administrator' && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){
	$class_aua_module_superding->check_menu_access($pi_ua_config, $database, $aua_usergroup);
}

//item access com_content backend
if((($framework=='1.5.x' && $item_id && $option=='com_content') || ($framework=='1.0.x' && $option=='com_content' && ($task=='new' || $task=='edit'))) && $user_type!='Super Administrator' && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){	

	$no_category_access = false;
	
	//take out when free
	//if section access restrictions are activated
	if($pi_ua_config['active_sections']){		
		
		//get section access data
		$database->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
		$section_access_rights = $database->loadResultArray();
		
		//get section from id
		$database->setQuery("SELECT sectionid FROM #__content WHERE id='$item_id' LIMIT 1");		
		$item_rows = $database->loadObjectList();
		$item_row = $item_rows[0];
		$section_id = $item_row->sectionid;
		
		$section_right = $section_id.'__'.$aua_usergroup;		
		
		//get sections
		$database->setQuery("SELECT id FROM #__sections");
		$all_sections = $database->loadResultArray();	
					
		//make array from sections which user has access to
		$user_sectons_access_array = array();		
		for($n = 0; $n < count($section_access_rights); $n++){
			$right = $section_access_rights[$n];			
			$right = explode('__', $right);			
			if($right[1]==$aua_usergroup){
				array_push($user_sectons_access_array, $right[0]);
			}
		}	
		
		//make array of sections user has NO access to
		$sections_with_no_access = array();
		foreach($all_sections as $section){
			if(!in_array($section, $user_sectons_access_array)){
				array_push($sections_with_no_access, $section);
			}
		}
		
		echo '<script language="javascript" type="text/javascript">'."\n";			
		
		$javascript_array_sections_no_access = 'var sections_with_no_access = new Array(';
		
		$first = true;	
		foreach($sections_with_no_access as $section_no_access){
			if($first){
				$first = false;
			}else{
				$javascript_array_sections_no_access .= ',';
			}			
			$javascript_array_sections_no_access .= '"'.$section_no_access.'"';
		}		
		$javascript_array_sections_no_access .= ');';
		echo $javascript_array_sections_no_access."\n";				
		
		//javascript function to rip sections out of select
		echo 'function rip_sections_out_of_select(){'."\n";			
			echo "var elSel = document.adminForm.sectionid;\n";
			echo 'var i;'."\n";
			
			###############################check which section is selected
			
			
			
			echo 'if(document.adminForm.sectionid!= null){'."\n";	
			//echo 'alert(\'fdvws\')'."\n";			
				echo 'for (i = elSel.length - 1; i>=0; i--){'."\n";				
					echo 'for (j=0; j < sections_with_no_access.length; j++) {'."\n";	
						echo 'if (elSel.options[i]){'."\n";			
							echo 'if (sections_with_no_access[j] === elSel.options[i].value){'."\n";						
								echo 'elSel.remove(i);'."\n";										
							echo '}'."\n";
						echo '}'."\n";
					echo '}'."\n";				
				echo '}'."\n";	
			echo '}'."\n";	
			
			################################################################make the previously selected section selected again
				
		echo '}'."\n";			
		
		//call onload event
		echo 'if(window.addEventListener)window.addEventListener("load",rip_sections_out_of_select,false);'."\n";
		echo 'else if(window.attachEvent)window.attachEvent("onload",rip_sections_out_of_select);'."\n";
		
		/*
		//if user has no section-access-permission
		if(!in_array($section_right, $section_access_rights) && (($framework=='1.5.x' && $admin_page=='edit') || ($framework=='1.0.x' && $task=='edit'))){				
			
			//include language, defaults to english
			if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
			}else{
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
			}
				
			//do_alert			
			$message = _pi_ua_lang_no_section_item_access;
			echo 'function restrict_access(){'."\n";				
				//echo 'alert("'.$message.'"); window.history.go(-1);'."\n";
				echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
				echo 'alert("'.addslashes(html_entity_decode($message)).'"); document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";
			echo '}'."\n";
			
			//call onload event
			echo 'if(window.addEventListener)window.addEventListener("load",restrict_access,false);'."\n";
			echo 'else if(window.attachEvent)window.attachEvent("onload",restrict_access);'."\n";				
		}
		*/
		
		echo '</script>';		
		
	}//end if sections active
	
	//take out when free
	//check workflow for hiding 'uncategorized' option and item-new and item-edit workflow and article-author-access
	if($pi_ua_config['active_actions']){
	
		//get workflow data		
		$workflow_rights = $class_aua_module_superding->aua_get_workflow_rights();		
		
		//set workflow right to check workflow hide 'uncategorized' option
		$workflow_right = '27__'.$aua_usergroup;
		
		//if in workflow hide option 'uncategoriesed'
		if(in_array($workflow_right, $workflow_rights) && $framework=='1.5.x'){	
			echo '<script language="javascript" type="text/javascript">'."\n";
			
			echo 'function hide_uncaterized_option(){'."\n";			
				echo "var elSel = document.getElementById('sectionid');\n";
				echo 'var i;'."\n";		
				echo 'if(document.getElementById(\'sectionid\')!= null){'."\n";		
					echo 'for (i = elSel.length - 1; i>=0; i--){'."\n";									
						echo 'if (elSel.options[i].value == "0"){'."\n";						
							echo 'elSel.remove(i);'."\n";										
						echo '}'."\n";								
					echo '}'."\n";
				echo '}'."\n";								
			echo '}'."\n";	
				
			//call onload event
			echo 'if(window.addEventListener)window.addEventListener("load",hide_uncaterized_option,false);'."\n";
			echo 'else if(window.attachEvent)window.attachEvent("onload",hide_uncaterized_option);'."\n";
			
			echo '</script>';
		}
		
		//set workflow right to check workflow item-new
		$workflow_right = '28__'.$aua_usergroup;
		
		if(!in_array($workflow_right, $workflow_rights)){	
		
			echo '<script language="javascript" type="text/javascript">'."\n";	
			
				if($admin_page=='edit' || ($framework=='1.0.x' && $task=='edit')){
					echo 'var task = \'edit\';'."\n";
				}else{
					echo 'var task = \'\';'."\n";
				}	
			
				//include language, defaults to english
				if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
				}else{
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
				}
			
				$message = _pi_ua_lang_no_item_new;
				echo 'function restrict_access2(){'."\n";
					echo 'if(document.adminForm.sectionid!= null && task!=\'edit\'){'."\n";				
						//echo 'alert("'.$message.'"); window.history.go(-1);'."\n";
						echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
						echo 'alert("'.addslashes(html_entity_decode($message)).'"); document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";
					echo '}'."\n";
				echo '}'."\n";
				
				//call onload event
				echo 'if(window.addEventListener)window.addEventListener("load",restrict_access2,false);'."\n";
				echo 'else if(window.attachEvent)window.attachEvent("onload",restrict_access2);'."\n";
			echo '</script>';
					
		}
		
		//set workflow right to check workflow item-edit
		$workflow_right = '29__'.$aua_usergroup;
		
		if(!in_array($workflow_right, $workflow_rights)){	
		
			echo '<script language="javascript" type="text/javascript">'."\n";	
			
				if($admin_page=='edit' || ($framework=='1.0.x' && $task=='edit')){
					echo 'var task = \'edit\';'."\n";
				}else{
					echo 'var task = \'\';'."\n";
				}	
			
				//include language, defaults to english
				if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
				}else{
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
				}
			
				$message = _pi_ua_lang_no_item_edit;
				echo 'function restrict_access3(){'."\n";
					echo 'if(document.adminForm.sectionid!= null && task==\'edit\'){'."\n";				
						//echo 'alert("'.$message.'"); window.history.go(-1);'."\n";
						echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
						echo 'alert("'.addslashes(html_entity_decode($message)).'"); document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";
					echo '}'."\n";
				echo '}'."\n";
				
				//call onload event
				echo 'if(window.addEventListener)window.addEventListener("load",restrict_access3,false);'."\n";
				echo 'else if(window.attachEvent)window.attachEvent("onload",restrict_access3);'."\n";
			echo '</script>';
					
		}
		
		//set workflow right to check workflow article-author
		$workflow_right = '38__'.$aua_usergroup;
		
		if(!in_array($workflow_right, $workflow_rights) && $item_id){
			//user is only allowed to work on own articles, so we need to check who the article is made by			
			//get item author
			$database->setQuery("SELECT created_by FROM #__content WHERE id='$item_id' LIMIT 1");
			$item_authors = $database->loadResultArray();
			$item_author = $item_authors[0];
			
			//if author is not the same, no access
			if($item_author!=$user_id){
				//include language, defaults to english
				if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
				}else{
					require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
				}			
				
				echo '<script language="javascript" type="text/javascript">'."\n";
								
				$message = _pi_ua_lang_no_item_access;	
				echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';		
				echo 'alert("'.addslashes(html_entity_decode($message)).'");'."\n";				
				echo 'document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";				
				
				echo '</script>'."\n";	
				exit();					
			}
		}
		
						
	}
	
	//if page access or category access restrictions are activated
	if($pi_ua_config['active_pagesaccess'] || $pi_ua_config['active_categories']){
		
		$no_category_access = false;
		if($pi_ua_config['com_content_access']=='page_access' && $pi_ua_config['active_pagesaccess']){
		
			//get page access data
			$database->setQuery("SELECT pageid_usergroupid FROM #__pi_aua_access_pages");
			$pages_access_rights = $database->loadResultArray();		
				
			//make array of pages which user has access to		
			$user_page_access_array = '';
			$first = true;		
			for($n = 0; $n < count($pages_access_rights); $n++){
				$right = $pages_access_rights[$n];			
				$right = explode('_', $right);			
				if($right[1]==$aua_usergroup){				
					if(!$first){
						$user_page_access_array .= ',';				
					}
					$user_page_access_array .= $right[0];
					if($first){
						$first = false;					
					}
				}
			}	
			//print_r($user_page_access_array);
			//get page data
			$database->setQuery("SELECT id, link, componentid, type FROM #__menu WHERE id in ($user_page_access_array)");
			$all_menuitems = $database->loadObjectList();		
			
			$all_menuitems_with_categories = array();
			//make a new array from all categories which are used as category-blog-pages in menu
			foreach($all_menuitems as $menuitem){
				if(((strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog') && $menuitem->type=='url') || !strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog')) && $menuitem->type!='content_blog_category'){
					//something else	
				}else{
					//category-blog-page
					array_push($all_menuitems_with_categories, $menuitem->id);		
				}
			}		
			//print_r($all_menuitems_with_categories);
			
			//get categories from menuitems
			$all_categories_access = array();		
			foreach($all_menuitems as $menuitem){
				if(in_array($menuitem->id,$all_menuitems_with_categories)){			
					if(defined('_JEXEC')){
						//joomla 1.5
						$cat_id = str_replace('index.php?option=com_content&view=category&layout=blog&id=','',$menuitem->link);				
					}else{	
						//joomla 1.0.x
						$cat_id = $menuitem->componentid;				
					}
					array_push($all_categories_access, $cat_id);				
				}							
			}
			
			//print_r($all_categories_access);
			
			//get items cat id		
			$database->setQuery("SELECT catid FROM #__content WHERE id='$item_id' LIMIT 1 ");
			$rows = $database->loadResultArray();
			$cat_id = $rows[0];	
			
			
			//echo 'item_id='.$item_id;
			//echo 'catid='.$cat_id;
			//print_r($all_categories_access);
			if(!in_array($cat_id, $all_categories_access)){			
				$no_category_access = true;
			}
			
			//end if category access is checked with page-access
		}elseif($pi_ua_config['com_content_access']=='category_access' && $pi_ua_config['active_categories']){
			//category access is checked with category-access
			
			//get category access data
			$database->setQuery("SELECT category_groupid FROM #__pi_aua_categories");
			$category_access_rights = $database->loadResultArray();
			
			//get category from id
			//get items cat id		
			$database->setQuery("SELECT catid FROM #__content WHERE id='$item_id' LIMIT 1 ");
			$rows = $database->loadResultArray();
			$cat_id = $rows[0];
			
			$category_right = $cat_id.'__'.$aua_usergroup;				
		
						
			
			//get categories
			$database->setQuery("SELECT id FROM #__categories");
			$all_categories = $database->loadResultArray();	
						
			//make array from categories which user has access to
			$all_categories_access = array();		
			for($n = 0; $n < count($category_access_rights); $n++){
				$right = $category_access_rights[$n];			
				$right = explode('__', $right);			
				if($right[1]==$aua_usergroup){
					array_push($all_categories_access, $right[0]);
				}
			}
			
			//echo $category_right;
			if(!in_array($cat_id, $all_categories_access)){
				$no_category_access = true;
				//exit('no cat access- cats');
			}
				
			
			//print_r($all_categories_access);
			
			//end if category access is checked with category-access
		} 	
			
		echo '<script language="javascript" type="text/javascript">'."\n";			
		
		//make javascript array of categories which user has access to
		$javascript_array_category_access = 'var categories_with_access = new Array(';		
		$first = true;	
		foreach($all_categories_access as $category){
			if($first){
				$first = false;
			}else{
				$javascript_array_category_access .= ',';
			}			
			$javascript_array_category_access .= '"'.$category.'"';
		}		
		$javascript_array_category_access .= ');';
		echo $javascript_array_category_access."\n\n";		
			
		//javascript in_array function
		echo 'Array.prototype.in_array = function (element){'."\n";
			echo 'var retur = false;'."\n";
			echo 'for (var values in this){'."\n";
				echo 'if (this[values] == element){'."\n";
					echo 'retur = true;'."\n";
					echo 'break;'."\n";
				echo '}'."\n";
			echo '}'."\n";
			echo 'return retur;'."\n";
		echo '};'."\n\n"; 			
				
		//javascript function to rip categories out of category-array of dynamic select
		echo 'function filter_categories(){'."\n";			
			echo 'if(document.adminForm.sectionid && document.adminForm.catid){'."\n";	
			
				//if edit get selected cat
				if(($framework=='1.5.x' && $admin_page=='edit') || ($framework=='1.0.x' && $task=='edit')){					
					echo 'var selected_category = document.adminForm.catid.value;'."\n";	
					//echo 'alert(selected_category);'."\n";						
				}			
				
				//take categories out of array
				echo 'for (i = 0; i < sectioncategories.length; i++){'."\n";											
					echo 'if(!categories_with_access.in_array(sectioncategories[i][1])){'."\n";								
						echo 'sectioncategories.splice(i,1);'."\n";														
						echo 'i = i-1;'."\n";																	
					echo '}'."\n";																	
				echo '}'."\n";
				
				if(($framework=='1.5.x' && $admin_page=='edit') || ($framework=='1.0.x' && $task=='edit')){	
				
					//refresh category select by changing the section select and back again
					echo 'var selected_section = document.adminForm.sectionid.selectedIndex;'."\n";
					echo 'changeDynaList("catid", sectioncategories, document.adminForm.sectionid.options[0].value, 0, 0);'."\n";
					echo 'changeDynaList("catid", sectioncategories, document.adminForm.sectionid.options[selected_section].value, 0, 0);'."\n";				
					
					//select the category innitialy selected	
					echo 'if(selected_category){'."\n";								
						echo 'for(index = 0; index < document.adminForm.catid.length; index++){'."\n";	
							echo 'if(document.adminForm.catid[index].value == selected_category){'."\n";	
								echo 'document.adminForm.catid.selectedIndex = index;'."\n";	
							echo '}'."\n";	
						echo '}'."\n";							
					echo '}'."\n";
					
				}//end if edit page
				
			echo '}'."\n";//end if on new or edit page																
		echo '}'."\n\n";//end function
		
		//call onload event
		echo 'if(window.addEventListener)window.addEventListener("load",filter_categories,false);'."\n";
		echo 'else if(window.attachEvent)window.attachEvent("onload",filter_categories);'."\n";
		
		//if user has no category-access-permission
		if($no_category_access && (($framework=='1.5.x' && $admin_page=='edit') || ($framework=='1.0.x' && $task=='edit'))){			
			
			//include language, defaults to english
			if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
			}else{
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
			}
			//exit('cat_right='.$category_right);
				
			/*				
			//do_alert			
			$message = _pi_ua_lang_no_category_item_access;
			echo 'function restrict_access(){'."\n";
				
				//echo 'alert("'.$message.'"); window.history.go(-1);'."\n";
				echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
				echo 'alert("'.addslashes(html_entity_decode($message)).'"); document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";
			echo '}'."\n";
			
			//call onload event
			echo 'if(window.addEventListener)window.addEventListener("load",restrict_access,false);'."\n";
			echo 'else if(window.attachEvent)window.attachEvent("onload",restrict_access);'."\n";	
			*/			
		}
		
		echo '</script>';		
	
	}//end if page access
		
	//take out when free
	//if item access restrictions are activated
	if($pi_ua_config['active_items'] && (($framework=='1.5.x' && $item_id && $admin_page=='edit') || ($framework=='1.0.x' && $task=='edit'))){		
		
		/*
		//get item access data
		$database->setQuery("SELECT itemid_usergroupid FROM #__pi_aua_items");
		$item_access_rights = $database->loadResultArray();	
		
		$item_right = $item_id.'__'.$aua_usergroup;				
		
		//if user has no item-access-permission
		if(!in_array($item_right, $item_access_rights)){		
			
			//include language, defaults to english
			if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
			}else{
				require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/en.php');
			}			
			
			echo '<script language="javascript" type="text/javascript">'."\n";
							
			$message = _pi_ua_lang_no_item_access;	
			echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';		
			echo 'alert("'.addslashes(html_entity_decode($message)).'");'."\n";				
			echo 'document.location.href=\'index2.php?option=com_pi_admin_user_access&task=unlock_item&item_id='.$item_id.'\';'."\n";				
			
			echo '</script>'."\n";	
			exit();					
		}
		*/	
	}

}//end item access com_content backend
	
//get component-access-data only if we need it
if($pi_ua_config['use_toolbar'] || ($pi_ua_config['use_componentaccess'] && $user_type!='Super Administrator' && $option!='com_login' && $option!='com_cpanel')){	

	//get component access data	for component access and toolbar	
	$database->setQuery("SELECT component_usergroupid FROM #__pi_aua_access_components ");
	$componentsAccessRights = $database -> loadResultArray();	
	
	//print_r($componentsAccessRights);		
	
}

//component-access-restriction
if($pi_ua_config['use_componentaccess'] && $user_type!='Super Administrator' && $option!='com_login' && $option!='com_cpanel' && $option!=''){

	$component_right = $option.'__'.$aua_usergroup;

	if(!in_array($component_right, $componentsAccessRights) && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){	
		
		//include language, defaults to english
		if(file_exists($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
			require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
		}else{
			require_once($path_root.'/administrator/components/com_pi_admin_user_access/language/english.php');
		}
		
		//do alert	
		echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';	
		echo "<script> alert('".addslashes(html_entity_decode(_pi_ua_lang_no_access_component))."'); window.history.go(-1); </script>";
		exit();
	}
}

//check if we need to show toolbar
$display_ua_toolbar = false;
$extra = false;
$display_joomla_toolbar = false;
if($pi_ua_config['use_toolbar']){
	if($pi_ua_config['activate_toolbars']){
		
		//if not administrator get display toolbars settings from this aua_usergroup
		if($user_type!='Super Administrator'){
			$database->setQuery("SELECT ua_toolbar, j_toolbar, extra FROM #__pi_aua_usergroups WHERE id='$aua_usergroup' LIMIT 1 ");
			$rows = $database->loadObjectList();
			if(count($rows)!=0){
				$row = $rows[0];			
				$display_ua_toolbar = $row->ua_toolbar;
				$display_joomla_toolbar = $row->j_toolbar;	
				$extra = $row->extra;
			}else{
				$display_ua_toolbar = 0;
				$display_joomla_toolbar = 0;	
				$extra = 0;
			}	
		}			
	}else{		
		$display_ua_toolbar = true;
		$display_joomla_toolbar = true;
	}
	if($user_type=='Super Administrator'){
		if($pi_ua_config['display_toolbar_superadmin']){
			$display_ua_toolbar = true;
			$display_joomla_toolbar = true;
		}else{
			$display_ua_toolbar = 0;
			$display_joomla_toolbar = 0;
		}		
	}
}

//toolbar
if($pi_ua_config['use_toolbar']){	

	if(!defined('_JEXEC')){
		//joomla 1.0.x wrapper opening tag
		echo '<div style="display: none" id="user_access_toolbar">';
	}		

	//display toolbar if usergoup has this set or if super administrator
	if(($display_ua_toolbar || ($user_type=='Super Administrator' && $pi_ua_config['display_toolbar_superadmin'])) && $class_aua_module_superding->check_trial_version_aua($pi_ua_config)){
	
		//get stylesheet for toolbar
		echo '<link rel="stylesheet" type="text/css" href="modules/mod_admin_user_access_backend/toolbar.css" />';
		echo '<script language="JavaScript" type="text/javascript" src="components/com_pi_admin_user_access/javascript/suckerfish_dropdowns.js"></script>';
		
		
		//make a new array with only components user has access to
		$components = array();
		foreach($pi_ua_config['components'] as $component){												
			$component_right = $component[0].'__'.$aua_usergroup;			
			if(in_array($component_right, $componentsAccessRights) || $user_type=='Super Administrator'){
				if(isset($component[4])){
					$component_array = array($component[0], $component[1], $component[2], $component[3], $component[4]);
				}else{
					$component_array = array($component[0], $component[1], $component[2], $component[3], 'nothing');
				}			
				array_push($components, $component_array);
			}
		}
		
		//print_r($components);
		
		//get backend template
		$database->setQuery("SELECT template FROM #__templates_menu WHERE client_id='1' "  );
		$backend_template = $database->loadResult();	
		
		$default_icon = 'templates'.'/'.$backend_template.'/'.'images'.'/'.'menu'.'/icon-16-component.png';
		
		//display toolbar
		$displayed_links_array = array();	
		echo '<div>';	
		echo '<ul id="pi_ua_menu">';	
		
		//first do dropdown menus
		for($b = 0; $b < count($pi_ua_config['dropdown_buttons']); $b++){
			$dropdown_has_children = false;
			for($c = 0; $c < count($components); $c++){
				if($components[$c][3]==$pi_ua_config['dropdown_buttons'][$b][0]){
					$dropdown_has_children = true;
				}
			}
			if($dropdown_has_children){
				echo '<li><a href="#" class="dropdown_button">';
				$temp = stripslashes($pi_ua_config['dropdown_buttons'][$b][1]);						
				echo str_replace('"','&quot;',$temp);	
				echo '</a>';
				echo '<ul>';
				for($c = 0; $c < count($components); $c++){					
					if($components[$c][3]==$pi_ua_config['dropdown_buttons'][$b][0]){					
						echo '<li><a href="index2.php?option='.$components[$c][2].'"';
						if($option==$components[$c][0]){
							echo ' class="active"';
						}
						if($components[$c][4]=='' || $components[$c][4]=='nothing'){
							echo ' style="background-image: url(\''.$default_icon.'\');"';							
						}else{
							echo ' style="background-image: url(\''.$components[$c][4].'\');"';	
						}					
						echo '>';
						$temp = stripslashes($components[$c][1]);						
						echo str_replace('"','&quot;',$temp);						 
						echo '</a></li>';
						array_push($displayed_links_array, $components[$c][2]);//using the link as the unique key			
					}					
				}
				echo '</ul>';
				echo '</li>';
			}
		}			
		
		//component links not assigned to any dropdown					
		foreach($components as $component){
			if(!in_array($component[2], $displayed_links_array)){
				echo '<li><a href="index2.php?option='.$component[2].'"';
				if($option==$component[0]){
					echo ' class="active"';
				}
				if($component[4]=='' || $component[4]=='nothing'){
					echo ' style="background-image: url(\''.$default_icon.'\');"';
				}else{					
					echo ' style="background-image: url(\''.$component[4].'\');"';		
				}				
				echo '>';				
				$temp = stripslashes($component[1]);						
				echo str_replace('"','&quot;',$temp);	
				echo '</a></li>';
			}
		}
		
		//extra buttons
		if($extra){	
			$buttons = explode(',',$extra);
			foreach($buttons as $button){	
				$array_index_number = $button-1;
				if($array_index_number>=0){
					echo stripslashes($pi_ua_config['extra_buttons'][$array_index_number]);
				}
			}
		}
		
		if(isset($pi_ua_config['extra_buttons_super_admin'])){
			if($user_type=='Super Administrator' && $pi_ua_config['extra_buttons_super_admin']){				
				for($n = 0; $n < count($pi_ua_config['extra_buttons']); $n++){				
					echo stripslashes($pi_ua_config['extra_buttons'][$n]);				
				}	
			}
		}
		
		echo '</ul>';
		echo '</div>';
		echo '<div id="pi_ua_clear_both">';
		echo '</div>';
				
	}//end display ua_toolbar		
	
	//if both toolbars are visible, put a line in between them
	if(($display_ua_toolbar && $display_joomla_toolbar) || ($user_type=='Super Administrator' && $pi_ua_config['display_toolbar_superadmin'])){
		echo '<div id="pi_ua_menu_line">&nbsp;</div>';
		echo '<link rel="stylesheet" type="text/css" href="components/com_pi_admin_user_access/css/toolbar_line.css" />';		
	}	
	
	//hide joomla toolbar
	if(!$display_joomla_toolbar && $user_type!='Super Administrator'){
			
		if(defined('_JEXEC')){
			//joomla 1.5			
			echo '<link rel="stylesheet" type="text/css" href="components/com_pi_admin_user_access/css/toolbar_hide_j-1-5-x.css" />';
			echo '<link rel="stylesheet" type="text/css" href="components/com_pi_admin_user_access/css/toolbar_padding_bottom_j-1-5-x.css" />';
		}else{
			echo '<link rel="stylesheet" type="text/css" href="components/com_pi_admin_user_access/css/toolbar_padding_bottom_j-1-0-x.css" />';
		}		
		echo '<link rel="stylesheet" type="text/css" href="components/com_pi_admin_user_access/css/toolbar_hide.css" />';
	}

	if(!defined('_JEXEC')){
		//joomla 1.0.x wrapper closing tag
		echo '</div>';		
	
	?>
	<script language="javascript" type="text/javascript">
	
	function uatoolbar_init(){
		joomla_toolbar = document.getElementById('myMenuID').innerHTML;	
		admin_user_access_toolbar = document.getElementById('user_access_toolbar').innerHTML;			
		document.getElementById('myMenuID').innerHTML = admin_user_access_toolbar+'<div id="joomla_toolbar">'+joomla_toolbar+'</div>';	
	}
	document.onload = uatoolbar_init();
	
	</script>
	<?php
	
	}//end joomla 1.0.x wrapper and script
}//end if toolbar



class class_aua_module_superding{
	
	//change in free version
	function check_trial_version_aua($aua_config){		
		static $aua_key_checked_module;
		
		if(!$aua_key_checked_module){
			$aua_key_checked_module = 0;
			if(defined('_JEXEC')){
				//joomla 1.5							
				$path_to_root = '/../../../';					
			}else{
				//joomla 1.0.x					
				$path_to_root = '/../../';								
			}	
			require_once(dirname(__FILE__).$path_to_root.'administrator/components/com_pi_admin_user_access/class.php');
			$class_ua = new class_ua();			
			if($class_ua->aua_check_trial_version()){
				$aua_key_checked_module = 1;
			}			
		}		
		return $aua_key_checked_module;
	}
	
	//take workflow out when free
	function article_manager($user_type, $pi_ua_config, $aua_usergroup){
		global $database;
		$jquery_included = false;	
		
		if($user_type!='Super Administrator'){
			$edit = $this->check_workflow('29');
			$publish = $this->check_workflow('31');
			$unpublish = $this->check_workflow('32');
			$move = $this->check_workflow('33');				
			$frontpage = $this->check_workflow('34');
			$reorder = $this->check_workflow('35');
			$archive = $this->check_workflow('36');
			$unarchive = $this->check_workflow('37');
			$new = $this->check_workflow('28');
			$access = $this->check_workflow('39');
			$copy = $this->check_workflow('40');
			$trash = $this->check_workflow('41');
			$help = $this->check_workflow('200');
			
			//if category or section access is enabled make sure some options are out
			if($pi_ua_config['active_categories'] || $pi_ua_config['active_sections']){
				//$move = false;
				//$copy = false;
			}
			
			//hiding of buttons does not work in 1.0
			if(defined('_JEXEC')){	
				//joomla 1.5				
				if(!$edit || !$publish || !$unpublish || !$move || !$archive || !$unarchive || !$new || !$copy || !$trash || !$help){			
					echo '<style type="text/css">';
				}
				if(!$edit){
					echo '#toolbar-edit{
						display: none;
					}';
				}
				if(!$publish){
					echo '#toolbar-publish{
						display: none;
					}';
				}
				if(!$unpublish){
					echo '#toolbar-unpublish{
						display: none;
					}';
				}
				if(!$move){
					echo '#toolbar-move{
						display: none;
					}';
				}
				if(!$archive){
					echo '#toolbar-archive{
						display: none;
					}';
				}
				if(!$unarchive){
					echo '#toolbar-unarchive{
						display: none;
					}';
				}	
				if(!$new){
					echo '#toolbar-new{
						display: none;
					}';
				}	
				if(!$copy){
					echo '#toolbar-copy{
						display: none;
					}';
				}	
				if(!$trash){
					echo '#toolbar-trash{
						display: none;
					}';
				}
				if(!$help){
					echo '#toolbar-help{
						display: none;
					}';
				}
				if(!$edit || !$publish || !$unpublish || !$move || !$archive || !$unarchive || !$new || !$copy || !$trash || !$help){	
					echo '</style>';
				}	
			}	
			
			
			$script_things = array(array('publish', $publish), array('unpublish', $unpublish), array('toggle_frontpage', $frontpage), array('orderup', $reorder), array('orderdown', $reorder), array('accessregistered', $access), array('new', $new), array('movesect', $move), array('copy', $copy), array('archive', $archive), array('remove', $trash));				
				
			echo '<script language="JavaScript" type="text/javascript">';
			echo 'function listItemTask( id, task ) {
				var f = document.adminForm;
				cb = eval( \'f.\' + id );
				if (cb) {
					for (i = 0; true; i++) {
						cbx = eval(\'f.cb\'+i);
						if (!cbx) break;
						cbx.checked = false;
					} // for
					cb.checked = true;
					f.boxchecked.value = 1;'."\n";
					$this->filter_javascript($script_things);
					echo '
				}
				return false;
			}'."\n";
			
			if(!$reorder){
				echo 'function saveorder(){};'."\n";
			}
			if(!defined('_JEXEC')){
				//joomla 1.0.x
				echo 'function submitbutton(task){'."\n";
					$this->filter_javascript($script_things);
				echo '}'."\n";
				
			}
			
			
			echo '</script>'."\n";
			
			echo '<script language="JavaScript" type="text/javascript" src="modules/';
			if(defined('_JEXEC')){
				//joomla 1.5
				echo 'mod_admin_user_access_backend/';	
			}
			echo 'jquery-1_3_2.js"></script>'."\n";	
			$jquery_included = true;
			echo '<script language="javascript" type="text/javascript">'."\n";		
			echo 'var AUA_jQuery = jQuery.noConflict();';
			echo 'AUA_jQuery(document).ready(function() {'."\n";	
					
			echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";				
			echo 'if(this.href == "javascript:void(0);" || this.href == "javascript:%20void(0);" || this.href == "javascript: void(0);"){'."\n";
			echo 'temp_icon = this.innerHTML;'."\n";
			echo 'AUA_jQuery(this).replaceWith(temp_icon);	'."\n";
			echo '}'."\n";
			
			echo '});'."\n";
			
			echo '});'."\n";	
			echo '</script>'."\n";		
			
			if($pi_ua_config['active_items'] || $pi_ua_config['active_categories'] || $pi_ua_config['active_sections'] || $pi_ua_config['active_pagesaccess'] || $pi_ua_config['active_actions']){	
									
				//get access for items in array
				if($pi_ua_config['active_items']){
					//access for items
					$access_array_items = array();	
					$database->setQuery("SELECT itemid_usergroupid FROM #__pi_aua_items " );
					$rows = $database->loadObjectList();
					foreach($rows as $row){						
						$pos = strpos($row->itemid_usergroupid, '__');
						$temp_item_id = substr($row->itemid_usergroupid, 0, $pos); 
						$temp_group_id = substr($row->itemid_usergroupid, $pos+2, 100); 
						if($temp_group_id==$aua_usergroup){
							$access_array_items[] = $temp_item_id;
						}
					}					
				}
				
				//print_r($access_array_items);
				
				//access for categories	or pages
				if($pi_ua_config['active_categories'] || $pi_ua_config['active_pagesaccess']){
					$access_array_categories = array();		
					if($pi_ua_config['com_content_access']=='category_access' && $pi_ua_config['active_categories']){					
						//access for categories							
						$database->setQuery("SELECT category_groupid FROM #__pi_aua_categories  " );
						$rows = $database->loadObjectList();
						foreach($rows as $row){						
							$pos = strpos($row->category_groupid, '__');						
							//$access_array_categories[] = substr($row->category_groupid, 0, $pos);
							$temp_category_id = substr($row->category_groupid, 0, $pos); 
							$temp_group_id = substr($row->category_groupid, $pos+2, 100); 
							if($temp_group_id==$aua_usergroup){
								$access_array_categories[] = $temp_category_id;
							}
						}				
					}elseif($pi_ua_config['com_content_access']=='page_access' && $pi_ua_config['active_pagesaccess']){											
						//get page access data
						$database->setQuery("SELECT pageid_usergroupid FROM #__pi_aua_access_pages");
						$pages_access_rights = $database->loadResultArray();		
							
						//make array of pages which user has access to		
						$user_page_access_array = '';
						$first = true;		
						for($n = 0; $n < count($pages_access_rights); $n++){
							$right = $pages_access_rights[$n];			
							$right = explode('_', $right);			
							if($right[1]==$aua_usergroup){				
								if(!$first){
									$user_page_access_array .= ',';				
								}
								$user_page_access_array .= $right[0];
								if($first){
									$first = false;					
								}
							}
						}	
						//print_r($user_page_access_array);
						//get page data
						$database->setQuery("SELECT id, link, componentid, type FROM #__menu WHERE id in ($user_page_access_array)");
						$all_menuitems = $database->loadObjectList();		
						
						$all_menuitems_with_categories = array();
						//make a new array from all categories which are used as category-blog-pages in menu
						foreach($all_menuitems as $menuitem){
							if(((strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog') && $menuitem->type=='url') || !strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog')) && $menuitem->type!='content_blog_category'){
								//something else	
							}else{
								//category-blog-page
								array_push($all_menuitems_with_categories, $menuitem->id);		
							}
						}		
						//print_r($all_menuitems_with_categories);
						
						//get categories from menuitems							
						foreach($all_menuitems as $menuitem){
							if(in_array($menuitem->id,$all_menuitems_with_categories)){			
								if(defined('_JEXEC')){
									//joomla 1.5
									$cat_id = str_replace('index.php?option=com_content&view=category&layout=blog&id=','',$menuitem->link);				
								}else{	
									//joomla 1.0.x
									$cat_id = $menuitem->componentid;				
								}
								array_push($access_array_categories, $cat_id);				
							}							
						}			
					}
								
				}
				
				//print_r($access_array_categories);							
				
				//access for sections
				if($pi_ua_config['active_sections']){
					//access for sections						
					$access_array_sections = array();						
					$database->setQuery("SELECT section_groupid FROM #__pi_aua_sections  " );
					$rows = $database->loadObjectList();
					foreach($rows as $row){						
						$pos = strpos($row->section_groupid, '__');							
						$temp_section_id = substr($row->section_groupid, 0, $pos); 
						$temp_group_id = substr($row->section_groupid, $pos+2, 100);
						if($temp_group_id==$aua_usergroup){
							$access_array_sections[] = $temp_section_id;
						}
					}
				}	
				
				//print_r($access_array_sections);	
				
				//access for workflow when not the author
				if($pi_ua_config['active_actions']){
				
					//get workflow data		
					$workflow_rights = $this->aua_get_workflow_rights();	
			
					//set workflow right to check workflow
					$workflow_right = '38__'.$aua_usergroup;
					if(!in_array($workflow_right, $workflow_rights)){
						//no access to articles by other users
						//make array
					
					}				
				}	
				
				//make array of itemid's with access for this user
				//get all content data				
				$database->setQuery("SELECT id, catid, sectionid, created_by FROM #__content  " );
				$rows = $database->loadObjectList();
				
				$user = JFactory::getUser();
				$user_id = $user->get('id');
				
				$item_access_array = array();
				//loop through array and check access for each of access types: item, cat and section		
				foreach($rows as $row){						
					if($pi_ua_config['active_items']){
						$access_items = false;						
						if(in_array($row->id, $access_array_items)){
							$access_items = true;
						}
					}else{
						$access_items = true;
					}
					if($pi_ua_config['active_categories'] || $pi_ua_config['active_pagesaccess']){
						$access_categories = false;
						if(in_array($row->catid, $access_array_categories)){
							$access_categories = true;
						}
					}else{
						$access_categories = true;
					}
					if($pi_ua_config['active_sections']){
						$access_sections = false;
						if(in_array($row->sectionid, $access_array_sections)){
							$access_sections = true;
						}
					}else{
						$access_sections = true;
					}
					$access_workflow = true;
					if($pi_ua_config['active_actions']){
					
						//get workflow data		
						$workflow_rights = $this->aua_get_workflow_rights();	
				
						//set workflow right to check workflow
						$workflow_right = '38__'.$aua_usergroup;
						if(!in_array($workflow_right, $workflow_rights)){
							//no access to articles by other users
							if($row->created_by != $user_id){
								$access_workflow = false;
							}							
						}
					}
					if($access_items && $access_categories && $access_sections && $access_workflow){
						$item_access_array[] = $row->id;
					}					
				}
				
				//print_r($item_access_array);				
				
				//disable article-links and add no-access image
				if($jquery_included==false){
					echo '<script language="JavaScript" type="text/javascript" src="modules/';
					if(defined('_JEXEC')){
						//joomla 1.5
						echo 'mod_admin_user_access_backend/';	
					}			
					echo 'jquery-1_3_2.js"></script>'."\n";	
				}
				echo '<script language="javascript" type="text/javascript">'."\n";		
				echo 'var AUA_jQuery = jQuery.noConflict();';
				echo 'AUA_jQuery(document).ready(function() {'."\n";
				//make article access array
				echo 'var items_with_access = [';	
				if($pi_ua_config['active_actions'] && !$edit){
					//if not allowed to edit, echo empty array
				}else{			
					for($n = 0; $n < count($item_access_array); $n++){
						if($n!=0){
							echo ',';
						}
						echo '"'.$item_access_array[$n].'"';	
					}
				}
				echo '];'."\n";	
				
				echo 'AUA_jQuery("table.adminlist tr input").each(function (i) {'."\n";			
					//loop input elements within tr's
					echo 'if(this.name == "cid[]"){'."\n";
						//checkbox
						echo 'item_id = this.value;'."\n";
						echo 'if(AUA_jQuery.inArray(item_id, items_with_access)==-1){'."\n";						
							echo 'AUA_jQuery(this).attr({disabled: "true"});'."\n";
							echo 'td_element = AUA_jQuery(this).parent();'."\n";
							echo 'tr_element = AUA_jQuery(td_element).parent();'."\n";				
							echo 'AUA_jQuery(tr_element).addClass("aua_disable_link");'."\n";					
						echo '}'."\n";				
					echo '}'."\n";		
				echo '});'."\n";
				
				echo 'AUA_jQuery("table.adminlist .aua_disable_link a").each(function (i) {'."\n";
					echo 'href = this.href;'."\n";	
					echo 'pos = href.indexOf(\'index.php?option=com_content\');'."\n";	
					echo 'pos2 = href.indexOf(\'reorder\');'."\n";				
					echo 'if(pos!=\'-1\' && pos2==\'-1\'){'."\n";				
						echo 'link_string = AUA_jQuery(this).html();'."\n";				
						echo 'no_access_img = \'<img src="components/com_pi_admin_user_access/images/no_access.gif" alt="no access" /> \';'."\n";
						echo 'AUA_jQuery(this).replaceWith(no_access_img+link_string);'."\n";
					echo '}'."\n";
					
					echo '//take links on icons and access level out'."\n";	
					//echo 'if(this.href == "javascript:void(0);" || this.href == "javascript:%20void(0);" || this.href == "javascript: void(0);"){'."\n";
					echo 'if(this.href == "javascript:void(0);"){'."\n";
						echo 'temp_icon = this.innerHTML;'."\n";			
						echo 'AUA_jQuery(this).replaceWith(temp_icon);'."\n";		  
					echo '}'."\n"; 		
				echo '});'."\n";	
							
				echo '});'."\n";	
				echo '</script>'."\n";					
			}
				
			if($pi_ua_config['active_actions']){
			
				//get workflow data		
				$workflow_rights = $this->aua_get_workflow_rights();	
		
				//set workflow right to check workflow
				$workflow_right = '181__'.$aua_usergroup;
				if(!in_array($workflow_right, $workflow_rights)){
					if($jquery_included==false){
						echo '<script language="JavaScript" type="text/javascript" src="modules/';
						if(defined('_JEXEC')){
							//joomla 1.5
							echo 'mod_admin_user_access_backend/';	
						}			
						echo 'jquery-1_3_2.js"></script>'."\n";	
					}
					echo '<script language="javascript" type="text/javascript">'."\n";		
					echo 'var AUA_jQuery = jQuery.noConflict();';
					echo 'AUA_jQuery(document).ready(function() {'."\n";
								
					//only take reorder stuff out if user has workflow right
					echo 'AUA_jQuery("input").each(function (i) {'."\n";
					echo 'if(this.name=="order[]"){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";		
					echo '});'."\n";
					
					//take out reorder save button
					echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";
					echo 'if(this.href.indexOf("reorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";	
					echo 'if(this.href.indexOf("saveorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";
					echo '});'."\n";	
								
					echo '});'."\n";	
					echo '</script>'."\n";
				}
			}		
		}
	}
	
	function filter_javascript($script_things){
		$there_are_script_restrictions = 0;
		for($n = 0; $n < count($script_things); $n++){
			if(!$script_things[$n][1]){
				$there_are_script_restrictions = 1;													
			}
		}
		if($there_are_script_restrictions){
			echo 'if(';										
			$first_script_thing = 1;
			for($n = 0; $n < count($script_things); $n++){							
				if(!$script_things[$n][1]){
					if(!$first_script_thing){
						echo ' && ';
					}
					echo 'task!=\''.$script_things[$n][0].'\'';
					$first_script_thing = 0;
				}
			}
			echo '){'."\n";						
		}
		if(defined('_JEXEC')){
			//joomla 1.5
			echo 'submitbutton(task);'."\n";
		}else{
			//joomla 1.0.x
			echo 'submitform(task);'."\n";
		}		
		if($there_are_script_restrictions){
			echo '}'."\n";
		}
	}
	
	//take out when free
	function aua_get_workflow_rights(){
		global $database;
	
		static $aua_workflow_rights;
		
		if(!$aua_workflow_rights){	
			//get workflow data
			$database->setQuery("SELECT action_usergroupid FROM #__pi_aua_actions");
			$workflow_rights = $database->loadResultArray();
		}
		
		return $workflow_rights;
	}
	
	//take out when free
	function check_workflow($right){	
		global $aua_usergroup, $pi_ua_config;		
		
		$permission = true;
		if($pi_ua_config['active_actions']){
			$workflow_rights = $this->aua_get_workflow_rights();
			$workflow_right = $right.'__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights) && $this->check_trial_version_aua($pi_ua_config)){			
				$permission = false;
			}	
		}	
		return $permission;
	}
	
	//take out when free
	function aua_disable_stuff(){	
	
		//include jquery
		echo '<script language="JavaScript" type="text/javascript" src="modules/mod_admin_user_access_backend/jquery-1_3_2.js"></script>'."\n";	
		
		
		
		$publish = $this->check_workflow('31');
		$nopublish = $this->check_workflow('49');
		$unpublish = $this->check_workflow('32');
		$frontpage = $this->check_workflow('34');
		$nofrontpage = $this->check_workflow('54');		
		$reorder = $this->check_workflow('35');		
		$alias = $this->check_workflow('55');	
		$section_selector = $this->check_workflow('56');			
		$category_selector	 = $this->check_workflow('57');		
		$author = $this->check_workflow('58');			
		$author_alias = $this->check_workflow('59');			
		$access_level = $this->check_workflow('60');			
		$creation_date = $this->check_workflow('61');			
		$publish_date = $this->check_workflow('62');			
		$unpublish_date	 = $this->check_workflow('63');		
		$show_title = $this->check_workflow('64');			
		$title_linkable	 = $this->check_workflow('65');		
		$intro_text	 = $this->check_workflow('66');		
		$section_name	 = $this->check_workflow('67');		
		$section_name_linkable = $this->check_workflow('68');			
		$category_title = $this->check_workflow('69');			
		$category_title_linkable = $this->check_workflow('70');			
		$article_rating	 = $this->check_workflow('71');		
		$author_name = $this->check_workflow('72');			
		$creation_date_time	 = $this->check_workflow('73');		
		$modified_date_time	 = $this->check_workflow('74');		
		$pdf_icon	 = $this->check_workflow('75');		
		$print_icon	 = $this->check_workflow('76');		
		$email_icon	 = $this->check_workflow('77');		
		$content_language	 = $this->check_workflow('78');		
		$key_reference	 = $this->check_workflow('79');		
		$alternative_read_more	 = $this->check_workflow('80');		
		$description	 = $this->check_workflow('81');		
		$keywords = $this->check_workflow('82');			
		$robots	 = $this->check_workflow('83');		
		$author_metainfo = $this->check_workflow('84');
		
		echo '<script language="JavaScript" type="text/javascript">';
		echo 'var AUA_jQuery = jQuery.noConflict();';
		echo 'String.prototype.replaceAll = function(strTarget, strSubString){
	var strText = this;
	var intIndexOfMatch = strText.indexOf( strTarget );   
	while (intIndexOfMatch != -1){ 
		strText = strText.replace( strTarget, strSubString )   
		intIndexOfMatch = strText.indexOf( strTarget );
	}  
	return( strText );
}'."\n";
		echo 'function aua_disable_things(){'."\n";
			if(defined('_JEXEC')){
				//joomla 1.5
				if(!$publish){
					if($nopublish){
						echo 'document.getElementById(\'state0\').checked = true;'."\n";
					}
					echo 'document.getElementById(\'state0\').disabled = true;'."\n";
					echo 'document.getElementById(\'state1\').disabled = true;'."\n";
					
				}	
				if(!$unpublish){		
					echo 'document.getElementById(\'state0\').disabled = true;'."\n";
				}
				if(!$frontpage){	
					if($nofrontpage){
						echo 'document.getElementById(\'frontpage0\').checked = true;'."\n";
					}	
					echo 'document.getElementById(\'frontpage0\').disabled = true;'."\n";
					echo 'document.getElementById(\'frontpage1\').disabled = true;'."\n";
				}
				if(!$access_level){		
					echo 'document.getElementById(\'detailsaccess\').disabled = true;'."\n";
				}				
				if(!$alias){		
					echo 'document.getElementById(\'alias\').disabled = true;'."\n";
				}
				if(!$section_selector){		
					echo 'document.getElementById(\'sectionid\').disabled = true;'."\n";
				}
				if(!$category_selector){		
					echo 'document.getElementById(\'catid\').disabled = true;'."\n";
				}
				if(!$author){	
					//echo 'alert(document.getElementById(\'detailscreated_by\').value);';	
					//echo 'document.getElementById(\'detailscreated_by\').disabled = true;'."\n";					
					echo 'created_by = AUA_jQuery("#detailscreated_by").val();'."\n";
					echo 'created_by_select_parent = AUA_jQuery("#detailscreated_by").parent();'."\n";
					echo 'created_by_select_html = AUA_jQuery(created_by_select_parent).html();'."\n";
					//make copy
					echo 'created_by_select_html2 = created_by_select_html'."\n";								
					echo 'created_by_select_html2 = created_by_select_html2.replace("detailscreated_by", "detailscreated_by2")'."\n";	
					echo 'created_by_select_html2 = created_by_select_html2.replace("details[created_by]", "details[created_by2]")'."\n";					
					//put them back on the page
					echo 'AUA_jQuery(created_by_select_parent).html(created_by_select_html+created_by_select_html2);'."\n";
					//disable the copy so you can still see the name
					echo 'AUA_jQuery("#detailscreated_by2").attr("disabled","disabled");'."\n";
					//hide the original so value is parsed
					echo 'AUA_jQuery("#detailscreated_by").css("display","none");'."\n";					
				}
				if(!$author_alias){		
					echo 'document.getElementById(\'detailscreated_by_alias\').disabled = true;'."\n";
				}
				if(!$creation_date){		
					echo 'document.getElementById(\'detailscreated\').disabled = true;'."\n";
					echo 'document.getElementById(\'detailscreated_img\').style.display = \'none\';'."\n";					
				}
				if(!$publish_date){		
					echo 'document.getElementById(\'detailspublish_up\').disabled = true;'."\n";
					echo 'document.getElementById(\'detailspublish_up_img\').style.display = \'none\';'."\n";
				}
				if(!$unpublish_date){		
					echo 'document.getElementById(\'detailspublish_down\').disabled = true;'."\n";
					echo 'document.getElementById(\'detailspublish_down_img\').style.display = \'none\';'."\n";
				}
				if(!$show_title){		
					echo 'document.getElementById(\'paramsshow_title\').disabled = true;'."\n";
				}
				if(!$title_linkable){		
					echo 'document.getElementById(\'paramslink_titles\').disabled = true;'."\n";
				}
				if(!$intro_text){		
					echo 'document.getElementById(\'paramsshow_intro\').disabled = true;'."\n";
				}
				if(!$section_name){		
					echo 'document.getElementById(\'paramsshow_section\').disabled = true;'."\n";
				}
				if(!$section_name_linkable){		
					echo 'document.getElementById(\'paramslink_section\').disabled = true;'."\n";
				}
				if(!$category_title){		
					echo 'document.getElementById(\'paramsshow_category\').disabled = true;'."\n";
				}
				if(!$category_title_linkable){		
					echo 'document.getElementById(\'paramslink_category\').disabled = true;'."\n";
				}
				if(!$article_rating){		
					echo 'document.getElementById(\'paramsshow_vote\').disabled = true;'."\n";
				}
				if(!$author_name){		
					echo 'document.getElementById(\'paramsshow_author\').disabled = true;'."\n";
				}
				if(!$creation_date_time){		
					echo 'document.getElementById(\'paramsshow_create_date\').disabled = true;'."\n";
				}
				if(!$modified_date_time){		
					echo 'document.getElementById(\'paramsshow_modify_date\').disabled = true;'."\n";
				}
				if(!$pdf_icon){		
					echo 'document.getElementById(\'paramsshow_pdf_icon\').disabled = true;'."\n";
				}
				if(!$print_icon){		
					echo 'document.getElementById(\'paramsshow_print_icon\').disabled = true;'."\n";
				}
				if(!$email_icon){		
					echo 'document.getElementById(\'paramsshow_email_icon\').disabled = true;'."\n";
				}
				if(!$content_language){		
					echo 'document.getElementById(\'paramslanguage\').disabled = true;'."\n";
				}
				if(!$key_reference){		
					echo 'document.getElementById(\'paramskeyref\').disabled = true;'."\n";
				}
				if(!$alternative_read_more){		
					echo 'document.getElementById(\'paramsreadmore\').disabled = true;'."\n";
				}
				if(!$description){		
					echo 'document.getElementById(\'metadescription\').disabled = true;'."\n";
				}
				if(!$keywords){		
					echo 'document.getElementById(\'metakeywords\').disabled = true;'."\n";
				}
				if(!$robots){		
					echo 'document.getElementById(\'metarobots\').disabled = true;'."\n";
				}
				if(!$author_metainfo){		
					echo 'document.getElementById(\'metaauthor\').disabled = true;'."\n";
				}	
				
				if(!$this->check_workflow('200')){					
					echo 'document.getElementById(\'toolbar-help\').style.display = \'none\';'."\n";		
				}		
								
			}else{
				//joomla 1.0.x				
				if(!$publish || !$unpublish){
					echo 'document.adminForm.published.disabled = true;'."\n";
				}
				if($nopublish){
					echo 'document.adminForm.published.checked = false;'."\n";
				}				
				if(!$frontpage){		
					echo 'document.adminForm.frontpage.disabled = true;'."\n";
				}
				if($nofrontpage){
					echo 'document.adminForm.frontpage.checked = false;'."\n";
				}	
				if(!$access_level){		
					echo 'document.adminForm.access.disabled = true;'."\n";
				}
				
				if(!$alias){		
					echo 'document.adminForm.title_alias.disabled = true;'."\n";
				}
				if(!$section_selector){		
					echo 'document.adminForm.sectionid.disabled = true;'."\n";
				}
				if(!$category_selector){		
					echo 'document.adminForm.catid.disabled = true;'."\n";
				}
				if(!$author){		
					echo 'document.adminForm.created_by.disabled = true;'."\n";
				}
				if(!$author_alias){		
					echo 'document.adminForm.created_by_alias.disabled = true;'."\n";
				}
				if(!$creation_date){		
					echo 'document.adminForm.created.disabled = true;'."\n";
					echo 'document.adminForm.reset.style.display = \'none\';'."\n";					
				}
				if(!$show_title){		
					echo 'document.getElementById(\'params[item_title]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[item_title]1\').disabled = true;'."\n";
				}				
				if(!$intro_text){		
					echo 'document.getElementById(\'params[introtext]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[introtext]1\').disabled = true;'."\n";
				}
				if(!$section_name){		
					echo 'document.getElementById(\'params[section]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[section]1\').disabled = true;'."\n";
				}
				if(!$section_name_linkable){		
					echo 'document.getElementById(\'params[section_link]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[section_link]1\').disabled = true;'."\n";
				}
				if(!$category_title){		
					echo 'document.getElementById(\'params[category]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[category]1\').disabled = true;'."\n";
				}
				if(!$category_title_linkable){		
					echo 'document.getElementById(\'params[category_link]0\').disabled = true;'."\n";
					echo 'document.getElementById(\'params[category_link]1\').disabled = true;'."\n";
				}						
				if(!$description){		
					echo 'document.adminForm.metadesc.disabled = true;'."\n";
				}
				if(!$keywords){		
					echo 'document.adminForm.metakey.disabled = true;'."\n";
				}
							
			}
			
			//rip section-uncategorized out if needed
			if($this->check_workflow('27')){
				$this->rip_sections_uncategorized_out();			
			}
			
						
						
		echo '}'."\n";
		
		echo 'if(window.addEventListener)window.addEventListener("load",aua_disable_things,false);else if(window.attachEvent)window.attachEvent("onload",aua_disable_things);					
		</script>'."\n";
		
	}
	
	function rip_sections_uncategorized_out(){				
		echo "var elSel = document.getElementById('sectionid');\n";
		echo 'var i;'."\n";		
		echo 'if(document.getElementById(\'sectionid\')!= null){'."\n";		
			echo 'for (i = elSel.length - 1; i>=0; i--){'."\n";									
				echo 'if (elSel.options[i].value == "0"){'."\n";						
					echo 'elSel.remove(i);'."\n";										
				echo '}'."\n";								
			echo '}'."\n";
		echo '}'."\n";		
	}
	
	//take out when free
	function rip_sections_out($database, $item_id, $aua_usergroup){
	
		//get section access data
		$database->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
		$section_access_rights = $database->loadResultArray();
		
		//get section from id
		$database->setQuery("SELECT sectionid FROM #__content WHERE id='$item_id' LIMIT 1");		
		$item_rows = $database->loadObjectList();
		$section_id = '';
		foreach($item_rows as $item_row){
			$section_id = $item_row->sectionid;
		}		
		
		$section_right = $section_id.'__'.$aua_usergroup;		
		
		//get sections
		$database->setQuery("SELECT id FROM #__sections");
		$all_sections = $database->loadResultArray();	
					
		//make array from sections which user has access to
		$user_sectons_access_array = array();		
		for($n = 0; $n < count($section_access_rights); $n++){
			$right = $section_access_rights[$n];			
			$right = explode('__', $right);			
			if($right[1]==$aua_usergroup){
				array_push($user_sectons_access_array, $right[0]);
			}
		}	
		
		//make array of sections user has NO access to
		$sections_with_no_access = array();
		foreach($all_sections as $section){
			if(!in_array($section, $user_sectons_access_array)){
				array_push($sections_with_no_access, $section);
			}
		}
		
		echo '<script language="javascript" type="text/javascript">'."\n";			
		
		$javascript_array_sections_no_access = 'var sections_with_no_access = new Array(';
		
		$first = true;	
		foreach($sections_with_no_access as $section_no_access){
			if($first){
				$first = false;
			}else{
				$javascript_array_sections_no_access .= ',';
			}			
			$javascript_array_sections_no_access .= '"'.$section_no_access.'"';
		}		
		$javascript_array_sections_no_access .= ');';
		echo $javascript_array_sections_no_access."\n";				
		
		//javascript function to rip sections out of select
		echo 'function rip_sections_out_of_select(){'."\n";			
			echo "var elSel = document.adminForm.sectionid;\n";
			echo 'var i;'."\n";			
			echo 'if(document.adminForm.sectionid!= null){'."\n";						
				echo 'for (i = elSel.length - 1; i>=0; i--){'."\n";				
					echo 'for (j=0; j < sections_with_no_access.length; j++) {'."\n";	
						echo 'if (elSel.options[i]){'."\n";			
							echo 'if (sections_with_no_access[j] === elSel.options[i].value){'."\n";						
								echo 'elSel.remove(i);'."\n";										
							echo '}'."\n";
						echo '}'."\n";
					echo '}'."\n";				
				echo '}'."\n";	
			echo '}'."\n";					
		echo '}'."\n";			
		
		//call onload event
		echo 'if(window.addEventListener)window.addEventListener("load",rip_sections_out_of_select,false);'."\n";
		echo 'else if(window.attachEvent)window.attachEvent("onload",rip_sections_out_of_select);'."\n";
		
		echo '</script>'."\n";	
	}	
	
	function rip_categories_out($database, $aua_usergroup){
		//get category access data
		$database->setQuery("SELECT category_groupid FROM #__pi_aua_categories");
		$category_access_rights = $database->loadResultArray();			
		
		//get categories
		$database->setQuery("SELECT id FROM #__categories");
		$all_categories = $database->loadResultArray();	
					
		//make array from categories which user has access to
		$all_categories_access = array();		
		for($n = 0; $n < count($category_access_rights); $n++){
			$right = $category_access_rights[$n];			
			$right = explode('__', $right);			
			if($right[1]==$aua_usergroup){
				array_push($all_categories_access, $right[0]);
			}
		}		
		
		echo '<script language="javascript" type="text/javascript">'."\n";			
		
		//make javascript array of categories which user has access to
		$javascript_array_category_access = 'var categories_with_access = new Array(';		
		$first = true;	
		foreach($all_categories_access as $category){
			if($first){
				$first = false;
			}else{
				$javascript_array_category_access .= ',';
			}			
			$javascript_array_category_access .= '"'.$category.'"';
		}		
		$javascript_array_category_access .= ');';
		echo $javascript_array_category_access."\n\n";		
			
		//javascript in_array function
		echo 'Array.prototype.in_array = function (element){'."\n";
			echo 'var retur = false;'."\n";
			echo 'for (var values in this){'."\n";
				echo 'if (this[values] == element){'."\n";
					echo 'retur = true;'."\n";
					echo 'break;'."\n";
				echo '}'."\n";
			echo '}'."\n";
			echo 'return retur;'."\n";
		echo '};'."\n\n";
		
		echo 'function filter_categories(){'."\n";
			//take categories out of array			
			echo 'for (i = 0; i < sectioncategories.length; i++){'."\n";											
				echo 'if(!categories_with_access.in_array(sectioncategories[i][1])){'."\n";								
					echo 'sectioncategories.splice(i,1);'."\n";														
					echo 'i = i-1;'."\n";																	
				echo '}'."\n";																	
			echo '}'."\n";	
			// reset section select				
			echo 'document.getElementById("sectionid").options[0].selected = true;'."\n";
			// reset category select	
			echo 'changeDynaList(\'catid\', sectioncategories, 0, 0, 0);'."\n";																		
		echo '}'."\n\n";//end function
		
		//call onload event
		echo 'if(window.addEventListener)window.addEventListener("load",filter_categories,false);'."\n";
		echo 'else if(window.attachEvent)window.attachEvent("onload",filter_categories);'."\n";
		
		echo '</script>';	
		
		
		
	}
	
	//take out when free
	function check_module_access($module_id, $aua_usergroup, $pi_ua_config){
		global $database;
		
		if($pi_ua_config['activate_modules']){
			//get module access rights
			$database->setQuery("SELECT module_groupid FROM #__pi_aua_modules");
			$module_rights = $database->loadResultArray();
			
			$module_right = $module_id.'__'.$aua_usergroup;
			$access = false;
			if(!in_array($module_right, $module_rights)){			
				//no access
				//unlock module
				$database->setQuery( "UPDATE #__modules SET checked_out='0', checked_out_time='0' WHERE id='$module_id' "	);
				$database->query();	
				
				//get language
				$this->get_language();
				
				//do message and exit				
				$this->do_message(_pi_ua_lang_no_module_access);	
							
			}
		}
		
		//disable reordering if restricted in workflow	
		if($pi_ua_config['active_actions']){
		
			//include jquery
			echo '<script language="JavaScript" type="text/javascript" src="modules/';
			if(defined('_JEXEC')){
				//joomla 1.5
				echo 'mod_admin_user_access_backend/';	
			}			
			echo 'jquery-1_3_2.js"></script>'."\n";	
			
			//get workflow data		
			$workflow_rights = $this->aua_get_workflow_rights();
			
			echo '<script language="javascript" type="text/javascript">'."\n";		
			echo 'var AUA_jQuery = jQuery.noConflict();'."\n";
			echo 'AUA_jQuery(document).ready(function() {'."\n";
			
			//title		
			$workflow_right = '188__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				//echo 'AUA_jQuery("#title").attr("disabled","disabled");'."\n";
				//echo 'title_field = document.getElementById(\'title\').outerHTML;'."\n";
				echo 'var module_title = AUA_jQuery("#title").val();'."\n";
				echo 'AUA_jQuery("#title").css("display","none");'."\n";				
				echo 'AUA_jQuery("#title").after(module_title);'."\n";
			}
				
			//show title		
			$workflow_right = '183__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#showtitle0").attr("disabled","disabled");'."\n";
				echo 'AUA_jQuery("#showtitle1").attr("disabled","disabled");'."\n";
			}
			
			//enable		
			$workflow_right = '184__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#published0").attr("disabled","disabled");'."\n";
				echo 'AUA_jQuery("#published1").attr("disabled","disabled");'."\n";
			}
			
			//position		
			$workflow_right = '185__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#position").attr("disabled","disabled");'."\n";				
			}
			
			//reordering		
			$workflow_right = '179__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#ordering").attr("disabled","disabled");'."\n";
			}
			
			//access		
			$workflow_right = '186__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#access").attr("disabled","disabled");'."\n";
			}
			
			//access		
			$workflow_right = '201__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#toolbar-help").css("display","none");'."\n";
			}
			
			//menu		
			$workflow_right = '187__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'checked_menu_thing = \'<input type="radio" name="fake_menus_group" value="" checked="checked" disabled="disabled" />\';'."\n";
				echo 'unchecked_menu_thing = \'<input type="radio" name="fake_menus_group" value="" disabled="disabled" />\';'."\n";
				
				
				echo 'menusallselected = AUA_jQuery("#menus-all").attr("checked");'."\n";				
				echo 'if(menusallselected){'."\n";				
					echo 'AUA_jQuery("#menus-all").after(checked_menu_thing);'."\n";				
				echo '}else{'."\n";
					echo 'AUA_jQuery("#menus-all").after(unchecked_menu_thing);'."\n";					
				echo '}'."\n";
				echo 'AUA_jQuery("#menus-all").attr("onclick","");'."\n";
				echo 'AUA_jQuery("#menus-all").css("display","none");'."\n";
				
				echo 'menusnoneselected = AUA_jQuery("#menus-none").attr("checked");'."\n";				
				echo 'if(menusnoneselected){'."\n";				
					echo 'AUA_jQuery("#menus-none").after(checked_menu_thing);'."\n";				
				echo '}else{'."\n";
					echo 'AUA_jQuery("#menus-none").after(unchecked_menu_thing);'."\n";					
				echo '}'."\n";
				echo 'AUA_jQuery("#menus-none").attr("onclick","");'."\n";
				echo 'AUA_jQuery("#menus-none").css("display","none");'."\n";
				
				echo 'menusselectselected = AUA_jQuery("#menus-select").attr("checked");'."\n";				
				echo 'if(menusselectselected){'."\n";				
					echo 'AUA_jQuery("#menus-select").after(checked_menu_thing);'."\n";				
				echo '}else{'."\n";
					echo 'AUA_jQuery("#menus-select").after(unchecked_menu_thing);'."\n";					
				echo '}'."\n";
				echo 'AUA_jQuery("#menus-select").attr("onclick","");'."\n";
				echo 'AUA_jQuery("#menus-select").css("display","none");'."\n";				
				
				echo 'selectorthing = AUA_jQuery("#selections").clone()'."\n";				
				echo 'AUA_jQuery(selectorthing).attr("id","aua_bogus_id");'."\n";
				echo 'AUA_jQuery(selectorthing).attr("disabled","disabled");'."\n";				
				echo 'AUA_jQuery("#selections").after(selectorthing);'."\n";
				echo 'AUA_jQuery("#selections").css("display","none");'."\n";
			}
					
			echo '});'."\n";
			echo '</script>'."\n";
		}	
	}
	
	function do_message($message){
		exit('<html><body>'.$message.' <a href="javascript:window.history.go(-1);">'._pi_ua_lang_back.'</a></body></html>');
	}
	
	function get_language(){
		global $pi_ua_config;
		
		if(defined('_JEXEC')){
			//joomla 1.5				
			$path_to_root = '/../../..';		
		}else{
			//joomla 1.0.x		
			$path_to_root = '/../..';
		}	
		
		if(file_exists(dirname(__FILE__).$path_to_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php')){
			require_once(dirname(__FILE__).$path_to_root.'/administrator/components/com_pi_admin_user_access/language/'.$pi_ua_config['language'].'.php');
		}else{
			require_once(dirname(__FILE__).$path_to_root.'/administrator/components/com_pi_admin_user_access/language/english.php');
		}
	}
	
	//take out when free
	function check_plugin_access($plugin_id, $aua_usergroup, $pi_ua_config){
		global $database;		
		
		if($pi_ua_config['activate_plugins']){
			//get plugins access rights
			$database->setQuery("SELECT plugin_groupid FROM #__pi_aua_plugins");
			$plugin_rights = $database->loadResultArray();
			
			$plugin_right = $plugin_id.'__'.$aua_usergroup;
			$access = false;
			if(!in_array($plugin_right, $plugin_rights)){			
				//no access
				//unlock plugin
				$database->setQuery( "UPDATE #__plugins SET checked_out='0', checked_out_time='0' WHERE id='$plugin_id' "	);
				$database->query();	
				
				//get language
				$this->get_language();
				
				//do message and exit				
				$this->do_message(_pi_ua_lang_no_plugin_access);	
							
			}
		}
		
		//disable reordering if restricted in workflow	
		if($pi_ua_config['active_actions']){
		
			//include jquery
			echo '<script language="JavaScript" type="text/javascript" src="modules/';
			if(defined('_JEXEC')){
				//joomla 1.5
				echo 'mod_admin_user_access_backend/';	
			}			
			echo 'jquery-1_3_2.js"></script>'."\n";	
			
			//get workflow data		
			$workflow_rights = $this->aua_get_workflow_rights();
			
			echo '<script language="javascript" type="text/javascript">'."\n";		
			echo 'var AUA_jQuery = jQuery.noConflict();'."\n";
			echo 'AUA_jQuery(document).ready(function() {'."\n";
			
			//name		
			$workflow_right = '189__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#name").attr("disabled","disabled");'."\n";
			}
				
			//enabled
			$workflow_right = '190__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#published0").attr("disabled","disabled");'."\n";
				echo 'AUA_jQuery("#published1").attr("disabled","disabled");'."\n";
			}
			
			//file		
			$workflow_right = '191__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#element").attr("disabled","disabled");'."\n";		
			}
			
			//access		
			$workflow_right = '192__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#access").attr("disabled","disabled");'."\n";				
			}
			
			//reordering		
			$workflow_right = '180__'.$aua_usergroup;
			if(!in_array($workflow_right, $workflow_rights)){				
				echo 'AUA_jQuery("#ordering").attr("disabled","disabled");'."\n";
			}					
					
			echo '});'."\n";
			echo '</script>'."\n";
		}			
	}
	
	function module_manager($user_type, $pi_ua_config, $aua_usergroup){
	
		global $database;
		
		if($user_type!='Super Administrator'){
	
			//take out buttons to enable and disable, edit button
			if($pi_ua_config['activate_modules'] || $pi_ua_config['active_actions']){		
				echo '<style>';			
				echo '#toolbar-edit{';
					echo 'display: none;';
				echo '}';
				
				if($pi_ua_config['active_actions']){					
					$enable = $this->check_workflow('184');
					$copy = $this->check_workflow('193');
					$delete = $this->check_workflow('194');
					$new = $this->check_workflow('195');
					$help = $this->check_workflow('201');
					if(!$enable){
						echo '#toolbar-publish, #toolbar-unpublish{
							display: none;
						}';
					}
					if(!$copy){
						echo '#toolbar-copy{
							display: none;
						}';
					}
					if(!$delete){
						echo '#toolbar-delete{
							display: none;
						}';
					}
					if(!$new){
						echo '#toolbar-new{
							display: none;
						}';
					}
					if(!$help){
						echo '#toolbar-help{
							display: none;
						}';
					}
				}
				echo '</style>
				';				
			}
			
			$jquery_included = false;
			
			//take out links on images to enable and disable
			if($pi_ua_config['activate_modules'] || $pi_ua_config['active_actions']){			
				echo '<script language="JavaScript" type="text/javascript" src="modules/';
				if(defined('_JEXEC')){
					//joomla 1.5
					echo 'mod_admin_user_access_backend/';	
				}			
				echo 'jquery-1_3_2.js"></script>'."\n";	
				$jquery_included = true;
				echo '<script language="javascript" type="text/javascript">'."\n";		
				echo 'var AUA_jQuery = jQuery.noConflict();';
				echo 'AUA_jQuery(document).ready(function() {'."\n";
					
				//take links out for reorder and enable/disable		
				echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";				
				echo 'if(this.href == "javascript:void(0);" || this.href == "javascript:%20void(0);" || this.href == "javascript: void(0);"){'."\n";				
				echo 'temp_icon = this.innerHTML;'."\n";				
				echo 'AUA_jQuery(this).replaceWith(temp_icon);	'."\n";
				echo '}'."\n";			
				echo '});'."\n";
					
				//disable links to modules
				if($pi_ua_config['activate_modules']){									
					
					//get module access rights into array
					$database->setQuery("SELECT module_groupid FROM #__pi_aua_modules");
					$module_rights = $database->loadResultArray();					
					$rows = $database->loadObjectList();
					
					$module_access_array = array();	
					foreach($rows as $row){	
						$temp = explode('__', $row->module_groupid);						
						$temp_module = $temp[0]; 
						$temp_group = $temp[1]; 
						if($temp_group==$aua_usergroup){
							$module_access_array[] = $temp_module;
						}
					}						
					
					//echo module access array into javascript array
					echo 'var modules_with_access = [';				
					for($n = 0; $n < count($module_access_array); $n++){
						if($n!=0){
							echo ',';
						}
						echo '"'.$module_access_array[$n].'"';	
					}
					echo '];'."\n";	
					
					echo 'AUA_jQuery("table.adminlist tr input").each(function (i) {'."\n";			
						//loop input elements within tr's
						echo 'if(this.name == "cid[]"){'."\n";
							//checkbox
							echo 'module_id = this.value;'."\n";							
							echo 'if(AUA_jQuery.inArray(module_id, modules_with_access)==-1){'."\n";													
								echo 'AUA_jQuery(this).attr({disabled: "true"});'."\n";
								echo 'td_element = AUA_jQuery(this).parent();'."\n";
								echo 'tr_element = AUA_jQuery(td_element).parent();'."\n";				
								echo 'AUA_jQuery(tr_element).addClass("aua_disable_link");'."\n";					
							echo '}'."\n";				
						echo '}'."\n";		
					echo '});'."\n";
					
					echo 'AUA_jQuery("table.adminlist .aua_disable_link a").each(function (i) {'."\n";
						echo 'href = this.href;'."\n";	
						echo 'pos = href.indexOf(\'index.php?option=com_modules\');'."\n";	
						echo 'pos2 = href.indexOf(\'reorder\');'."\n";				
						echo 'if(pos!=\'-1\' && pos2==\'-1\'){'."\n";				
							echo 'link_string = AUA_jQuery(this).html();'."\n";				
							echo 'no_access_img = \'<img src="components/com_pi_admin_user_access/images/no_access.gif" alt="no access" /> \';'."\n";
							echo 'AUA_jQuery(this).replaceWith(no_access_img+link_string);'."\n";
						echo '}'."\n";						
							
						//take links on icons and access level out
						//echo 'if(this.href == "javascript:void(0);"){'."\n";
							//echo 'temp_icon = this.innerHTML;'."\n";			
							//echo 'AUA_jQuery(this).replaceWith(temp_icon);'."\n";		  
						//echo '}'."\n"; 		
					echo '});'."\n";	
							
					
					
					
				}	
						
				echo '});'."\n";	
				echo '</script>'."\n";		
			}
			
			if($pi_ua_config['active_actions']){				
				
				//disable workflow
				if(!$this->check_workflow('179')){
					if($jquery_included==false){
						echo '<script language="JavaScript" type="text/javascript" src="modules/';
						if(defined('_JEXEC')){
							//joomla 1.5
							echo 'mod_admin_user_access_backend/';	
						}			
						echo 'jquery-1_3_2.js"></script>'."\n";	
					}
					echo '<script language="javascript" type="text/javascript">'."\n";		
					echo 'var AUA_jQuery = jQuery.noConflict();';
					echo 'AUA_jQuery(document).ready(function() {'."\n";
								
					//only take reorder stuff out if user has workflow right
					echo 'AUA_jQuery("input").each(function (i) {'."\n";
					echo 'if(this.name=="order[]"){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";		
					echo '});'."\n";
					
					//take out reorder save button
					echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";
					echo 'if(this.href.indexOf("reorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";	
					echo 'if(this.href.indexOf("saveorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";
					echo '});'."\n";	
								
					echo '});'."\n";	
					echo '</script>'."\n";
				}
			}
		}
	}
	
	function plugin_manager($user_type, $pi_ua_config, $aua_usergroup){
	
		global $database;
		
		if($user_type!='Super Administrator'){
			
			if($pi_ua_config['activate_plugins'] || $pi_ua_config['active_actions']){				
				
				//take out buttons to enable and disable
				echo '<style>';			
				echo '#toolbar-edit{';
					echo 'display: none;';
				echo '}';
				
				if($pi_ua_config['active_actions']){					
					$enable = $this->check_workflow('190');					
					if(!$enable){
						echo '#toolbar-publish, #toolbar-unpublish{
							display: none;
						}';
					}					
				}
				echo '</style>
				';
				
				
				echo '<script language="JavaScript" type="text/javascript" src="modules/';
				if(defined('_JEXEC')){
					//joomla 1.5
					echo 'mod_admin_user_access_backend/';	
				}			
				echo 'jquery-1_3_2.js"></script>'."\n";				
				echo '<script language="javascript" type="text/javascript">'."\n";		
				echo 'var AUA_jQuery = jQuery.noConflict();';
				echo 'AUA_jQuery(document).ready(function() {'."\n";
				
				//take out links on images to enable and disable			
				echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";				
				echo 'if(this.href == "javascript:void(0);" || this.href == "javascript:%20void(0);" || this.href == "javascript: void(0);"){'."\n";
				echo 'temp_icon = this.innerHTML;'."\n";
				echo 'AUA_jQuery(this).replaceWith(temp_icon);	'."\n";
				echo '}'."\n";			
				echo '});'."\n";
				
				if($pi_ua_config['active_actions'] && !$this->check_workflow('180')){	
					//only take reorder stuff out if user has workflow right
					echo 'AUA_jQuery("input").each(function (i) {'."\n";
					echo 'if(this.name=="order[]"){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";		
					echo '});'."\n";
					
					//take out reorder save button
					echo 'AUA_jQuery("table.adminlist a").each(function (i) {'."\n";
					echo 'if(this.href.indexOf("reorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";	
					echo 'if(this.href.indexOf("saveorder")!=-1){'."\n";
					echo 'this.style.display = \'none\';'."\n";
					echo '}'."\n";
					echo '});'."\n";								
				}
				
				//disable links to plugins
				if($pi_ua_config['activate_plugins']){	
				
					//get plugin access rights into array
					$database->setQuery("SELECT plugin_groupid FROM #__pi_aua_plugins");
					$module_rights = $database->loadResultArray();					
					$rows = $database->loadObjectList();
					$plugins_access_array = array();	
					foreach($rows as $row){						
						$pos = strpos($row->plugin_groupid, '__');
						$plugins_access_array[] = substr($row->plugin_groupid, 0, $pos); 
					}	
					
					//echo module access array into javascript array
					echo 'var plugins_with_access = [';				
					for($n = 0; $n < count($plugins_access_array); $n++){
						if($n!=0){
							echo ',';
						}
						echo '"'.$plugins_access_array[$n].'"';	
					}
					echo '];'."\n";	
					
					echo 'AUA_jQuery("table.adminlist tr input").each(function (i) {'."\n";			
						//loop input elements within tr's
						echo 'if(this.name == "cid[]"){'."\n";
							//checkbox
							echo 'plugin_id = this.value;'."\n";
							echo 'if(AUA_jQuery.inArray(plugin_id, plugins_with_access)==-1){'."\n";						
								echo 'AUA_jQuery(this).attr({disabled: "true"});'."\n";
								echo 'td_element = AUA_jQuery(this).parent();'."\n";
								echo 'tr_element = AUA_jQuery(td_element).parent();'."\n";				
								echo 'AUA_jQuery(tr_element).addClass("aua_disable_link");'."\n";					
							echo '}'."\n";				
						echo '}'."\n";		
					echo '});'."\n";
					
					echo 'AUA_jQuery("table.adminlist .aua_disable_link a").each(function (i) {'."\n";
						echo 'href = this.href;'."\n";	
						echo 'pos = href.indexOf(\'index.php?option=com_plugins\');'."\n";	
						echo 'pos2 = href.indexOf(\'reorder\');'."\n";				
						echo 'if(pos!=\'-1\' && pos2==\'-1\'){'."\n";				
							echo 'link_string = AUA_jQuery(this).html();'."\n";				
							echo 'no_access_img = \'<img src="components/com_pi_admin_user_access/images/no_access.gif" alt="no access" /> \';'."\n";
							echo 'AUA_jQuery(this).replaceWith(no_access_img+link_string);'."\n";
						echo '}'."\n";						
					echo '});'."\n";					
								
					
				}
							
				echo '});'."\n";	
				echo '</script>'."\n";
				
				
			}
			
		}
	}
	
	function article_move_copy($pi_ua_config, $aua_usergroup){
		$pi_sections_array = $this->get_sections();	
		$pi_category_array = $this->get_categories();
		
		$pages_array = array();
		foreach($pi_category_array as $pi_category){
			$category_section_id = $pi_category[2];
			foreach($pi_sections_array as $pi_sections){
				if($pi_sections[0]==$category_section_id){
					$pages_array[] = array('', $pi_category[1], $pi_category[0]);
				}
			}
		}		
		
		//make new array combining the 3 arrays and filtering for access
		$array_pages_sections_categories = array();
		for($n = 0; $n < count($pages_array); $n++){
			$page_id = $pages_array[$n][0];
			$page_title = $pages_array[$n][1];
			
			//get the section the pages category is linked to
			for($m = 0; $m < count($pi_category_array); $m++){
				if($pages_array[$n][2]==$pi_category_array[$m][0]){
					$page_cat_id = $pages_array[$n][2];
					$page_section_id = $pi_category_array[$m][2];
					break;
				}
			}
			
			//get section name from id
			for($s = 0; $s < count($pi_category_array); $s++){
				if($page_section_id==$pi_sections_array[$s][0]){
					$page_section_name = $pi_sections_array[$s][1];
					break;
				}
			}
			if($this->check_section_access($page_section_id, $aua_usergroup) && $this->check_category_access($page_cat_id, $aua_usergroup)){			
				$array_pages_sections_categories[] = array($page_id, $page_title, $page_section_name, $page_cat_id, $page_section_id);
			}
		}		
			
		//sort array by order
		$column = '';//reset column if you used this elsewhere
		$column = array();
		foreach($array_pages_sections_categories as $sortarray){
			$column[] = $sortarray[2];	
		}
		$sort_order = SORT_ASC;//define as a var or else ioncube goes mad
		array_multisort($column, $sort_order, $array_pages_sections_categories);	
		
		$sectcat_options = '';
		for($p = 0; $p < count($array_pages_sections_categories); $p++){
			$sectcat_options .= '<option value="'.$array_pages_sections_categories[$p][4].', '.$array_pages_sections_categories[$p][3].'">';				
			$sectcat_options .= $array_pages_sections_categories[$p][2].' / '.$array_pages_sections_categories[$p][1];
			$sectcat_options .= '</option>';
		}
		
		
		echo '<script language="JavaScript" type="text/javascript" src="modules/mod_admin_user_access_backend/jquery-1_3_2.js"></script>'."\n";						
		echo '<script language="javascript" type="text/javascript">'."\n";	
		
		
		
		//rip_cat_sec_out_of_select		
		//echo 'function replace_cats_and_sections(){'."\n";				
			//echo "document.getElementById('sectcat').innerHTML = '".$sectcat_options."';\n";
		//echo '}'."\n";		
		//echo 'if(window.addEventListener)window.addEventListener("load",replace_cats_and_sections,false);'."\n";
		//echo 'else if(window.attachEvent)window.attachEvent("onload",replace_cats_and_sections);'."\n";	
		//echo 'script>';	
		
		//IE can not handle this, so need to do this with jQuery (tsssssssssssssssssss)
		echo 'new_sectcat = \'<select name="sectcat" id="sectcat" class="inputbox" size="10">'.$sectcat_options.'</select>\';';
		echo 'var AUA_jQuery = jQuery.noConflict();'."\n";
		echo 'AUA_jQuery(document).ready(function() {'."\n";
		echo 'AUA_jQuery(\'#sectcat\').replaceWith(new_sectcat);';		
		echo '});'."\n";
		echo '</script>'."\n";
	}
	
	function get_categories(){
		static $pi_category_array;		
		
		if(!$pi_category_array){
			$database = JFactory::getDBO();
			$database->setQuery("SELECT id, title, section "
			."FROM #__categories "			
			);
			$pi_categories_object = $database->loadObjectList();
			
			$pi_category_array = array();
			foreach($pi_categories_object as $category){
				$pi_category_array[] = array($category->id, $category->title, $category->section);
			}
		}
		return $pi_category_array;
	}
	
	function get_sections(){
		static $pi_sections_array;
		
		if(!$pi_sections_array){
			$database = JFactory::getDBO();
			$database->setQuery("SELECT id, title "
			."FROM #__sections "			
			);
			$pi_sections_object = $database->loadObjectList();
			
			$pi_sections_array = array();
			foreach($pi_sections_object as $pi_section){
				$pi_sections_array[] = array($pi_section->id, $pi_section->title);
			}
		}
		return $pi_sections_array;
	}
	
	function check_section_access($section_id, $usergroup){	
		$section_access_rights = $this->get_section_access_rights();	
		$section_right = $section_id.'__'.$usergroup;		
		if(in_array($section_right, $section_access_rights)){
			return true;
		}else{
			return false;
		}
	}	
	
	function get_section_access_rights(){
		static $section_access_rights;		
		if(!$section_access_rights){	
			$database = JFactory::getDBO();
			$database->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
			$section_access_rights = $database->loadResultArray();			
		}		
		return $section_access_rights;
	}	
	
	function check_category_access($category_id, $usergroup){	
		$category_access_rights = $this->get_category_access_rights();			
		$category_access = $category_id.'__'.$usergroup;				
		$access = false;
		if(in_array($category_access, $category_access_rights)){
			$access = true;
		}		
		return $access;
	}	
	
	function get_category_access_rights(){
		static $category_access_rights;		
		if(!$category_access_rights){	
			$database = JFactory::getDBO();
			$database->setQuery("SELECT category_groupid FROM #__pi_aua_categories");
			$category_access_rights = $database->loadResultArray();			
		}		
		return $category_access_rights;
	}
		
		
	function check_menu_access($pi_ua_config, $database, $aua_usergroup){
	
		//get vars					
		$option = JRequest::getVar('option', '');		
		$task = JRequest::getVar('task', '');	
		
		//start menus > menu-manager
		if($task=='' && $pi_ua_config['activate_menus']){
			
			//greyout all menutypes which have no access			
			$script = '<script language="JavaScript" type="text/javascript" src="modules/mod_admin_user_access_backend/jquery-1_3_2.js"></script>'."\n";				
			$script .= '<script>'."\n";		
			$script .= 'var AUA_jQuery = jQuery.noConflict();';
			$script .= 'AUA_jQuery(document).ready(function() {'."\n";
			
			//get menu access data
			$database->setQuery("SELECT menu_groupid FROM #__pi_aua_menus ");
			$menutype_access_rights = $database->loadResultArray();	
			
			//make menutype access array
			$menutype_access_array = array();
			for($n = 0; $n < count($menutype_access_rights); $n++){
				$menu_type_right = $menutype_access_rights[$n];
				$temp = explode('__', $menu_type_right);
				$temp_menu_type = $temp[0];
				$temp_groupid = $temp[1];
				if($temp_groupid==$aua_usergroup){
					$menutype_access_array[] = $temp_menu_type;
				}					
			}
			//print_r($menutype_access_array);			
			
			//make menutype access array in javascript
			$script .= 'var menutypes_with_access = [';						
			for($n = 0; $n < count($menutype_access_array); $n++){
				if($n!=0){
					$script .= ',';
				}
				$script .= '"'.$menutype_access_array[$n].'"';	
			}
			$script .= '];'."\n";	
			
			$script .= 'AUA_jQuery("table.adminlist tr input").each(function (i) {'."\n";			
				//loop input elements within tr's
				$script .= 'if(this.name == "id"){'."\n";
					//checkbox with id					
					$script .= 'menutype_id = this.value;'."\n";
					$script .= 'if(AUA_jQuery.inArray(menutype_id, menutypes_with_access)==-1){'."\n";
						//$script .= 'alert(menutype_id);'."\n";					
						$script .= 'AUA_jQuery(this).attr({disabled: "true"});'."\n";
						$script .= 'td_element = AUA_jQuery(this).parent();'."\n";
						$script .= 'tr_element = AUA_jQuery(td_element).parent();'."\n";				
						$script .= 'AUA_jQuery(tr_element).addClass("aua_disable_link");'."\n";					
					$script .= '}'."\n";				
				$script .= '}'."\n";		
			$script .= '});'."\n";
			
			//take links out and add no-access icon
			$script .= 'AUA_jQuery("table.adminlist .aua_disable_link a").each(function (i) {'."\n";
				$script .= 'href = this.href;'."\n";	
				$script .= 'pos = href.indexOf(\'index.php?option=com_menus\');'."\n";							
				$script .= 'if(pos!=\'-1\'){'."\n";				
					$script .= 'link_string = AUA_jQuery(this).html();'."\n";				
					$script .= 'no_access_img = \'<img src="components/com_pi_admin_user_access/images/no_access.gif" alt="no access" /> \';'."\n";
					$script .= 'AUA_jQuery(this).replaceWith(no_access_img+link_string);'."\n";
				$script .= '}'."\n";					
			$script .= '});'."\n";
			
			$script .= '});'."\n";
			$script .= '</script>'."\n";
			
			echo $script;					
		}
		//end menus > menu-manager		
		
		//start menu-item edit
		if($task=='edit'){
			//start rip menutypes out of select
			if($pi_ua_config['activate_menus']){
			
				//get menu access data
				$database->setQuery("SELECT menu_groupid FROM #__pi_aua_menus ");
				$menutype_access_rights = $database->loadResultArray();	
				
				//make menutype access array
				$menutype_access_array = array();
				for($n = 0; $n < count($menutype_access_rights); $n++){
					$menu_type_right = $menutype_access_rights[$n];
					$temp = explode('__', $menu_type_right);
					$temp_menu_type = $temp[0];
					$temp_groupid = $temp[1];
					if($temp_groupid==$aua_usergroup){
						$menutype_access_array[] = $temp_menu_type;
					}					
				}
				
				//get all menutypes
				$database->setQuery("SELECT id, menutype "
				." FROM #__menu_types "				
				);
				$rows = $database->loadObjectList();
				$all_menutypes = array();
				foreach($rows as $row){	
					$all_menutypes[] = array($row->id, $row->menutype);	
				}
				
				$script = '<script language="JavaScript" type="text/javascript" src="modules/mod_admin_user_access_backend/jquery-1_3_2.js"></script>'."\n";					
				$script .= '<script>'."\n";		
				$script .= 'var AUA_jQuery = jQuery.noConflict();';
				$script .= 'AUA_jQuery(document).ready(function() {'."\n";
				
				//rip options out where user has no access to		
				foreach($all_menutypes as $all_menutype){
					if(!in_array($all_menutype[0], $menutype_access_array)){						
						$script .= 'AUA_jQuery("select#menutype option[value=\''.$all_menutype[1].'\']").remove();'."\n";
					}
				}
				
				$script .= '});'."\n";
				$script .= '</script>'."\n";
				echo $script;				
			}
			//end rip menutypes out of select
		}
		//end menu-item edit
		
	}




}
		

			
	



?>