DROP TABLE IF EXISTS `#__properties_available_product`;
DROP TABLE IF EXISTS `#__properties_available_product`;
CREATE TABLE `#__properties_available_product` (
  `id` int(11) NOT NULL auto_increment,
  `id_product` int(11) NOT NULL,
  `date` date NOT NULL,
  `available` tinyint(4) NOT NULL,
  `published` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_bookings`;
CREATE TABLE `#__properties_bookings` (
  `ob_id_order` int(5) NOT NULL auto_increment,
  `ob_id_property` int(5) NOT NULL,
  `ob_name` varchar(255) NOT NULL,
  `ob_address` varchar(255) NOT NULL,
  `ob_postcode` varchar(255) NOT NULL,
  `ob_city` varchar(255) NOT NULL,
  `ob_state` varchar(255) NOT NULL,
  `ob_country` varchar(255) NOT NULL,
  `ob_phone` varchar(255) NOT NULL,
  `ob_text` text NOT NULL,
  `ob_mail` varchar(255) NOT NULL,
  `ob_created` datetime NOT NULL,
  `ob_from` date NOT NULL,
  `ob_to` date NOT NULL,
  `ob_price` int(5) NOT NULL,
  `ob_adults` tinyint(1) NOT NULL,
  `ob_boys` tinyint(1) NOT NULL,
  `ob_babies` tinyint(1) NOT NULL,
  `ob_deposit` date default NULL,
  `ob_deposit_amount` int(9) NOT NULL,
  `ob_confirmed` tinyint(4) NOT NULL,
  `ob_confirmed_date` date default NULL,
  `ob_confirmed_by` int(5) NOT NULL,
  `ob_send_mail` tinyint(1) NOT NULL,
  `ob_text_mail` text NOT NULL,
  `ob_language` varchar(255) NOT NULL,
  `ob_contract_name` varchar(255) NOT NULL,
  `ob_contract_send` date default NULL,
  PRIMARY KEY  (`ob_id_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_category`;
CREATE TABLE `#__properties_category` (
  `id` int(2) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `alias` varchar(100) default NULL,
  `parent` int(2) default NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(1) NOT NULL,
  `checked_out` tinyint(1) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `access` tinyint(3) NOT NULL,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL,
  `metakey` varchar(1024) NOT NULL,
  `layout` varchar(100) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT IGNORE INTO `#__properties_category` VALUES 
(1, 'For Sale', 'for-sale', NULL, 1, 1, 0, '0000-00-00 00:00:00', 0, '', '', '', ''),
(2, 'For Rent', 'for-rent', NULL, 1, 2, 0, '0000-00-00 00:00:00', 0, '', '', '', '');

DROP TABLE IF EXISTS `#__properties_comments`;
CREATE TABLE `#__properties_comments` (
  `id` int(10) NOT NULL auto_increment,
  `userid` int(10) NOT NULL default '0',
  `status` int(10) NOT NULL default '0',
  `productid` int(10) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `name` varchar(200) default NULL,
  `title` varchar(200) NOT NULL default '',
  `comment` text NOT NULL,
  `preview` text NOT NULL,
  `date` date NOT NULL default '0000-00-00',
  `published` tinyint(1) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `email` varchar(100) NOT NULL default '',
  `website` varchar(100) NOT NULL default '',
  `updateme` smallint(5) unsigned NOT NULL default '0',
  `custom1` varchar(200) NOT NULL default '',
  `custom2` varchar(200) NOT NULL default '',
  `custom3` varchar(200) NOT NULL default '',
  `custom4` varchar(200) NOT NULL default '',
  `custom5` varchar(200) NOT NULL default '',
  `star` decimal(3,2) NOT NULL default '5.00',
  `star1` tinyint(1) NOT NULL,
  `star2` tinyint(1) NOT NULL,
  `star3` tinyint(1) NOT NULL,
  `star4` tinyint(1) NOT NULL,
  `star5` tinyint(1) NOT NULL,
  `user_id` int(10) unsigned NOT NULL default '0',
  `option` varchar(50) NOT NULL default 'com_content',
  `voted` smallint(6) NOT NULL default '0',
  `referer` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_contacts`;
CREATE TABLE `#__properties_contacts` (
  `id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL,
  `user_id` int(5) NOT NULL,
  `date` datetime NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `cp` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `userfile` varchar(255) NOT NULL,
  `layout` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_country`;
CREATE TABLE `#__properties_country` (
  `id` int(3) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `mid` int(5) NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT IGNORE INTO `#__properties_country` VALUES 
(1, 'Italy', 'italy', 1, 0, 1, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__properties_images`;
CREATE TABLE `#__properties_images` (
  `id` int(5) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `parent` int(4) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(4) NOT NULL,
  `type` varchar(100) NOT NULL,
  `path` varchar(255) NOT NULL,
  `rout` varchar(255) NOT NULL,
  `date` datetime NOT NULL,
  `uid` int(5) NOT NULL,
  `product_id` int(5) NOT NULL,
  `sector` varchar(255) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=61 ;

INSERT IGNORE INTO `#__properties_images` VALUES 
(1, '1_1.jpg', 1, 1, 1, 'jpg', '', '', '2011-06-25 18:01:47', 62, 0, '', ''),
(2, '2_1.jpg', 1, 1, 2, 'jpg', '', '', '2011-06-25 18:01:47', 62, 0, '', ''),
(3, '3_1.jpg', 1, 1, 3, 'jpg', '', '', '2011-06-25 18:01:48', 62, 0, '', ''),
(4, '4_1.jpg', 1, 1, 4, 'jpg', '', '', '2011-06-25 18:01:49', 62, 0, '', ''),
(5, '5_1.jpg', 1, 1, 5, 'jpg', '', '', '2011-06-25 18:01:49', 62, 0, '', ''),
(6, '6_1.jpg', 1, 1, 6, 'jpg', '', '', '2011-06-25 18:01:50', 62, 0, '', ''),
(7, '7_2.jpg', 2, 1, 1, 'jpg', '', '', '2011-06-25 19:01:10', 62, 0, '', ''),
(8, '8_2.jpg', 2, 1, 2, 'jpg', '', '', '2011-06-25 19:01:11', 62, 0, '', ''),
(9, '9_2.jpg', 2, 1, 3, 'jpg', '', '', '2011-06-25 19:01:12', 62, 0, '', ''),
(10, '10_2.jpg', 2, 1, 4, 'jpg', '', '', '2011-06-25 19:01:12', 62, 0, '', ''),
(11, '11_2.jpg', 2, 1, 5, 'jpg', '', '', '2011-06-25 19:01:13', 62, 0, '', ''),
(12, '12_2.jpg', 2, 1, 6, 'jpg', '', '', '2011-06-25 19:01:13', 62, 0, '', ''),
(13, '13_3.jpg', 3, 1, 1, 'jpg', '', '', '2011-06-26 13:11:03', 62, 0, '', ''),
(14, '14_3.jpg', 3, 1, 2, 'jpg', '', '', '2011-06-26 13:11:04', 62, 0, '', ''),
(15, '15_3.jpg', 3, 1, 3, 'jpg', '', '', '2011-06-26 13:11:05', 62, 0, '', ''),
(16, '16_3.jpg', 3, 1, 4, 'jpg', '', '', '2011-06-26 13:11:07', 62, 0, '', ''),
(17, '17_3.jpg', 3, 1, 5, 'jpg', '', '', '2011-06-26 13:11:09', 62, 0, '', ''),
(18, '18_3.jpg', 3, 1, 6, 'jpg', '', '', '2011-06-26 13:11:10', 62, 0, '', ''),
(19, '19_3.jpg', 3, 1, 7, 'jpg', '', '', '2011-06-26 13:11:12', 62, 0, '', ''),
(20, '20_3.jpg', 3, 1, 8, 'jpg', '', '', '2011-06-26 13:11:13', 62, 0, '', ''),
(21, '21_3.jpg', 3, 1, 9, 'jpg', '', '', '2011-06-26 13:11:14', 62, 0, '', ''),
(22, '22_4.jpg', 4, 1, 1, 'jpg', '', '', '2011-06-26 13:25:31', 62, 0, '', ''),
(23, '23_4.jpg', 4, 1, 2, 'jpg', '', '', '2011-06-26 13:25:32', 62, 0, '', ''),
(24, '24_4.jpg', 4, 1, 3, 'jpg', '', '', '2011-06-26 13:25:32', 62, 0, '', ''),
(25, '25_4.jpg', 4, 1, 4, 'jpg', '', '', '2011-06-26 13:25:33', 62, 0, '', ''),
(26, '26_4.jpg', 4, 1, 5, 'jpg', '', '', '2011-06-26 13:25:34', 62, 0, '', ''),
(27, '27_4.jpg', 4, 1, 6, 'jpg', '', '', '2011-06-26 13:27:45', 62, 0, '', ''),
(28, '28_4.jpg', 4, 1, 7, 'jpg', '', '', '2011-06-26 13:27:46', 62, 0, '', ''),
(29, '29_4.jpg', 4, 1, 8, 'jpg', '', '', '2011-06-26 13:27:47', 62, 0, '', ''),
(30, '30_4.jpg', 4, 1, 9, 'jpg', '', '', '2011-06-26 13:27:48', 62, 0, '', ''),
(31, '31_4.jpg', 4, 1, 10, 'jpg', '', '', '2011-06-26 13:27:48', 62, 0, '', ''),
(32, '32_4.jpg', 4, 1, 11, 'jpg', '', '', '2011-06-26 13:27:49', 62, 0, '', ''),
(33, '33_5.jpg', 5, 1, 1, 'jpg', '', '', '2011-06-26 13:37:44', 62, 0, '', ''),
(34, '34_5.jpg', 5, 1, 2, 'jpg', '', '', '2011-06-26 13:37:55', 62, 0, '', ''),
(35, '35_5.jpg', 5, 1, 3, 'jpg', '', '', '2011-06-26 13:38:03', 62, 0, '', ''),
(36, '36_5.jpg', 5, 1, 4, 'jpg', '', '', '2011-06-26 13:38:09', 62, 0, '', ''),
(37, '37_5.jpg', 5, 1, 5, 'jpg', '', '', '2011-06-26 13:38:15', 62, 0, '', ''),
(38, '38_5.jpg', 5, 1, 6, 'jpg', '', '', '2011-06-26 13:38:20', 62, 0, '', ''),
(39, '39_5.jpg', 5, 1, 7, 'jpg', '', '', '2011-06-26 13:38:25', 62, 0, '', ''),
(40, '40_5.jpg', 5, 1, 8, 'jpg', '', '', '2011-06-26 13:38:29', 62, 0, '', ''),
(41, '41_5.jpg', 5, 1, 9, 'jpg', '', '', '2011-06-26 13:38:33', 62, 0, '', ''),
(42, '42_5.jpg', 5, 1, 10, 'jpg', '', '', '2011-06-26 13:38:37', 62, 0, '', ''),
(43, '43_5.jpg', 5, 1, 11, 'jpg', '', '', '2011-06-26 13:38:40', 62, 0, '', ''),
(44, '44_5.jpg', 5, 1, 12, 'jpg', '', '', '2011-06-26 13:38:44', 62, 0, '', ''),
(45, '45_6.jpg', 6, 1, 1, 'jpg', '', '', '2011-06-26 13:49:59', 62, 0, '', ''),
(46, '46_6.jpg', 6, 1, 2, 'jpg', '', '', '2011-06-26 13:50:01', 62, 0, '', ''),
(47, '47_6.jpg', 6, 1, 3, 'jpg', '', '', '2011-06-26 13:50:02', 62, 0, '', ''),
(48, '48_6.jpg', 6, 1, 4, 'jpg', '', '', '2011-06-26 13:50:04', 62, 0, '', ''),
(49, '49_6.jpg', 6, 1, 5, 'jpg', '', '', '2011-06-26 13:50:05', 62, 0, '', ''),
(50, '50_6.jpg', 6, 1, 6, 'jpg', '', '', '2011-06-26 13:50:07', 62, 0, '', ''),
(51, '51_6.jpg', 6, 1, 7, 'jpg', '', '', '2011-06-26 13:50:09', 62, 0, '', ''),
(52, '52_6.jpg', 6, 1, 8, 'jpg', '', '', '2011-06-26 13:50:10', 62, 0, '', ''),
(53, '53_6.jpg', 6, 1, 9, 'jpg', '', '', '2011-06-26 13:50:12', 62, 0, '', ''),
(54, '54_6.jpg', 6, 1, 10, 'jpg', '', '', '2011-06-26 13:50:32', 62, 0, '', ''),
(55, '55_6.jpg', 6, 1, 11, 'jpg', '', '', '2011-06-26 13:50:43', 62, 0, '', ''),
(56, '56_6.jpg', 6, 1, 12, 'jpg', '', '', '2011-06-26 13:50:52', 62, 0, '', ''),
(57, '57_6.jpg', 6, 1, 13, 'jpg', '', '', '2011-06-26 13:50:58', 62, 0, '', ''),
(58, '58_6.jpg', 6, 1, 14, 'jpg', '', '', '2011-06-26 13:51:04', 62, 0, '', ''),
(59, '59_6.jpg', 6, 1, 15, 'jpg', '', '', '2011-06-26 13:51:11', 62, 0, '', ''),
(60, '60_6.jpg', 6, 1, 16, 'jpg', '', '', '2011-06-26 13:51:15', 62, 0, '', '');

DROP TABLE IF EXISTS `#__properties_lightbox`;
CREATE TABLE `#__properties_lightbox` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `propid` int(11) NOT NULL default '0',
  `date` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_locality`;
CREATE TABLE `#__properties_locality` (
  `id` int(6) NOT NULL auto_increment,
  `parent` int(3) NOT NULL,
  `mid` int(6) NOT NULL,
  `zipcode` int(6) NOT NULL,
  `name` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

INSERT IGNORE INTO `#__properties_locality` VALUES 
(1, 1, 0, 0, 'San Benedetto del Tronto', 'san-benedetto-del-tronto', 1, 1, 0, '0000-00-00 00:00:00'),
(2, 2, 0, 0, 'Martinsicuro', 'martinsicuro', 1, 1, 0, '0000-00-00 00:00:00'),
(3, 2, 0, 0, 'Villa Rosa', 'villa-rosa', 1, 2, 0, '0000-00-00 00:00:00'),
(4, 2, 0, 0, 'Alba Adriatica', 'alba-adriatica', 1, 3, 0, '0000-00-00 00:00:00'),
(5, 2, 0, 0, 'Tortoreto Lido', 'tortoreto-lido', 1, 4, 0, '0000-00-00 00:00:00'),
(6, 2, 0, 0, 'Cologna Spiaggia', 'cologna-spiaggia', 1, 5, 0, '0000-00-00 00:00:00'),
(7, 1, 0, 0, 'Grottammare', 'grottammare', 1, 2, 0, '0000-00-00 00:00:00'),
(8, 1, 0, 0, 'Cupramarittima', 'cupramarittima', 1, 3, 0, '0000-00-00 00:00:00'),
(9, 1, 0, 0, 'Monteprandone', 'monteprandone', 1, 4, 0, '0000-00-00 00:00:00'),
(10, 1, 0, 0, 'Monsampolo del Tronto', 'monsampolo-del-tronto', 1, 5, 0, '0000-00-00 00:00:00'),
(11, 2, 0, 0, '	Giulianova', '-giulianova', 1, 6, 0, '0000-00-00 00:00:00'),
(12, 1, 0, 0, 'Spinetoli', 'spinetoli', 1, 7, 0, '0000-00-00 00:00:00'),
(13, 2, 0, 0, 'Colonnella', 'colonnella', 1, 6, 0, '0000-00-00 00:00:00'),
(14, 2, 0, 0, 'Controguerra', 'controguerra', 1, 7, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__properties_pdfs`;
CREATE TABLE `#__properties_pdfs` (
  `id` int(5) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `parent` int(3) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(5) NOT NULL,
  `text` text NOT NULL,
  `date` date NOT NULL,
  `archivo` varchar(255) NOT NULL,
  `archivo_path` varchar(255) NOT NULL,
  `archivo_rout` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__properties_products`;
CREATE TABLE `#__properties_products` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `parent` int(6) NOT NULL,
  `agent_id` int(6) NOT NULL,
  `agent` varchar(255) NOT NULL,
  `ref` varchar(50) NOT NULL,
  `type` int(6) NOT NULL,
  `cid` int(6) NOT NULL,
  `lid` int(6) NOT NULL,
  `sid` int(6) NOT NULL,
  `cyid` int(6) NOT NULL,
  `postcode` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `description` text NOT NULL,
  `text` text NOT NULL,
  `price` decimal(15,2) default NULL,
  `published` tinyint(1) NOT NULL,
  `use_booking` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `panoramic` varchar(255) default NULL,
  `video` text NOT NULL,
  `lat` float(10,6) NOT NULL,
  `lng` float(10,6) NOT NULL,
  `available` tinyint(1) NOT NULL,
  `featured` tinyint(4) NOT NULL,
  `years` int(4) NOT NULL,
  `capacity` int(2) NOT NULL,
  `bedrooms` tinyint(1) NOT NULL,
  `bathrooms` tinyint(1) NOT NULL,
  `garage` tinyint(1) NOT NULL,
  `area` int(5) NOT NULL,
  `covered_area` int(5) NOT NULL,
  `hits` int(6) NOT NULL,
  `listdate` date NOT NULL default '0000-00-00',
  `refresh_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `language` char(7) NOT NULL,
  `access` tinyint(3) NOT NULL,
  `params` text NOT NULL,
  `metatitle` varchar(255) NOT NULL,
  `metadesc` text NOT NULL,
  `metakey` text NOT NULL,
  `layout` varchar(100) NOT NULL,
  `extra1` tinyint(1) NOT NULL default '0',
  `extra2` tinyint(1) NOT NULL default '0',
  `extra3` tinyint(1) NOT NULL default '0',
  `extra4` tinyint(1) NOT NULL default '0',
  `extra5` tinyint(1) NOT NULL default '0',
  `extra6` tinyint(1) NOT NULL default '0',
  `extra7` tinyint(1) NOT NULL default '0',
  `extra8` tinyint(1) NOT NULL default '0',
  `extra9` tinyint(1) NOT NULL default '0',
  `extra10` tinyint(1) NOT NULL default '0',
  `extra11` tinyint(1) NOT NULL default '0',
  `extra12` tinyint(1) NOT NULL default '0',
  `extra13` tinyint(1) NOT NULL default '0',
  `extra14` tinyint(1) NOT NULL default '0',
  `extra15` tinyint(1) NOT NULL default '0',
  `extra16` tinyint(1) NOT NULL default '0',
  `extra17` tinyint(1) NOT NULL default '0',
  `extra18` tinyint(1) NOT NULL default '0',
  `extra19` tinyint(1) NOT NULL default '0',
  `extra20` tinyint(1) NOT NULL default '0',
  `extra21` tinyint(1) NOT NULL default '0',
  `extra22` tinyint(1) NOT NULL default '0',
  `extra23` tinyint(1) NOT NULL default '0',
  `extra24` tinyint(1) NOT NULL default '0',
  `extra25` tinyint(1) NOT NULL default '0',
  `extra26` tinyint(1) NOT NULL default '0',
  `extra27` tinyint(1) NOT NULL default '0',
  `extra28` tinyint(1) NOT NULL default '0',
  `extra29` tinyint(1) NOT NULL default '0',
  `extra30` tinyint(1) NOT NULL default '0',
  `extra31` tinyint(1) NOT NULL default '0',
  `extra32` tinyint(1) NOT NULL default '0',
  `extra33` tinyint(1) NOT NULL default '0',
  `extra34` tinyint(1) NOT NULL default '0',
  `extra35` tinyint(1) NOT NULL default '0',
  `extra36` tinyint(1) NOT NULL default '0',
  `extra37` tinyint(1) NOT NULL default '0',
  `extra38` tinyint(1) NOT NULL default '0',
  `extra39` tinyint(1) NOT NULL default '0',
  `extra40` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT IGNORE INTO `#__properties_products` VALUES 
(1, 'Villa Agostina internal Bilocale 3 persons', 'villa-agostina-internal-bilocale-3-persons', 0, 70, '', 'PAF167', 1, 2, 1, 1, 1, '63074', 'via Serao, 8', '<p>3 bed roomed apartment: living room with kitchenette and sofa bed, double bedroom,bathroom with shower and balcony. Ground floor with patio and separate entrance.Swimming pool, parking, outdoor shower, wi-fi. TV, washing machine. AirConditioning. Weekly beach an extra charge.</p>', '<p>3 bed roomed apartment: living room with kitchenette and sofa bed, double bedroom,bathroom with shower and balcony. Ground floor with patio and separate entrance.Swimming pool, parking, outdoor shower, wi-fi. TV, washing machine. AirConditioning. Weekly beach an extra charge.</p>', 0.00, 1, 1, 1, NULL, '', 42.949505, 13.878117, 0, 0, 5, 0, 2, 1, 1, 100, 90, 205, '2011-06-25', '2011-06-26 09:53:50', 0, '0000-00-00 00:00:00', '', 0, '', 'Villa Agostina internal Bilocale 3 persons', 'Villa Agostina internal Bilocale 3 persons, Apartment, For Rent, 63074, via Serao, 8, San Benedetto del Tronto', 'Villa Agostina internal Bilocale 3 persons, Apartment, For Rent, 63074, via Serao, 8, San Benedetto del Tronto', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0),
(2, 'Leopardi internal Bilocale 4 persons', 'leopardi-internal-bilocale-4-persons', 0, 70, '', 'NNT359', 1, 2, 4, 2, 1, '63011', 'via Leopardi, 19', '<p>New apartments in Alba Adriatica, 300 meters from the sea, centrally located.Furniture well-groomed and very comfortable. Private parking. Air Conditioning. TVand washing machine. Availability of Studios for 2 persons, three rooms for 5 / 6 persons and two rooms for 4 persons.</p>', '<p>New apartments in Alba Adriatica, 300 meters from the sea, centrally located.Furniture well-groomed and very comfortable. Private parking. Air Conditioning. TVand washing machine. Availability of Studios for 2 persons, three rooms for 5 / 6 persons and two rooms for 4 persons.</p>', 0.00, 1, 0, 2, NULL, '', 42.831833, 13.926037, 0, 0, 5, 0, 2, 1, 1, 90, 110, 22, '2011-06-25', '2011-06-26 10:06:51', 0, '0000-00-00 00:00:00', '', 0, '', 'Leopardi internal  Bilocale 4 persons', 'Leopardi internal Bilocale 4 persons, Apartment, For Rent, 63011, via Leopardi, 19, Alba Adriatica', 'Leopardi internal Bilocale 4 persons, Apartment, For Rent, 63011, via Leopardi, 19, Alba Adriatica', '', 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0),
(3, 'Pierrot internal Bilocale 4 persons', 'pierrot-internal-bilocale-4-persons', 0, 70, '', 'HFB192', 1, 2, 1, 1, 1, '63074', 'via Cimarosa, 2/d', '<p>Located directly on the promenade of San Benedetto del Tronto, in front of the popular and new pedestrian. Two rooms available 4 beds: living room with kitchenette, sofa bed, double bedroom and bathroom with shower, terrace with direct access to the pool area. TV, washing machine. Parking lot. Swimming pool. Air Conditioning (a supplement of  50/week if required)</p>', '<p>Located directly on the promenade of San Benedetto del Tronto, in front of the popular and new pedestrian. Two rooms available 4 beds: living room with kitchenette, sofa bed, double bedroom and bathroom with shower, terrace with direct access to the pool area. TV, washing machine. Parking lot. Swimming pool. Air Conditioning (a supplement of  50/week if required)</p>', 0.00, 1, 0, 3, NULL, '', 42.919960, 13.901780, 0, 0, 2, 0, 2, 1, 1, 120, 95, 6, '2011-06-26', '2011-06-26 10:15:07', 0, '0000-00-00 00:00:00', '', 0, '', 'Pierrot internal Bilocale 4 persons', 'Pierrot internal Bilocale 4 persons, Apartment, For Rent, 63074, via Cimarosa, 2/d, San Benedetto del Tronto', 'Pierrot internal Bilocale 4 persons, Apartment, For Rent, 63074, via Cimarosa, 2/d, San Benedetto del Tronto', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0),
(4, 'Alessia internal Trilocale 6 persons', 'alessia-internal-trilocale-6-persons', 0, 70, '', 'VMT175', 1, 2, 4, 2, 1, '64018', 'Lungomare Marconi, 388', '<p>Alessia''s apartments are located in the waterfront area south of Alba Adriatica. Right on the pedestrian and bike path, facing the sea. The property consists of 7 three rooms: bedroom, twin bedroom, living room with sofa bed, kitchenette, bathroom andbalcony. Availability of apartments with a wonderful sea view. All Tv with shared laundry room.</p>', '<p>Alessia''s apartments are located in the waterfront area south of Alba Adriatica. Right on the pedestrian and bike path, facing the sea. The property consists of 7 three rooms: bedroom, twin bedroom, living room with sofa bed, kitchenette, bathroom andbalcony. Availability of apartments with a wonderful sea view. All Tv with shared laundry room.</p>', 0.00, 1, 0, 4, NULL, '', 42.816055, 13.937780, 0, 0, 0, 0, 2, 1, 1, 120, 100, 3, '2011-06-26', '2011-06-26 10:25:36', 0, '0000-00-00 00:00:00', '', 0, '', 'Alessia internal Trilocale 6 persons', 'Alessia internal Trilocale 6 persons, Apartment, For Rent, 64018, Lungomare Marconi, 388, Alba Adriatica', 'Alessia internal Trilocale 6 persons, Apartment, For Rent, 64018, Lungomare Marconi, 388, Alba Adriatica', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(5, 'Alighieri internal Trilocale 6 persons', 'alighieri-internal-trilocale-6-persons', 0, 70, '', 'TYA397', 1, 2, 2, 2, 1, '64014', 'via Alighieri, 2', '<p>consists of seven one and two bedroom apartments. The elegant building with luxury amenities is located in the central area of Martinsicuro to 200meters from the sea. All apartments are equipped with satellite TV, washing machine.Lift and parking. The three-room apartments have two bathrooms, one in the room.</p>', '<p>consists of seven one and two bedroom apartments. The elegant building with luxury amenities is located in the central area of Martinsicuro to 200meters from the sea. All apartments are equipped with satellite TV, washing machine.Lift and parking. The three-room apartments have two bathrooms, one in the room.</p>', 0.00, 1, 0, 5, NULL, '', 42.883274, 13.914990, 0, 0, 5, 0, 2, 1, 1, 120, 100, 5, '2011-06-26', '2011-06-26 10:40:36', 0, '0000-00-00 00:00:00', '', 0, '', 'Alighieri internal Trilocale 6 persons', 'Alighieri internal Trilocale 6 persons, Apartment, For Rent, 64014, via Alighieri, 2, Martinsicuro', 'Alighieri internal Trilocale 6 persons, Apartment, For Rent, 64014, via Alighieri, 2, Martinsicuro', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(6, 'Bambinopoli internal Bilocale 4 persons', 'bambinopoli-internal-bilocale-4-persons', 0, 70, '', 'VTM862', 1, 2, 4, 2, 1, '64011', 'via Marconi, 14', '<p>Sea facing apartments, directly on the pedestrian island, in central position. Availability of two rooms (3 or 4 beds) as follows: Living room with kitchen corner and double sofa bed, double room, bathroom with shower and large balcony. TV and parking. Communal washing machine</p>', '<p>Sea facing apartments, directly on the pedestrian island, in central position. Availability of two rooms (3 or 4 beds) as follows: Living room with kitchen corner and double sofa bed, double room, bathroom with shower and large balcony. TV and parking. Communal washing machine</p>', 0.00, 1, 0, 6, NULL, '', 42.836338, 13.931802, 0, 0, 5, 0, 2, 1, 1, 100, 90, 5, '2011-06-26', '2011-06-26 10:47:10', 0, '0000-00-00 00:00:00', '', 0, '', 'Bambinopoli internal Bilocale 4 persons', 'Bambinopoli internal Bilocale 4 persons, Apartment, For Rent, 64011, via Marconi, 14, Alba Adriatica', 'Bambinopoli internal Bilocale 4 persons, Apartment, For Rent, 64011, via Marconi, 14, Alba Adriatica', '', 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

DROP TABLE IF EXISTS `#__properties_products_translations`;
CREATE TABLE `#__properties_products_translations` (
  `pt_id` int(11) NOT NULL auto_increment,
  `pt_pid` int(11) NOT NULL,
  `pt_langid` int(2) NOT NULL,
  `pt_langcode` varchar(5) NOT NULL,
  `pt_name` varchar(255) NOT NULL,
  `pt_alias` varchar(255) NOT NULL,
  `pt_address` varchar(255) default NULL,
  `pt_description` text NOT NULL,
  `pt_text` text NOT NULL,
  `pt_currency` varchar(20) default NULL,
  `pt_published` tinyint(1) NOT NULL,
  `pt_metatitle` varchar(1024) NOT NULL,
  `pt_metadesc` varchar(1024) NOT NULL,
  `pt_metakey` varchar(1024) NOT NULL,
  PRIMARY KEY  (`pt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

INSERT IGNORE INTO `#__properties_products_translations` VALUES 
(1, 1, 0, 'es-ES', 'Villa Agostina departamento interno para 3 personas', 'villa-agostina-departamento-interno-para-3-personas', '', '<p>De nueva construccin, rodeado de un tiro de piedra del mar en una zona tranquila, con piscina y parking. Todos los apartamentos constan de: sala de estar con cocina americana y sof-cama doble, habitacin doble, bao con ducha y balcn, son modernas y estn decoradas con buen gusto. Planta baja con patio y autonomo.Piscina entrada, estacionamiento, acceso fcil para las personas con discapacidad, ducha exterior, puntos de Internet.</p>', '<p>De nueva construccin, rodeado de un tiro de piedra del mar en una zona tranquila, con piscina y parking. Todos los apartamentos constan de: sala de estar con cocina americana y sof-cama doble, habitacin doble, bao con ducha y balcn, son modernas y estn decoradas con buen gusto. Planta baja con patio y autonomo.Piscina entrada, estacionamiento, acceso fcil para las personas con discapacidad, ducha exterior, puntos de Internet.</p>', NULL, 0, 'Villa Agostina departamento interno para 3 personas', 'Villa Agostina departamento interno para 3 personas en alquiler en 63074, via Serao, 8, San Benedetto del Tronto ', 'Villa Agostina departamento interno para 3 personas, Departamento, en alquiler, 63074, via Serao, 8, San Benedetto del Tronto '),
(2, 2, 0, 'es-ES', 'Leopardi departamento interno para 4 personas', 'leopardi-departamento-interno-para-4-personas', '', '<p>Nuevos apartamentos en Alba Adriatica a 300 m del mar, situado en el centro. Muebles meticulosa atencin al detalle y muy cmodas. Aparcamiento privado. Aire Acondicionado. TV y lavadora. Disponibilidad de estudios para 2 personas, tres habitaciones para 5 / 6 personas y apartamentos de una habitacin para 4 personas.</p>', '<p>Nuevos apartamentos en Alba Adriatica a 300 m del mar, situado en el centro. Muebles meticulosa atencin al detalle y muy cmodas. Aparcamiento privado. Aire Acondicionado. TV y lavadora. Disponibilidad de estudios para 2 personas, tres habitaciones para 5 / 6 personas y apartamentos de una habitacin para 4 personas.</p>', NULL, 0, 'Leopardi departamento interno para 4 personas', 'Leopardi departamento interno para 4 personas en alquiler en 63011, via Leopardi, 19, Alba Adriatica', 'Leopardi departamento interno para 4 personas, Departamento, en alquiler, 63011, via Leopardi, 19, Alba Adriatica'),
(3, 1, 0, 'it-IT', 'Villa Agostina Appartamento interno Bilocale 3 posti letto', 'villa-agostina-appartamento-interno-bilocale-3-posti-letto', '', '<p>Recente  costruzione, immersa nel verde a due passi dal mare in posizione  tranquilla, con piscina e posti auto. Tutti gli appartamenti, composti  da: soggiorno con angolo cottura e divano letto matrimoniale, camera da  letto matrimoniale, bagno con box doccia e balcone, sono modernamente e  finemente arredati. Piani terra con patio e ingresso autonomo.Piscina,  posto auto, accesso semplificato per le persone portatrici di handicap,  doccia esterna, internet point.</p>', '<p>Recente  costruzione, immersa nel verde a due passi dal mare in posizione  tranquilla, con piscina e posti auto. Tutti gli appartamenti, composti  da: soggiorno con angolo cottura e divano letto matrimoniale, camera da  letto matrimoniale, bagno con box doccia e balcone, sono modernamente e  finemente arredati. Piani terra con patio e ingresso autonomo.Piscina,  posto auto, accesso semplificato per le persone portatrici di handicap,  doccia esterna, internet point.</p>', NULL, 0, 'Villa Agostina Appartamento interno Bilocale 3 posti letto', 'Villa Agostina Appartamento interno 4 posti letto en alquiler en 63074, via Serao, 8, San Benedetto del Tronto', 'Villa Agostina Appartamento interno 4 posti letto, Appartamento, en alquiler, 63074, via Serao, 8 San Benedetto del Tronto'),
(4, 2, 0, 'it-IT', 'Leopardi Appartamento interno 4 posti letto', 'leopardi-appartamento-interno-4-posti-letto', '', '<p>Nuovissimi appartamenti ad Alba Adriatica a 300 m dal mare, in posizione  centrale. Arredamento curato nei minimi particolari e molto  confortevole. Parcheggio privato. Aria Condizionata. TV e lavatrice.  Disponibilit di Monolocali per 2 persone, Trilocali per 5/6 persone e  Bilocali per 4 persone.</p>', '<p>Nuovissimi appartamenti ad Alba Adriatica a 300 m dal mare, in posizione  centrale. Arredamento curato nei minimi particolari e molto  confortevole. Parcheggio privato. Aria Condizionata. TV e lavatrice.  Disponibilit di Monolocali per 2 persone, Trilocali per 5/6 persone e  Bilocali per 4 persone.</p>', NULL, 0, 'Leopardi Appartamento interno 4 posti letto', 'Leopardi Appartamento interno 4 posti letto en alquiler en 63011, via Leopardi, 19, Alba Adriatica', 'Leopardi Appartamento interno 4 posti letto, Appartamento, en alquiler, 63011, via Leopardi, 19, Alba Adriatica'),
(6, 3, 0, 'es-ES', 'Pierrot Departamento interno 4 personas', 'pierrot-departamento-interno-4-personas', '', '<p>Situado en el paseo martimo de San Benedetto del Tronto, frente a la calle ms popular y lo nuevo. Dos de las habitaciones dispone de 4 camas: sala de estar con cocina americana, sof cama, habitacin doble y bao con ducha, terraza con acceso directo a la zona de la piscina. TV, lavadora. Playa de estacionamiento. Piscina. Aire Acondicionado (un suplemento de  50/semana si es necesario)</p>', '<p>Situado en el paseo martimo de San Benedetto del Tronto, frente a la calle ms popular y lo nuevo. Dos de las habitaciones dispone de 4 camas: sala de estar con cocina americana, sof cama, habitacin doble y bao con ducha, terraza con acceso directo a la zona de la piscina. TV, lavadora. Playa de estacionamiento. Piscina. Aire Acondicionado (un suplemento de  50/semana si es necesario)</p>', NULL, 0, 'Pierrot Departamento interno 4 personas', 'Pierrot Departamento interno 4 personas en alquiler en 63074, via Cimarosa, 2/d, San Benedetto del Tronto ', 'Pierrot ,Departamento interno 4 personas, Departamento, alquiler, 63074, via Cimarosa, San Benedetto del Tronto '),
(7, 4, 0, 'es-ES', 'Alessia Departamento interno 6 personas', 'alessia-departamento-interno-6-personas', '', '<p>Alessia apartamentos estn situados en la zona costera al sur de Alba Adriatica. A la derecha en el camino peatonal y en bicicleta, frente al mar. La propiedad consta de tres habitaciones 7: dormitorio, dormitorio doble, saln con sof cama, cocina, cuarto de bao andbalcony. Disponibilidad de apartamentos con vistas al mar. Todos los TV con lavadero compartido.</p>', '<p>Alessia apartamentos estn situados en la zona costera al sur de Alba Adriatica. A la derecha en el camino peatonal y en bicicleta, frente al mar. La propiedad consta de tres habitaciones 7: dormitorio, dormitorio doble, saln con sof cama, cocina, cuarto de bao andbalcony. Disponibilidad de apartamentos con vistas al mar. Todos los TV con lavadero compartido.</p>', NULL, 0, 'Alessia Departamento interno 6 personas', 'Alessia Departamento interno 4 personas en alquiler en 64018, Lungomare Marconi, 388, Alba Adriatica ', 'Alessia, Departamento interno 4 personas,Departamento , alquiler, 64018, Lungomare Marconi, 388, Alba Adriatica '),
(8, 4, 0, 'it-IT', 'Alessia Appartamento interno Bilocale 6 posti letto', 'alessia-appartamento-interno-bilocale-6-posti-letto', '', '<p>Alessia appartamenti sono situati nella zona lungomare sud di Alba Adriatica. Destro del mouse sul percorso pedonale e in bicicletta, di fronte al mare. L''immobile  composto da 7 tre stanze: camera da letto, camera doppia, soggiorno con divano letto, angolo cottura, bagno andbalcony. Disponibilit di appartamenti con vista mare. Tutte le Tv con lavanderia in comune.</p>', '<p>Alessia appartamenti sono situati nella zona lungomare sud di Alba Adriatica. Destro del mouse sul percorso pedonale e in bicicletta, di fronte al mare. L''immobile  composto da 7 tre stanze: camera da letto, camera doppia, soggiorno con divano letto, angolo cottura, bagno andbalcony. Disponibilit di appartamenti con vista mare. Tutte le Tv con lavanderia in comune.</p>', NULL, 0, 'Alessia Appartamento interno Bilocale 6 posti letto', 'Alessia Appartamento interno Bilocale 6 posti letto en 64018, Lungomare Marconi, 388, Alba Adriatica ', 'Alessia Appartamento interno Bilocale 6 posti letto en 64018, Lungomare Marconi, 388, Alba Adriatica '),
(9, 5, 0, 'es-ES', 'Alighieri Departamento interno 6 personas', 'alighieri-departamento-interno-6-personas', '', '<p>consta de siete uno y dos dormitorios. El elegante edificio con las comodidades de lujo est situado en la zona central de Martinsicuro a 200meters desde el mar. Todos los apartamentos estn equipados con televisin va satlite, lavado machine.Lift y aparcamiento. Los apartamentos de tres habitaciones con dos baos, uno en la habitacin.</p>', '<p>consta de siete uno y dos dormitorios. El elegante edificio con las comodidades de lujo est situado en la zona central de Martinsicuro a 200meters desde el mar. Todos los apartamentos estn equipados con televisin va satlite, lavado machine.Lift y aparcamiento. Los apartamentos de tres habitaciones con dos baos, uno en la habitacin.</p>', NULL, 0, 'Alighieri Departamento interno 6 personas', 'Alighieri Departamento interno 6 personas en alquiler en 64014, via Alighieri, 2, Martinsicuro ', 'Alighieri, Departamento, interno 6 personas , alquiler , 64014, via Alighieri, 2, Martinsicuro '),
(10, 5, 0, 'it-IT', 'Alighieri Appartamento interno Trilocale 6 posti letto', 'alighieri-appartamento-interno-trilocale-6-posti-letto', '', '<p> composto da sette con una o due camere da letto. L''edificio elegante con finiture di lusso si trova nella zona centrale di Martinsicuro a 200 metri dal mare. Tutti gli appartamenti sono dotati di TV satellitare, lavatrice machine.Lift e parcheggio. I trilocali hanno due bagni, uno in camera.</p>', '<p> composto da sette con una o due camere da letto. L''edificio elegante con finiture di lusso si trova nella zona centrale di Martinsicuro a 200 metri dal mare. Tutti gli appartamenti sono dotati di TV satellitare, lavatrice machine.Lift e parcheggio. I trilocali hanno due bagni, uno in camera.</p>', NULL, 0, 'Alighieri Appartamento interno Trilocale 6 posti letto', 'Alighieri Appartamento interno Trilocale 6 posti letto affiti in 64014, via Alighieri, 2, Martinsicuro ', 'Alighieri Appartamento interno Trilocale 6 posti letto affiti in 64014, via Alighieri, 2, Martinsicuro '),
(11, 6, 0, 'es-ES', 'Bambinopoli Departamento interno 4 personas', 'bambinopoli-departamento-interno-4-personas', '', '<p>Apartamentos vistas al mar, directamente en la isla de peatones, en la posicin central. Disponibilidad de dos habitaciones (3 o 4 camas), de la siguiente manera: Sala de estar con cocina americana y sof-cama doble, habitacin doble, bao con ducha y un gran balcn. TV y parking. Machineone lavado comunal en la sala.</p>', '<p>Apartamentos vistas al mar, directamente en la isla de peatones, en la posicin central. Disponibilidad de dos habitaciones (3 o 4 camas), de la siguiente manera: Sala de estar con cocina americana y sof-cama doble, habitacin doble, bao con ducha y un gran balcn. TV y parking. Machineone lavado comunal en la sala.</p>', NULL, 0, 'Bambinopoli Departamento interno 4 personas', 'Bambinopoli Departamento interno 4 personas en 64011, via Marconi, 14, Alba Adriatica ', 'Bambinopoli Departamento interno 4 personas en 64011, via Marconi, 14, Alba Adriatica '),
(12, 6, 0, 'it-IT', 'Bambinopoli internal Bilocale 4 persons', 'bambinopoli-internal-bilocale-4-persons', '', '<p>Appartamenti fronte mare, direttamente sull''isola pedonale, in posizione centrale. Disponibilit di due camere (3 o 4 letti) come segue: Soggiorno con angolo cottura e divano letto matrimoniale, camera matrimoniale, bagno con doccia e ampio balcone. TV e parcheggio. Lavaggio machineone comunale nella stanza.</p>', '<p>Appartamenti fronte mare, direttamente sull''isola pedonale, in posizione centrale. Disponibilit di due camere (3 o 4 letti) come segue: Soggiorno con angolo cottura e divano letto matrimoniale, camera matrimoniale, bagno con doccia e ampio balcone. TV e parcheggio. Lavaggio machineone comunale nella stanza.</p>', NULL, 0, 'Bambinopoli internal Bilocale 4 persons', 'Bambinopoli internal Bilocale 4 persons in affitti in 64011, via Marconi, 14, Alba Adriatica ', 'Bambinopoli internal Bilocale 4 persons in affitti in 64011, via Marconi, 14, Alba Adriatica '),
(5, 3, 0, 'it-IT', 'Pierrot Appartamento interno Bilocale 4 posti letto', 'pierrot-appartamento-interno-bilocale-4-posti-letto', '', '<p>Situati direttamente sul  lungomare di San Benedetto del Tronto, davanti  alla frequentata e nuova isola pedonale. Disponibilit di Bilocali 4  posti letto: soggiorno con angolo cottura, divano letto matrimoniale,  camera da letto matrimoniale e bagno con cabina doccia, terrazzo con  ingresso diretto alla zona piscina. Tv, lavatrice. Posto auto. Piscina.  Aria Condizionata (a supplemento se richiesta di euro 50/settimana)</p>', '<p>Situati direttamente sul  lungomare di San Benedetto del Tronto, davanti  alla frequentata e nuova isola pedonale. Disponibilit di Bilocali 4  posti letto: soggiorno con angolo cottura, divano letto matrimoniale,  camera da letto matrimoniale e bagno con cabina doccia, terrazzo con  ingresso diretto alla zona piscina. Tv, lavatrice. Posto auto. Piscina.  Aria Condizionata (a supplemento se richiesta di euro 50/settimana)</p>', NULL, 0, 'Pierrot Appartamento interno Bilocale 4 posti letto', 'Pierrot Appartamento interno 4 posti letto en alquiler en 63074 via Cimarosa, 2/d San Benedetto del Tronto ', 'Pierrot Appartamento interno 4 posti letto, alquiler,63074, via Cimarosa,San Benedetto del Tronto ');

DROP TABLE IF EXISTS `#__properties_product_category`;
CREATE TABLE `#__properties_product_category` (
  `productid` int(11) NOT NULL default '0',
  `categoryid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`productid`,`categoryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `#__properties_product_category` VALUES 
(1, 2),
(2, 2),
(3, 2),
(4, 2),
(5, 2),
(6, 2);

DROP TABLE IF EXISTS `#__properties_profiles`;
CREATE TABLE `#__properties_profiles` (
  `id` int(6) NOT NULL auto_increment,
  `mid` int(6) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `alias` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL default '',
  `type` int(1) NOT NULL default '0',
  `info` varchar(255) NOT NULL default '',
  `bio` mediumtext NOT NULL,
  `properties` int(3) NOT NULL default '0',
  `address1` varchar(50) NOT NULL default '',
  `address2` varchar(50) NOT NULL default '',
  `locality` varchar(50) NOT NULL default '',
  `pcode` varchar(10) NOT NULL default '',
  `state` varchar(50) NOT NULL default '',
  `country` varchar(50) NOT NULL default '',
  `show` tinyint(1) NOT NULL default '0',
  `email` varchar(50) NOT NULL default '',
  `phone` varchar(20) NOT NULL default '',
  `fax` varchar(20) NOT NULL default '',
  `mobile` varchar(20) NOT NULL default '',
  `skype` varchar(30) NOT NULL default '',
  `ymsgr` varchar(30) NOT NULL default '',
  `icq` varchar(30) NOT NULL default '',
  `web` varchar(255) NOT NULL default '',
  `blog` varchar(255) NOT NULL default '',
  `image` varchar(70) NOT NULL default '',
  `logo_image` varchar(70) NOT NULL default '',
  `logo_image_large` varchar(70) NOT NULL default '',
  `published` tinyint(1) NOT NULL default '0',
  `ordering` int(3) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `language` char(7) NOT NULL,
  `canaddproperties` int(3) NOT NULL,
  `canaddimages` int(2) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `mid` (`mid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT IGNORE INTO `#__properties_profiles` VALUES 
(1, 63, 'Patti Junger', 'patti-junger', '', 0, '', '', 0, '3650 Habersham Rd', '', 'Atlanta', '30305', 'GA', 'United States', 0, 'pjunger@mysite.com', '(404) 504-0801', '(404) 262-1658', '404-849-1183', '', '', '', '', '', '1_p.jpg', '1_l.gif', '', 1, 1, 0, '0000-00-00 00:00:00', '*', 5, 5),
(2, 64, 'B DIANE ARNOLD', 'b-diane-arnold', '', 0, '', '', 0, '79 West Paces Ferry Rd. NW', '', 'Atlanta', '30305', 'GA', 'United States', 0, 'CustomerService@mysite.com', '404-352-2010', '404-352-8063', '', '', '', '', '', '', '2_p.jpg', '', '', 1, 2, 0, '0000-00-00 00:00:00', '*', 5, 5),
(3, 65, 'DEBRA JOHNSTON', 'debra-johnston', '', 0, '', '', 0, '3290 Northside Parkway, NW', '', 'Atlanta', '30327', 'GA', 'United States', 0, 'DEBRA@mysite.com', '(404) 237-5000', '(404) 924-6807', '(404) 312-1959', '', '', '', '', '', '3_p.jpg', '', '', 1, 3, 0, '0000-00-00 00:00:00', '*', 5, 5),
(4, 66, 'Harry Norman,Buckhead', 'harry-normanbuckhead', '', 0, '', '', 0, '', '', 'Atlanta', '', '', '', 0, 'fafa@mysite.com', 'Office: (404) 233-41', '', '', '', '', '', '', '', '4_p.jpg', '4_l.gif', '', 1, 4, 0, '0000-00-00 00:00:00', '*', 5, 5),
(5, 67, 'TROY STOWE', 'troy-stowe', '', 0, '', '', 0, '3284 Northside Parkway', '', 'Atlanta', '30327', 'GA', 'United States', 0, 'troystowe@mysite.net', '(404) 890-7635', '(404) 261-6300', '(770) 314-7251', '', '', '', '', '', '5_p.jpg', '5_l.gif', '', 1, 5, 0, '0000-00-00 00:00:00', '*', 2, 5),
(6, 68, 'Luxe Estates Collection', 'luxe-estates-collection', '', 0, '', '', 0, '810 S. Durango Drive', '', 'Las Vegas', '89145', 'NV', 'United States', 0, 'team@mysite.com', '(702) 684-6100', '(702) 494-8270', '(702) 400-0645', '', '', '', '', '', '6_p.jpg', '6_l.jpg', '6_ll.jpg', 1, 6, 0, '0000-00-00 00:00:00', '*', 5, 5),
(7, 69, 'Jonathan Taylor', 'jonathan-taylor', '', 0, '', '', 0, '1206 30th St NW', '', 'Washington', '20007', 'DC', 'United States', 0, 'jonathan@mysite.com', '(202) 333-1212', '(202) 333-9396', '(202) 276-3344', '', '', '', '', '', '7_p.jpg', '7_l.gif', '', 1, 7, 0, '0000-00-00 00:00:00', '*', 5, 5),
(8, 70, 'Arnold Swatz', 'arnold-swatz', 'Agenzia Turistica Immobiliare', 0, '', '', 0, '1206 30th St NW', '', 'Atlanta', '63039', 'GA', 'United States', 0, 'agencia@agencia.com', '00 39 0735-75.33.23', '00 39 0735-44.61.19', '(202) 276-3344', '', '', '', '', '', '8_p.jpg', '', '', 1, 8, 42, '2011-04-18 19:06:01', '*', 20, 5);

DROP TABLE IF EXISTS `#__properties_rates`;
CREATE TABLE `#__properties_rates` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `description` text,
  `validfrom` date default NULL,
  `validto` date default NULL,
  `rateperday` double default '0',
  `rateperweek` double NOT NULL,
  `weekonly` tinyint(2) NOT NULL default '0',
  `productid` int(11) default NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(6) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=37 ;

INSERT IGNORE INTO `#__properties_rates` VALUES 
(1, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 1, 1, 1),
(2, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 1, 1, 2),
(3, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 1, 1, 3),
(4, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 1, 1, 4),
(5, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 1, 1, 5),
(6, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 1, 1, 6),
(7, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 2, 1, 1),
(8, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 2, 1, 2),
(9, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 2, 1, 3),
(10, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 2, 1, 4),
(11, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 2, 1, 5),
(12, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 2, 1, 6),
(13, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 3, 1, 1),
(14, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 3, 1, 2),
(15, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 3, 1, 3),
(16, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 3, 1, 4),
(17, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 3, 1, 5),
(18, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 3, 1, 6),
(19, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 4, 1, 1),
(20, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 4, 1, 2),
(21, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 4, 1, 3),
(22, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 4, 1, 4),
(23, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 4, 1, 5),
(24, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 4, 1, 6),
(25, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 5, 1, 1),
(26, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 5, 1, 2),
(27, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 5, 1, 3),
(28, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 5, 1, 4),
(29, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 5, 1, 5),
(30, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 5, 1, 6),
(31, '25-06-2011', NULL, '2011-06-25', '2011-07-31', 100, 0, 0, 6, 1, 1),
(32, '01-08-2011', NULL, '2011-08-01', '2011-08-31', 150, 0, 0, 6, 1, 2),
(33, '01-09-2011', NULL, '2011-09-01', '2011-09-30', 200, 0, 0, 6, 1, 3),
(34, '01-10-2011', NULL, '2011-10-01', '2011-10-31', 250, 0, 0, 6, 1, 4),
(35, '01-11-2011', NULL, '2011-11-01', '2011-11-30', 300, 0, 0, 6, 1, 5),
(36, '01-12-2011', NULL, '2011-12-01', '2011-12-31', 350, 0, 0, 6, 1, 6);

DROP TABLE IF EXISTS `#__properties_rating`;
CREATE TABLE `#__properties_rating` (
  `product_id` int(11) NOT NULL,
  `rating_sum` int(11) NOT NULL,
  `rating_count` int(11) NOT NULL,
  `lastip` varchar(50) NOT NULL,
  PRIMARY KEY  (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__properties_rating_user`;
CREATE TABLE `#__properties_rating_user` (
  `product_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `rating` tinyint(1) NOT NULL,
  `lastip` varchar(50) NOT NULL,
  PRIMARY KEY  (`product_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__properties_state`;
CREATE TABLE `#__properties_state` (
  `id` int(3) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `parent` int(5) NOT NULL,
  `mid` int(5) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT IGNORE INTO `#__properties_state` VALUES 
(1, 'Marche', 'marche', 1, 0, 1, 1, 0, '0000-00-00 00:00:00'),
(2, 'Abruzzo', 'abruzzo', 1, 0, 1, 2, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__properties_translations`;
CREATE TABLE `#__properties_translations` (
  `t_id` int(5) NOT NULL auto_increment,
  `t_languageid` int(2) NOT NULL,
  `t_languagecode` varchar(5) NOT NULL,
  `t_table` varchar(100) NOT NULL,
  `t_field` varchar(100) NOT NULL,
  `t_fieldid` int(5) NOT NULL,
  `t_value` varchar(100) NOT NULL,
  `t_alias` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY  (`t_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT IGNORE INTO `#__properties_translations` VALUES 
(1, 0, 'es-ES', 'category', 'For Sale', 1, 'En Venta', 'en-venta', 1),
(2, 0, 'es-ES', 'category', 'For Rent', 2, 'Alquiler', 'alquiler', 1),
(3, 0, 'it-IT', 'category', 'For Sale', 1, 'Vendite', 'vendite', 1),
(4, 0, 'it-IT', 'category', 'For Rent', 2, 'Affitti', 'affitti', 1),
(5, 0, 'it-IT', 'type', 'Apartment', 1, 'Appartamento', 'appartamento', 1),
(6, 0, 'it-IT', 'type', 'House', 2, 'Casa', 'casa', 1),
(7, 0, 'es-ES', 'type', 'Apartment', 1, 'Departamento', 'departamento', 1),
(8, 0, 'es-ES', 'type', 'House', 2, 'Casa', 'casa', 1);

DROP TABLE IF EXISTS `#__properties_type`;
CREATE TABLE `#__properties_type` (
  `id` int(2) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `alias` varchar(100) default NULL,
  `parent` int(2) default NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(1) NOT NULL,
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT IGNORE INTO `#__properties_type` VALUES 
(1, 'Apartment', 'apartment', 0, 1, 1, 0, '0000-00-00 00:00:00'),
(2, 'House', 'house', 0, 1, 2, 0, '0000-00-00 00:00:00');

INSERT IGNORE INTO `#__users` VALUES 
(63, 'agent1', 'agent1', 'agent1@agents.com', '17aed3937f0142ccae6480377ff0104a:v0DL5ej8Wqd08kNeG5obSAFn9uxYa7Pu', 'Registered', 0, 0, 18, '2011-06-23 11:30:10', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(64, 'agent2', 'agent2', 'agent2@agents.com', '31f998fed217f2ed1fd8aebfde04e288:tjzK1swpsbtQHEVdasGcuhxyU4Gbk4Kd', 'Registered', 0, 0, 18, '2011-06-23 11:30:29', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(65, 'agent3', 'agent3', 'agent3@agents.com', 'a509df77e5ca9e4fae0348770e61bfd1:85U7URdlttHtzGtxw6cVEo6WeQBJEeNc', 'Registered', 0, 0, 18, '2011-06-23 11:30:48', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(66, 'agent4', 'agent4', 'agent4@agents.com', '251be8d7cb6f6dbd0f4c31d13fcfd5bb:VPs01RWokUxn1KXYeh06g7EfUzRyCQsA', 'Registered', 0, 0, 18, '2011-06-23 11:31:09', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(67, 'agent5', 'agent5', 'agent5@agents.com', '8aae65458776b3290087c4e4005db584:owb1gxaghnPBzmQx5CHC6l6mWfE4j4m1', 'Registered', 0, 0, 18, '2011-06-23 11:31:24', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(68, 'agent6', 'agent6', 'agent6@agents.com', '610fd2155dfdf734b4cb5cd76fac666d:D3ys2Ml2glHpRowG6EdrYIQADrQnEvmu', 'Registered', 0, 0, 18, '2011-06-23 11:31:47', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(69, 'agent7', 'agent7', 'agent7@agents.com', '14bac2df35e6e2d83c2f7d640363debb:BfMzEeFrrVWIIGiebVclVyCKWb5h5YkE', 'Registered', 0, 0, 18, '2011-06-23 11:32:01', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n'),
(70, 'agent8', 'agent8', 'agent8@agents.com', '0e6646be137fc54bf45a757ed2e5a8fe:cK3CnfKb9dNB1KtpqvOTx4GmTb0Xmoua', 'Registered', 0, 0, 18, '2011-06-23 11:38:41', '0000-00-00 00:00:00', '', 'admin_language=\nlanguage=\neditor=\nhelpsite=\ntimezone=0\n\n');

INSERT IGNORE INTO `#__core_acl_aro` VALUES 
(11, 'users', '63', 0, 'agent1', 0),
(12, 'users', '64', 0, 'agent2', 0),
(13, 'users', '65', 0, 'agent3', 0),
(14, 'users', '66', 0, 'agent4', 0),
(15, 'users', '67', 0, 'agent5', 0),
(16, 'users', '68', 0, 'agent6', 0),
(17, 'users', '69', 0, 'agent7', 0),
(18, 'users', '70', 0, 'agent8', 0);

INSERT IGNORE INTO `#__core_acl_groups_aro_map` VALUES 
(18, '', 11),
(18, '', 12),
(18, '', 13),
(18, '', 14),
(18, '', 15),
(18, '', 16),
(18, '', 17),
(18, '', 18);

