<?php
/**
* @package Admin-User-Access (com_pi_admin_user_access)
* @version 2.4.0
* @copyright Copyright (C) 2007-2011 Carsten Engel. All rights reserved.
* @license GPL available versions: free, trial and pro
* @author http://www.pages-and-items.com
* @joomla Joomla is Free Software
*/

//no direct access
if(!defined('_VALID_MOS') && !defined('_JEXEC')){
	die('Restricted access');
}

//load frontend language file
$lang = JFactory::getLanguage();
$lang->load('com_pi_admin_user_access', JPATH_BASE, null, false);



class class_mod_aua{

	var $user_id;
	var $user_type;
	var $id;
	var $Itemid;
	var $path_to_root;
	var $db;
	var $ua_config;
	var $framework;
	//var $class_ua;

	//constructor
	function init(){		
		
		
		$user =& JFactory::getUser();			
		$this->user_id = $user->get('id');
		$this->user_type = $user->get('usertype');
		$this->view = JRequest::getVar('view', '');					
		$this->id = JRequest::getVar('id', '');	
		if(strpos($this->id, ':')){
			$pos_item_id = strpos($this->id, ':');
			$this->id = intval(substr($this->id, 0, $pos_item_id));	
		}		
		$this->path_to_root = '/../../';	
		$this->framework = '1.5.x';
		$this->db = JFactory::getDBO();	
					
		
		//require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_pi_admin_user_access'.DS.'class.php');
		//$this->class_ua = new class_ua();		
		//$this->ua_config = $this->class_ua->get_config();			
			
	}
		
	function mod_admin_user_access($ua_config) {
	
		$this->ua_config = $ua_config;	
		
		//get vars					
		$option = JRequest::getVar('option', 'com_content');		
		$task = JRequest::getVar('task', '');
		$layout = JRequest::getVar('layout', '');			
		
		//only if something is being editted
		if( 
		//com_content
		($option=='com_content' && ($task=='edit' || $layout=='form' || $task=='new')) ||
		//com_weblinks
		($option=='com_weblinks' && $layout=='form')
		){			
			
			global $my;
			
			//get more vars
			if(defined('_JEXEC')){
				//joomla 1.5
				$user =& JFactory::getUser();			
				$user_id = $user->get('id');
				$user_type = $user->get('usertype');
				$view = JRequest::getVar('view', '');	
				$task = JRequest::getVar('task', '');				
							
			}else{
				//joomla 1.0.x			
				$user_id = $my->id;				
				$user_type = $my->usertype;
				$view = mosGetParam( $_REQUEST, 'view', '' );				
				$Itemid = mosGetParam( $_REQUEST, 'Itemid', '' );						
			}	
			
			//only do restrictions when not super-administrator
			if($user_type!='Super Administrator'){					
				
				$script = '';
				
				
				//get usergroup					
				$this->db->setQuery("SELECT group_id FROM #__pi_aua_userindex WHERE user_id='$user_id' LIMIT 1 ");		
				$rows_group = $this->db->loadObjectList();			
				$row_group = $rows_group[0];
				$usergroup = $row_group->group_id;		
				
				//check item new 
				//frontend workflow			
				if(($this->framework=='1.5.x' && $option=='com_content' && (($view=='article' && $layout=='form') || $task=='new')) ||
				($this->framework=='1.0.x' && $option=='com_content' && $task=='new')
				){					
					//take out when free		
					$this->check_workflow(23, $usergroup);
					$script .= $this->check_access_item_frontend($usergroup, 'new');
					$section_id = intval(JRequest::getVar('sectionid', ''));
					if($section_id){
						//check item new when in section list
						$this->check_section_access_item_frontend($usergroup);	
					}								
				}				
				
				//check item edit 
				//frontend workflow
				if(($this->framework=='1.5.x' && $option=='com_content' && $view=='article' && $task=='edit') ||
				($this->framework=='1.0.x' && $option=='com_content' && $task=='edit')
				){				
					$this->check_workflow(24, $usergroup);					
					$this->check_item_access($usergroup);
					$script .= $this->check_access_item_frontend($usergroup, 'edit');				
				}
				
				//check weblink new
				//frontend workflow
				if(($this->framework=='1.5.x' && $option=='com_weblinks' && $view=='weblink' && $layout=='form') ||
				($this->framework=='1.0.x' && $option=='com_weblinks' && $task=='new')			
				){
					$this->check_workflow(25, $usergroup);
				}
				
				if($script){
					//if there is a script, add it to header
					//can't use $doc->addScriptdeclaration as this is happening onafterrender									
					$buffer = JResponse::getBody();	
					$buffer = str_replace('</head>', '<script>'.$script.'</script></head>', $buffer);
					JResponse::setBody($buffer);
				}
				
				
			}//end if no-super-admin
		}//end if do something			
	}//end bot function
	
	//take out when free
	function check_section_access_item_frontend($usergroup){
		//if section access restrictions are activated
		if($this->ua_config['active_sections'] && $this->check_trial_version_aua() && defined('_JEXEC')){		
			//joomla 1.5
			
			//get section id
			$section_id = intval(JRequest::getVar('sectionid', ''));				
			
			if($section_id){
			
				//get section access data
				$this->db->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
				$section_access_rights = $this->db->loadResultArray();						
					
				$section_right = $section_id.'__'.$usergroup;				
			
				//if user has no section-access-permission
				if(!in_array($section_right, $section_access_rights)){		
											
					$this->do_alert(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_SECTION_ITEM_ACCESS'));						
				}			
			}			
		}	
	}
	
	function check_workflow($right, $usergroup){		
		
		//if workflow is active
		if($this->ua_config['active_actions'] && $this->check_trial_version_aua()){			
			
			//get workflow data
			$this->db->setQuery("SELECT action_usergroupid FROM #__pi_aua_actions");
			$workflow_rights = $this->db->loadResultArray();
			
			//set workflow right to check
			$workflow_right = $right.'__'.$usergroup;
					
			//if user has no workflow rights			
			if(!in_array($workflow_right, $workflow_rights)){
							
				switch ($right) {
				case 23:
					$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_NEW_ITEM_FRONTEND_ACCESS');
					$this->do_alert($message);
					break;
				case 24:
					$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_ITEM_EDIT_FRONTEND');
					$this->do_alert($message);
					break;				
				case 25:
					$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_NEW_WEBLINK_FRONTEND_ACCESS');
					$this->do_alert($message);
					break;			
				//case 26:
				default:
					return false;
					break;			
				}						
			}else{
				//has got rights
				return true;
			}			
		}else{
			//workflow is not enabled so all goes
			return true;
		}
	}
	
	function check_item_access($usergroup){		
				
		//if item access restrictions are activated
		if($this->ua_config['active_items'] && $this->check_trial_version_aua()){
			
			$item_id = $this->id;
			
			//get item access data
			$this->db->setQuery("SELECT itemid_usergroupid FROM #__pi_aua_items");
			$item_access_rights = $this->db->loadResultArray();	
			
			$item_right = $item_id.'__'.$usergroup;				
			
			//if user has no item-access-permission
			if(!in_array($item_right, $item_access_rights)){		
										
				//unlock item
				$this->unlock_item($item_id);
				//alert and exit
				$this->do_alert(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_ITEM_ACCESS'));								
			}	
		}
		
		//if workflow is active and user has no right to edit other authors items, check if this item is made by user
		if($this->ua_config['active_actions'] && $this->check_trial_version_aua() && !$this->check_workflow(174, $usergroup)){
		
			$item_id = $this->id;
			
			//get author id of item			
			$this->db->setQuery("SELECT created_by FROM #__content WHERE id='$item_id'");
			$author_ids = $this->db->loadResultArray();			
			$author_id = $author_ids[0];		
			
			//if this user is not author
			if($author_id!=$this->user_id){
				$message = JText::_('COM_PI_ADMIN_USER_ACCESS_YOU_ARE_NOT_AUTHOR');
				$this->unlock_item($item_id);
				$this->do_alert($message);
			}
			
		}	
	}
	
	function unlock_item($item_id){
		$this->db->setQuery( "UPDATE #__content SET checked_out='0', checked_out_time='0' WHERE id='$item_id' "	);
		$this->db->query();
	}	
	
	function do_alert($message){
		echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
		echo "<script>alert('".addslashes(html_entity_decode($message))."'); window.history.go(-1); </script>";
		exit('<html><body><noscript>'.$message.'</noscript></body></html>');
	}	
	
	function check_trial_version_aua(){
		
		static $aua_key_checked_module;
		
		if(!$aua_key_checked_module){
			$aua_key_checked_module = 0;
			require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_pi_admin_user_access'.DS.'class.php');
			$class_ua = new class_ua();			
			if($class_ua->aua_check_trial_version()){
				$aua_key_checked_module = 1;
			}			
		}				
		return $aua_key_checked_module;
	}
	
	function check_access_item_frontend($usergroup, $new_or_edit){
	
		$script = '';		
	
		//take out when free
		//if section access restrictions are activated
		if($this->ua_config['active_sections'] && $this->check_trial_version_aua()){		
			
			$item_id = $this->id;				
			
			//get section access data
			$this->db->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
			$section_access_rights = $this->db->loadResultArray();			
			
			if($new_or_edit=='edit'){			
				
				//get section from id
				$this->db->setQuery("SELECT sectionid FROM #__content WHERE id='$item_id' LIMIT 1");		
				$item_rows = $this->db->loadObjectList();
				$item_row = $item_rows[0];
				$section_id = $item_row->sectionid;
				
				$section_right = $section_id.'__'.$usergroup;				
			
				//if user has no item-access-permission
				if(!in_array($section_right, $section_access_rights)){		
						
					$this->unlock_item($item_id);
					$this->do_alert(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_SECTION_ITEM_ACCESS'));						
				}			
			}//end item edit		
			
			//get sections
			$this->db->setQuery("SELECT id FROM #__sections");
			$all_sections = $this->db->loadResultArray();	
						
			//make array from sections which user has access to
			$user_sectons_access_array = array();		
			for($n = 0; $n < count($section_access_rights); $n++){
				$right = $section_access_rights[$n];			
				$right = explode('__', $right);			
				if($right[1]==$usergroup){
					array_push($user_sectons_access_array, $right[0]);
				}
			}
			
			//make array of sections user has NO access to
			$sections_with_no_access = array();
			foreach($all_sections as $section){
				if(!in_array($section, $user_sectons_access_array)){
					array_push($sections_with_no_access, $section);
				}
			}		
			
			//only need to rip sections out in joomla 1.5.x as joomla 1.0.x only uses news		
			if( defined('_JEXEC') ){
				//joomla 1.5			
			
						
				
				$javascript_array_sections_no_access = 'var sections_with_no_access = new Array(';
				
				$first = true;	
				foreach($sections_with_no_access as $section_no_access){
					if($first){
						$first = false;
					}else{
						$javascript_array_sections_no_access .= ',';
					}			
					$javascript_array_sections_no_access .= '"'.$section_no_access.'"';
				}		
				$javascript_array_sections_no_access .= ');';
				$script .= $javascript_array_sections_no_access."\n";				
				
				//javascript function to rip sections out of select
				$script .= 'function rip_sections_out_of_select(){'."\n";			
					$script .= "var elSel = document.getElementById('sectionid');\n";
					$script .= 'var i;'."\n";			
					$script .= 'for (i = elSel.length - 1; i>=0; i--){'."\n";				
						$script .= 'for (j=0; j < sections_with_no_access.length; j++) {'."\n";	
							$script .= 'if (elSel.options[i]){'."\n";			
								$script .= 'if (sections_with_no_access[j] === elSel.options[i].value){'."\n";						
									$script .= 'elSel.remove(i);'."\n";										
								$script .= '}'."\n";
							$script .= '}'."\n";
						$script .= '}'."\n";				
					$script .= '}'."\n";						
					
					if($new_or_edit=='new'){
						//set section select to default 0 so the categories get reloaded when the new section is choosen					
						$script .= 'document.getElementById("sectionid").options[0].selected = true;'."\n";	
					}				
						
				$script .= '}'."\n";			
				
				//call onload event
				$script .= 'if(window.addEventListener)window.addEventListener("load",rip_sections_out_of_select,false);'."\n";
				$script .= 'else if(window.attachEvent)window.attachEvent("onload",rip_sections_out_of_select);'."\n";
				
				
			}else{
				//joomla 1.0.x
				
				$section_id = mosGetParam( $_REQUEST, 'sectionid', '' );
				
				//if no acces do alert
				if(in_array($section_id, $sections_with_no_access)){
									
					$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_SECTION_ITEM_ACCESS');									
					$this->do_alert($message);	
				}
			}	
		}//end section restrictions
		
		//take out when free
		//check workflow for hiding 'uncategorized' option
		if($this->check_workflow(26, $usergroup) && $this->framework!='1.0.x'){
			//$javascript_array_sections_no_access .= '"0",';
			
			
			$script .= 'function hide_uncaterized_option(){'."\n";			
				$script .= "var elSel = document.getElementById('sectionid');\n";
				$script .= 'var i;'."\n";			
				$script .= 'for (i = elSel.length - 1; i>=0; i--){'."\n";									
					$script .= 'if (elSel.options[i].value == "0"){'."\n";						
						$script .= 'elSel.remove(i);'."\n";										
					$script .= '}'."\n";								
				$script .= '}'."\n";								
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",hide_uncaterized_option,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",hide_uncaterized_option);'."\n";
			
						
		}			
				
		//if page access or category access restrictions are activated
		if(($this->ua_config['active_pagesaccess'] || $this->ua_config['active_categories']) && $this->check_trial_version_aua()){				
			
			if($this->ua_config['com_content_access']=='page_access'){
				//if category access is checked with page-access
				
				//get page access data
				$this->db->setQuery("SELECT pageid_usergroupid FROM #__pi_aua_access_pages");
				$pages_access_rights = $this->db->loadResultArray();		
					
				//make array of pages which user has access to		
				$user_page_access_array = '';
				$first = true;		
				for($n = 0; $n < count($pages_access_rights); $n++){
					$right = $pages_access_rights[$n];			
					$right = explode('_', $right);			
					if($right[1]==$usergroup){				
						if(!$first){
							$user_page_access_array .= ',';				
						}
						$user_page_access_array .= $right[0];
						if($first){
							$first = false;					
						}
					}
				}	
				
				//check page access	if edit item
				if($new_or_edit=='edit'){			
					if( defined('_JEXEC') ){
						//joomla 1.5
						$page_id = JRequest::getVar('Itemid', '');			
					}else{
						//joomla 1.0.x
						$page_id = mosGetParam( $_REQUEST, 'Itemid', '' );			
					}		
					$temp = explode(',',$user_page_access_array);		
					if(!in_array($page_id,$temp)){
														
						$item_id = $this->id;		
						$this->unlock_item($item_id);	
						$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_PAGE_ITEM_ACCESS');									
						$this->do_alert($message);	
					}
				}
				//print_r( $temp);
				//$script .= $page_id;
				
				//get page data
				$this->db->setQuery("SELECT id, link, componentid, type FROM #__menu WHERE id in ($user_page_access_array)");
				$all_menuitems = $this->db->loadObjectList();		
				
				$all_menuitems_with_categories = array();
				//make a new array from all categories which are used as category-blog-pages in menu
				foreach($all_menuitems as $menuitem){
					if(((strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog') && $menuitem->type=='url') || !strstr($menuitem->link, 'index.php?option=com_content&view=category&layout=blog')) && $menuitem->type!='content_blog_category'){
						//something else	
					}else{
						//category-blog-page
						array_push($all_menuitems_with_categories, $menuitem->id);		
					}
				}		
				
				//get categories from menuitems
				$all_categories_access = array();		
				foreach($all_menuitems as $menuitem){
					if(in_array($menuitem->id,$all_menuitems_with_categories)){			
						if(defined('_JEXEC')){
							//joomla 1.5
							$cat_id = str_replace('index.php?option=com_content&view=category&layout=blog&id=','',$menuitem->link);				
						}else{	
							//joomla 1.0.x
							$cat_id = $menuitem->componentid;				
						}
						array_push($all_categories_access, $cat_id);				
					}							
				} 	
				
				//end if category access is checked with page-access
			}elseif($this->ua_config['com_content_access']=='category_access' && $this->ua_config['active_categories']){
				//category access is checked with category-access
				
				//get category access data
				$this->db->setQuery("SELECT category_groupid FROM #__pi_aua_categories");
				$category_access_rights = $this->db->loadResultArray();
				
				//print_r($category_access_rights);
				
				$item_id = $this->id;		
				
				//check category access right, only when editting
				if($new_or_edit=='edit'){
				
					//get category from id
					//get items cat id		
					$this->db->setQuery("SELECT catid FROM #__content WHERE id='$item_id' LIMIT 1 ");
					$rows = $this->db->loadResultArray();
					$cat_id = $rows[0];
					
					//$script .= 'catid='.$cat_id;
					//$script .= 'item_id='.$item_id;
					//$script .= 'new-or-edit=='.$new_or_edit;
					
					$category_right = $cat_id.'__'.$usergroup;				
				
					//$script .= $section_right;
					
					//if user has no item-access-permission
					if(!in_array($category_right, $category_access_rights)){											
							
						//unlock item	
						$this->unlock_item($item_id);			
						$message = JText::_('COM_PI_ADMIN_USER_ACCESS_NO_CATEGORY_ITEM_ACCESS');									
						$this->do_alert($message);														
					}	
				
				}
				
				//get categories
				$this->db->setQuery("SELECT id FROM #__categories");
				$all_categories = $this->db->loadResultArray();	
							
				//make array from categories which user has access to
				$all_categories_access = array();		
				for($n = 0; $n < count($category_access_rights); $n++){
					$right = $category_access_rights[$n];			
					$right = explode('__', $right);			
					if($right[1]==$usergroup){
						array_push($all_categories_access, $right[0]);
					}
				}
			
				//end if category access is checked with category-access
			}	
			
			
					
			
			//make javascript array of categories which user has access to
			$javascript_array_category_access = 'var categories_with_access = new Array(';		
			$first = true;	
			foreach($all_categories_access as $category){
				if($first){
					$first = false;
				}else{
					$javascript_array_category_access .= ',';
				}			
				$javascript_array_category_access .= '"'.$category.'"';
			}		
			$javascript_array_category_access .= ');';
			$script .= $javascript_array_category_access."\n\n";		
				
			//javascript in_array function
			$script .= 'Array.prototype.in_array = function (element){'."\n";
				$script .= 'var retur = false;'."\n";
				$script .= 'for (var values in this){'."\n";
					$script .= 'if (this[values] == element){'."\n";
						$script .= 'retur = true;'."\n";
						$script .= 'break;'."\n";
					$script .= '}'."\n";
				$script .= '}'."\n";
				$script .= 'return retur;'."\n";
			$script .= '};'."\n\n"; 				
					
			//javascript function to rip categories out of category-array of dynamic select
			$script .= 'function filter_categories(){'."\n";			
				//$script .= 'if(document.adminForm.catid){'."\n";	
				
				//if edit get selected cat
				if($new_or_edit=='edit'){			
					$script .= 'var selected_category = document.adminForm.catid.value;'."\n";	
					//$script .= 'alert(selected_category);'."\n";						
				}			
				
				//take categories out of array
				$script .= 'for (i = 0; i < sectioncategories.length; i++){'."\n";											
					$script .= 'if(!categories_with_access.in_array(sectioncategories[i][1])){'."\n";								
						$script .= 'sectioncategories.splice(i,1);'."\n";														
						$script .= 'i = i-1;'."\n";																	
					$script .= '}'."\n";																	
				$script .= '}'."\n";
				
				if($new_or_edit=='edit'){
				
					//refresh category select by changing the section select and back again
					$script .= 'var selected_section = document.adminForm.sectionid.selectedIndex;'."\n";
					$script .= 'changeDynaList("catid", sectioncategories, document.adminForm.sectionid.options[0].value, 0, 0);'."\n";
					$script .= 'changeDynaList("catid", sectioncategories, document.adminForm.sectionid.options[selected_section].value, 0, 0);'."\n";				
					
					//select the category innitialy selected	
					$script .= 'if(selected_category){'."\n";								
						$script .= 'for(index = 0; index < document.adminForm.catid.length; index++){'."\n";	
							$script .= 'if(document.adminForm.catid[index].value == selected_category){'."\n";	
								$script .= 'document.adminForm.catid.selectedIndex = index;'."\n";	
							$script .= '}'."\n";	
						$script .= '}'."\n";							
					$script .= '}'."\n";
					
				}//end if edit page
				
				if($new_or_edit=='new'){
					//set section select to default 0 so the categories get reloaded when the new section is choosen					
					$script .= 'document.getElementById("sectionid").options[0].selected = true;'."\n";
				}			
				
			$script .= '}'."\n\n";//end function
					
			
						
																	
				
			
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",filter_categories,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",filter_categories);'."\n";
			
			
		
		}//end if page access
		
		
		//take out when free
		//check workflow for publish rights
		if(!$this->check_workflow(42, $usergroup) && $this->user_type!='Author' && $this->user_type!='Editor'){
			
			
			
			$script .= 'function set_to_unpublish(){'."\n";
				if(defined('_JEXEC')){
					//joomla 1.5
					if($this->check_workflow(39, $usergroup)){
						$script .= "document.getElementById('state0').checked = true;\n";	
					}
					$script .= "document.getElementById('state0').disabled = true;\n";	
					$script .= "document.getElementById('state1').disabled = true;\n";
				}else{
	
					//joomla 1.0.x
					$script .= "var state_select = document.adminForm.state;\n";	
					if($this->check_workflow(39, $usergroup)){			
						$script .= 'var i;'."\n";			
						$script .= 'for (i = state_select.length - 1; i>=0; i--){'."\n";							
								$script .= 'if(state_select.options[i].value==0){'."\n";								
									$script .= 'state_select.options[i].selected = true;'."\n";										
								$script .= '}'."\n";							
						$script .= '}'."\n";
					}
					$script .= 'state_select.disabled = true;'."\n";			
				}		
																	
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",set_to_unpublish,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",set_to_unpublish);'."\n";
			
			
						
		}
		
		
		//take out when free
		//check workflow for frontpage
		if(!$this->check_workflow(48, $usergroup)){
			
			
			
			$script .= 'function disable_frontpage_selector(){'."\n";
				if(defined('_JEXEC')){
					//joomla 1.5
					if($this->check_workflow(85, $usergroup)){
						$script .= "document.getElementById('frontpage0').checked = true;\n";	
					}				
					$script .= "document.getElementById('frontpage0').disabled = true;\n";	
					$script .= "document.getElementById('frontpage1').disabled = true;\n";
				}else{
					//joomla 1.0.x
					if($this->check_workflow(85, $usergroup)){
						$script .= "document.adminForm.frontpage.checked = false;\n";	
					}
					$script .= "document.adminForm.frontpage.disabled = true;\n";		
				}		
																	
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_frontpage_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_frontpage_selector);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for author alias
		if(!$this->check_workflow(44, $usergroup)){
			
			
			
			$script .= 'function disable_author_alias_selector(){'."\n";
				$script .= "document.adminForm.created_by_alias.disabled = true;\n";	
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_author_alias_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_author_alias_selector);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for start publishing
		if(!$this->check_workflow(46, $usergroup)){
			
			
			
			$script .= 'function disable_start_publishing_selector(){'."\n";
				$script .= "document.getElementById('publish_up').disabled = true;\n";
				if(defined('_JEXEC')){
					//joomla 1.5
					$script .= "document.getElementById('publish_up_img').style.display = 'none';\n";				
				}																
			$script .= '}'."\n";	
			
			if(!defined('_JEXEC')){				
				//joomla 1.0.x
				$script .= 'function showCalendar(nothing, nothing){return false;}'."\n";		
			}	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_start_publishing_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_start_publishing_selector);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for stop publishing
		if(!$this->check_workflow(47, $usergroup)){
			
			
			
			$script .= 'function disable_start_publishing_selector(){'."\n";
			$script .= "document.getElementById('publish_down').disabled = true;\n";
				if(defined('_JEXEC')){
					//joomla 1.5				
					$script .= "document.getElementById('publish_down_img').style.display = 'none';\n";				
				}
				
			if(!defined('_JEXEC')){				
				//joomla 1.0.x
				$script .= 'function showCalendar(nothing, nothing){return false;}'."\n";		
			}	
																	
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_start_publishing_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_start_publishing_selector);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for access levels
		if(!$this->check_workflow(43, $usergroup)){
			
			
			
			$script .= 'function disable_access_levels_selector(){'."\n";
					$script .= "document.adminForm.access.disabled = true;\n";	
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_access_levels_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_access_levels_selector);'."\n";
			
			
		}
		
		//take out when free
		//check workflow for ordering
		if(!$this->check_workflow(45, $usergroup)){
			
			
			
			$script .= 'function disable_ordering_selector(){'."\n";
				$script .= "document.adminForm.ordering.disabled = true;\n";
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_ordering_selector,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_ordering_selector);'."\n";
			
			
						
		}	
		
		//take out when free
		//check workflow for sections
		if(!$this->check_workflow(50, $usergroup)){
			
			
			
			$script .= 'function disable_sections(){'."\n";
				$script .= "document.adminForm.sectionid.disabled = true;\n";
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_sections,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_sections);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for categories
		if(!$this->check_workflow(51, $usergroup)){
			
			
			
			$script .= 'function disable_categories(){'."\n";
				$script .= "document.adminForm.catid.disabled = true;\n";
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_categories,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_categories);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for description
		if(!$this->check_workflow(52, $usergroup)){
			
			
			
			$script .= 'function disable_description(){'."\n";
				$script .= "document.adminForm.metadesc.disabled = true;\n";
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_description,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_description);'."\n";
			
			
						
		}
		
		//take out when free
		//check workflow for keywords
		if(!$this->check_workflow(53, $usergroup)){
			
			
			
			$script .= 'function disable_keywords(){'."\n";
				$script .= "document.adminForm.metakey.disabled = true;\n";
			$script .= '}'."\n";	
						
			//call onload event
			$script .= 'if(window.addEventListener)window.addEventListener("load",disable_keywords,false);'."\n";
			$script .= 'else if(window.attachEvent)window.attachEvent("onload",disable_keywords);'."\n";
			
			
						
		}
		
		return $script;
		
	}//end item frontend
	
	function check_backend_article_edit($aua_config){
		
		$database = JFactory::getDBO();
		$this->ua_config = $aua_config;
		$user_id = $this->user_id;
		
		//get vars					
		$option = JRequest::getVar('option', 'com_content');		
		$task = JRequest::getVar('task', '');
		$layout = JRequest::getVar('layout', '');
		
		if($option=='com_content' && $task=='edit' && $this->user_type!='Super Administrator' && $this->check_trial_version_aua()){
			
			//get usergroup					
			$database->setQuery("SELECT group_id FROM #__pi_aua_userindex WHERE user_id='$user_id' LIMIT 1 ");		
			$groups = $database->loadObjectList();
			$group_id = 0;	
			foreach($groups as $group){
				$group_id = $group->group_id;				
			}
				
			//get article id			
			$cit = JRequest::getVar('cid', null, 'get', 'array');
			if(is_array($cit)){
				$item_id = $cit[0];
			}else{
				$item_id = JRequest::getVar('cit', '');
			}
			
			//get article category and section
			$database->setQuery("SELECT catid, sectionid FROM #__content WHERE id='$item_id' LIMIT 1");		
			$item_rows = $database->loadObjectList();
			
			$cat_id = 0;
			$section_id = 0;
			foreach($item_rows as $item_row){
				$cat_id = $item_row->catid;
				$section_id = $item_row->sectionid;
			}		
			
			//check item acccess
			if($this->ua_config['active_items']){			
			
				//get item access data
				$database->setQuery("SELECT itemid_usergroupid FROM #__pi_aua_items");
				$item_access_rights = $database->loadResultArray();	
				
				$item_right = $item_id.'__'.$group_id;				
				
				//if user has no item-access-permission
				if(!in_array($item_right, $item_access_rights)){		
											
					//unlock item
					$this->unlock_item($item_id);
					$this->load_language();
					//message and exit
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_ITEM_ACCESS'));								
				}	
			}
			
			//check category access
			if($this->ua_config['active_categories']){			
			
				//get item access data
				$database->setQuery("SELECT category_groupid FROM #__pi_aua_categories");
				$category_access_rights = $database->loadResultArray();	
				
				$category_right = $cat_id.'__'.$group_id;				
				
				if(!in_array($category_right, $category_access_rights)){							
					//unlock item	
					$this->unlock_item($item_id);
					$this->load_language();
					//message and exit			
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_CATEGORY_ITEM_ACCESS'));														
				}		
			}
			
			//check section access
			if($this->ua_config['active_sections']){			
			
				//get item access data
				$database->setQuery("SELECT section_groupid FROM #__pi_aua_sections");
				$section_access_rights = $database->loadResultArray();	
				
				$section_right = $section_id.'__'.$group_id;				
				
				if(!in_array($section_right, $section_access_rights)){							
					//unlock item	
					$this->unlock_item($item_id);
					$this->load_language();
					//message and exit			
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_SECTION_ITEM_ACCESS'));														
				}		
			}			
		}
	}
	
	function do_alert2($message){
		echo '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head><body>';
		echo '<div style="text-align: center; margin-top: 300px; font-family: verdana;">';
		echo $message;
		echo '<br /><a href="javascript:history.back()">';
		echo JText::_('BACK');
		echo '</a>';
		echo '</div>';
		echo '</body></html>';
		exit;	
	}
	
	function load_language(){
		//load frontend language file
		$lang = JFactory::getLanguage();
		$lang->load('com_pi_admin_user_access', JPATH_ROOT, null, false);
	}
	
	function check_menu_access($aua_config){
	
		if($this->user_type=='Super Administrator' || !$this->check_trial_version_aua()){
			//super admin or no valid trial version, so don't do any restriction
			return true;
		}
	
		$database = JFactory::getDBO();
		$this->ua_config = $aua_config;
		$user_id = $this->user_id;
		
		//get vars					
		$option = JRequest::getVar('option', '');		
		$task = JRequest::getVar('task', '');
		
		//get usergroup					
		$database->setQuery("SELECT group_id FROM #__pi_aua_userindex WHERE user_id='$user_id' LIMIT 1 ");		
		$groups = $database->loadObjectList();
		$group_id = 0;	
		foreach($groups as $group){
			$group_id = $group->group_id;				
		}		
		
		//start edit menu item
		if($option=='com_menus' && $task=='edit'){			
				
			//get menu item id			
			$menu_item_id = $this->get_cid();
			
			//get the menu-item's menu-type
			$menu_type = '';
			$database->setQuery("SELECT menutype "
			." FROM #__menu "
			." WHERE id='$menu_item_id' "
			." LIMIT 1 "
			);
			$rows = $database->loadObjectList();
			foreach($rows as $row){	
				$menu_type = $row->menutype;
			}
			
			//get the menu-types id
			$menu_type_id = $this->get_menu_type_id($menu_type);
			
			//check menu acccess
			if($this->ua_config['activate_menus'] && $menu_item_id){			
			
				//get menu access data
				$database->setQuery("SELECT menu_groupid FROM #__pi_aua_menus ");
				$menutype_access_rights = $database->loadResultArray();	
				
				$menutype_right = $menu_type_id.'__'.$group_id;				
				
				//if user has no item-access-permission
				if(!in_array($menutype_right, $menutype_access_rights)){		
											
					//unlock menu item
					$this->unlock_menu_item($menu_item_id);
					$this->load_language();
					//message and exit
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_MENU_ITEM_ACCESS'));								
				}	
			}			
		}
		//end edit menu item		
		
		//start menus > menu-type
		if($option=='com_menus' && $task=='view'){				
			
			if($this->ua_config['activate_menus']){	
			
				$menu_type = JRequest::getVar('menutype', '');				
			
				//get the menu-types id
				$menu_type_id = $this->get_menu_type_id($menu_type);				
			
				//get menu access data
				$database->setQuery("SELECT menu_groupid FROM #__pi_aua_menus ");
				$menutype_access_rights = $database->loadResultArray();	
				
				$menutype_right = $menu_type_id.'__'.$group_id;				
				
				//if user has no item-access-permission
				if(!in_array($menutype_right, $menutype_access_rights)){		
											
					$this->load_language();
					//message and exit
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_MENU_ITEM_ACCESS'));								
				}			
			}		
		}		
		//end menus > menu-type
		
		//start menus > menu-manager > menutype
		if($option=='com_menus' && $task=='editMenu'){
			if($this->ua_config['activate_menus']){	
				$menu_type_id = JRequest::getVar('id', '');	
				
				//get menu access data
				$database->setQuery("SELECT menu_groupid FROM #__pi_aua_menus ");
				$menutype_access_rights = $database->loadResultArray();	
				
				$menutype_right = $menu_type_id.'__'.$group_id;				
				
				//if user has no item-access-permission
				if(!in_array($menutype_right, $menutype_access_rights)){		
											
					$this->load_language();
					//message and exit
					$this->do_alert2(JText::_('COM_PI_ADMIN_USER_ACCESS_NO_MENU_TYPE_ACCESS'));								
				}
				
			}
		
		}
		//end menus > menu-manager > menutype
		
	}
	
	function unlock_menu_item($menu_item_id){
		$this->db->setQuery( "UPDATE #__menu SET checked_out='0', checked_out_time='0' WHERE id='$menu_item_id' LIMIT 1 "	);
		$this->db->query();
	}
	
	function get_cid(){
		$cid = 0;
		$cid_array = JRequest::getVar('cid', null, 'get', 'array');
		if(is_array($cid_array)){
			$cid = $cid_array[0];
		}else{
			$cid  = JRequest::getVar('cid', '');
		}	
		$cid = intval($cid);	
		return $cid;
	}

	function get_menu_type_id($menu_type){
		$database = JFactory::getDBO();	
		$menu_type_id = 0;
		$database->setQuery("SELECT id FROM #__menu_types WHERE menutype='$menu_type' LIMIT 1 ");
		$rows = $database->loadObjectList();
		foreach($rows as $row){	
			$menu_type_id = $row->id;
		}
		$menu_type_id = intval($menu_type_id);
		return $menu_type_id;
	}
}
	




?>