<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class DJCatalog2ViewItems extends JView
{
	function display($tpl = null)
	{
		$edit	= JRequest::getVar('edit',true);
		if ($this->getLayout() == 'form') {
			$this->_form();
			return;
		}
		global $option;
		$app =& JFactory::getApplication();
		
		$task = JRequest::getVar('task');
		
		$filter_state		= $app->getUserStateFromRequest( $option.$task.'filter_state',		'filter_state',		'',				'word' );
		$filter_catid		= $app->getUserStateFromRequest( $option.$task.'filter_cat_id',		'filter_cat_id',		0,				'int' );
		$filter_producerid		= $app->getUserStateFromRequest( $option.$task.'filter_producer_id',		'filter_producer_id',		0,				'int' );
		$filter_typeid		= $app->getUserStateFromRequest( $option.$task.'filter_type_id',		'filter_type_id',		0,				'int' );
		$filter_order		= $app->getUserStateFromRequest( $option.$task.'filter_order',		'filter_order',		'i.ordering',	'cmd' );
		$filter_order_Dir	= $app->getUserStateFromRequest( $option.$task.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		$search				= $app->getUserStateFromRequest( $option.$task.'search',			'search',			'',				'string' );
		$search				= JString::strtolower( $search );
		
		$lists['order_Dir'] = $filter_order_Dir;
		$lists['order'] = $filter_order;
		
		$model = $this->getModel();
		$list = $model->getList();
		$total = $model->getTotal();
		
		$pagination = $model->getPagination();
		
		$javascript 	= 'onchange="document.adminForm.submit();"';
		
		// state filter
		$lists['state']	= JHTML::_('grid.state',  $filter_state );
		
		// search filter
		$lists['search']= $search;
		
		// category filter
		$categories = $model->getCategories();
		$tree = new CatTree();
        $tree->buildTree($categories);
        $root = & $tree->getRoot();
		
		$options = renderCategoryFilter($root);
		$lists['categories'] = JHTML::_('select.genericlist', $options, 'filter_cat_id', $javascript, 'value', 'text', $filter_catid);
		
		$producers_first_option = new stdClass();
		$producers_first_option->id = '';
		$producers_first_option->name = '- '.JText::_('COM_DJCATALOG2_SELECT_PRODUCER').' -';
		$producers_first_option->published = null;
		$prodList = $model->getProducers();
		$producers = count($prodList) ? array_merge(array($producers_first_option),$prodList) : array($producers_first_option);
		$lists['producers'] = JHTML::_('select.genericlist', $producers, 'filter_producer_id', $javascript, 'id', 'name', $filter_producerid);
		
		$this->assignref('lists', $lists);
		$this->assignref('items', $list);
		$this->assignref('total', $total);
		$this->assignRef('pagination',	$pagination);
		
		parent::display($tpl);
	}
	function _form() {
		global $option;

		$model = $this->getModel();
		$item = $model->getData();
		
		$categories = $model->getCategories();
		$tree = new CatTree();
        $tree->buildTree($categories);
        $root = & $tree->getRoot();
		
		$options = renderCategoryFilter($root);
		$categories = JHTML::_('select.genericlist', $options, 'cat_id', ' size="10"', 'value', 'text', $item->cat_id);
		
		$producers = $model->getProducers();
		
		$lists['published'] = JHTML::_('select.booleanlist',  'published', 'class="inputbox"', $item->published );
		
		$query = 'SELECT ordering AS value, name AS text'
			. ' FROM #__djc2_items'
			. ' WHERE cat_id = ' . (int) $item->cat_id
			. ' ORDER BY ordering';

		$lists['ordering'] 			= JHTML::_('list.specificordering',  $item, $item->id, $query );
		
		$file 	= JPATH_COMPONENT.DS.'models'.DS.'items.xml';
		$params = null;
		if(file_exists($file))
			$params = new JParameter( $item->params, $file );
		
		$this->assignRef('item', $item);
		$this->assignRef('lists',		$lists);
		$this->assignRef('params',		$params);
		$this->assignRef('categories',		$categories);
		$this->assignref('producers', $producers);
		parent::display();
	}
	function _getFileNoExt($filename) {
			$fileParts = preg_split("/\./", $filename);
			$fileNoExt ='';
			for ($i = 0; $i < count($fileParts)-1; $i++) 
				$fileNoExt .= $fileParts[$i];
			return $fileNoExt;
		}
}
