<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die('Restricted access'); ?>

<?php JHTML::_('behavior.tooltip'); ?>

<?php
	// Set toolbar items for the page
JToolBarHelper::title(   JText::_( 'COM_DJCATALOG2_ITEMS' ), 'generic.png' );
JToolBarHelper::custom('recreateThumbnails','move','move',JText::_('COM_DJCATALOG2_RECREATE_THUMBNAILS'),true,true);
JToolBarHelper::publishList('publish');
JToolBarHelper::unpublishList('unpublish');
JToolBarHelper::deleteList(null,'deleteItem');
JToolBarHelper::editListX('editItem');
JToolBarHelper::addNewX('addItem');
JToolBarHelper::preferences('com_djcatalog2', '500');
$ordering = ($this->lists['order'] == 'i.ordering');
?>
<form action="index.php" method="post" name="adminForm">
<table>
<tr>
	<td align="left" width="100%">
		<?php echo JText::_( 'COM_DJCATALOG2_FILTER' ); ?>:
		<input type="text" name="search" id="search" value="<?php echo $this->lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
		<button onclick="this.form.submit();"><?php echo JText::_( 'COM_DJCATALOG2_GO' ); ?></button>
		<button onclick="document.getElementById('search').value='';this.form.getElementById('filter_catid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'COM_DJCATALOG2_RESET' ); ?></button>
	</td>
	<td nowrap="nowrap">
		<?php
			echo $this->lists['categories'];
			echo $this->lists['producers'];
			echo $this->lists['state'];
		?>
	</td>
</tr>
</table>
<div id="editcell">
	<table class="adminlist">
	<thead>
		<tr>
			<th width="5">
				<?php echo JText::_( 'COM_DJCATALOG2_NUM' ); ?>
			</th>
			<th width="20">
				<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $this->items ); ?>);" />
			</th>
			<th width="75" align="center">
				<?php echo JText::_('COM_DJCATALOG2_IMAGE'); ?>
			</th>
			<th class="title">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_NAME', 'i.name', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="5%" nowrap="nowrap">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_PUBLISHED', 'i.published', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="8%" nowrap="nowrap">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_ORDER', 'i.ordering', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				<?php if ($ordering) echo JHTML::_('grid.order',  $this->items ); ?>
			</th>
			<th width="15%"  class="title">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_CATEGORY', 'category', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="15%"  class="title">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_PRODUCER', 'producer', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="1%" nowrap="nowrap">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_ID', 'i.id', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="9">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>
	<tbody>
	<?php
	$k = 0;
	for ($i=0, $n=count( $this->items ); $i < $n; $i++)
	{
		$row = &$this->items[$i];

		$link 	= JRoute::_( 'index.php?option=com_djcatalog2&view=item&task=editItem&cid[]='. $row->id/*.'&type_id='.$row->type_id */);

		$checked 	= JHTML::_('grid.id',   $i, $row->id );
		$published 	= JHTML::_('grid.published', $row, $i );

		$row->cat_link 	= JRoute::_( 'index.php?option=com_djcatalog2&task=editCategory&cid[]='. $row->cat_id );
		$row->prod_link 	= JRoute::_( 'index.php?option=com_djcatalog2&task=editProducer&cid[]='. $row->producer_id );
		?>
		<tr class="<?php echo "row$k"; ?>">
			<td>
				<?php echo $this->pagination->getRowOffset( $i ); ?>
			</td>
			<td>
				<?php echo $checked; ?>
			</td>
			<td align="center">
				<?php 
					$field_controller	= new DJCatalogImage();
					$images = $field_controller->getImages($row->image_url);
				?>
				<?php 
				if ($images) { ?><img src="<?php echo $images[0]['thumb']; ?>" alt="<?php echo $row->name; ?>" /><?php }
				else { ?><img src="<?php echo str_replace('/administrator', '', JURI::base()).'components/com_djcatalog2/theme/images/noimage.jpg'; ?>" alt="" /><?php }?>
			</td>
			<td>
				<?php
				?>
				<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_ITEM_TOOLTIP' );?>::<?php echo $this->escape($row->name); ?>&lt;br&gt;&lt;br&gt;<img src=&quot;<?php echo $images[0]['thumb'];?>&quot;/>">
					<a href="<?php echo $link; ?>">
						<?php echo $this->escape($row->name); ?></a></span>
			</td>
			<td align="center">
				<?php echo $published;?>
			</td>
			<td class="order">
				<span><?php echo $this->pagination->orderUpIcon( $i, ($row->cat_id == @$this->items[$i-1]->cat_id),'orderup', 'Move Up', $ordering ); ?></span>
				<span><?php echo $this->pagination->orderDownIcon( $i, $n, ($row->cat_id == @$this->items[$i+1]->cat_id), 'orderdown', 'Move Down', $ordering ); ?></span>
				<?php $disabled = $ordering ?  '' : 'disabled="disabled"'; ?>
				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering;?>" <?php echo $disabled ?> class="text_area" style="text-align: center" />
			</td>
			<td>
				<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_CATEGORY_TOOLTIP' );?>::<?php echo $this->escape($row->category); ?>">
				<a href="<?php echo $row->cat_link; ?>" >
				<?php echo $this->escape($row->category); ?></a></span>
			</td>
			<td>
				<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_PRODUCER_TOOLTIP' );?>::<?php echo $this->escape($row->producer); ?>">
				<a href="<?php echo $row->prod_link; ?>" >
				<?php echo $this->escape($row->producer); ?></a></span>
			</td>
			<td align="center">
				<?php  echo $row->id; ?>
			</td>
		</tr>
		<?php
		$k = 1 - $k;
	}
	?>
	</tbody>
	</table>
</div>

	<input type="hidden" name="option" value="com_djcatalog2" />
	<input type="hidden" name="view" value="items" />
	<input type="hidden" name="task" value="showItems" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php echo DJCATFOOTER; ?>