<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class DJCatalog2ViewCategories extends JView
{
	function display($tpl = null)
	{
		if ($this->getLayout() == 'form') {
			$this->_form();
			return;
		}
		global $option;
		$app =& JFactory::getApplication();
		
		$task = JRequest::getVar('task');
				
		$model = $this->getModel();
		$list = $model->getList(1);
		
		// Ensure ampersands and double quotes are encoded in item titles
		foreach ($list as $i => $item) {
			$treename = $item->treename;
			$treename = JFilterOutput::ampReplace($treename);
			$treename = str_replace('"', '&quot;', $treename);
			$list[$i]->treename = $treename;
		}
		
		$pagination = $model->getPagination();
		
		$filter_order		= $app->getUserStateFromRequest( $option.$task.'filter_order',		'filter_order',		'ordering',	'cmd' );
		$filter_order_Dir	= $app->getUserStateFromRequest( $option.$task.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		
		$lists['order_Dir'] = $filter_order_Dir;
		$lists['order'] = $filter_order;
		
		$this->assignRef('lists', $lists);
		$this->assignref('items', $list);
		$this->assignRef('pagination',	$pagination);
		parent::display($tpl);
	}
	function _form() {
		global $option;
		
		$model = $this->getModel();
		$item = $model->getData();
		
		$rootcategory = new stdClass();
		$rootcategory->id = null;
		$rootcategory->parent_id = null;
		$rootcategory->name = '-- '.JText::_('COM_DJCATALOG2_SELECT_ROOT_CAT').' --';
		$rootcategory->treename = '-- '.JText::_('COM_DJCATALOG2_SELECT_ROOT_CAT').' --';
		$rootcategory->published = null;
		
		$firstoption = array($rootcategory);
		$categoryList = $model->getList();
		
		// Ensure ampersands and double quotes are encoded in item titles
		foreach ($categoryList as $i => $catitem) {
			$treename = $catitem->treename;
			$treename = JFilterOutput::ampReplace($treename);
			$treename = str_replace('"', '&quot;', $treename);
			$categoryList[$i]->treename = $treename;
		}
		
		$categories = count($categoryList) ? array_merge($firstoption, $categoryList) : $firstoption;
		$lists['published'] = JHTML::_('select.booleanlist',  'published', 'class="inputbox"', $item->published );
		
		$query = 'SELECT ordering AS value, name AS text'
			. ' FROM #__djc2_categories '
			. ' WHERE parent_id = ' . (int) $item->parent_id
			. ' ORDER BY ordering';
		
		$lists['ordering'] 			= JHTML::_('list.specificordering',  $item, $item->id, $query );
		
		$this->assignRef('item', $item);
		$this->assignRef('categories', $categories);
		$this->assignRef('lists',		$lists);
		parent::display();
	}
}
