<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die('Restricted access'); 

JHTML::_('behavior.tooltip'); 

JToolBarHelper::title(   JText::_( 'COM_DJCATALOG2_CATEGORIES' ), 'generic.png' );
JToolBarHelper::custom('recreateThumbnails','move','move',JText::_('COM_DJCATALOG2_RECREATE_THUMBNAILS'),true,true);
JToolBarHelper::publishList('publish');
JToolBarHelper::unpublishList('unpublish');
JToolBarHelper::deleteList(null,'deleteCategory');
JToolBarHelper::editListX('editCategory');
JToolBarHelper::addNewX('addCategory');
JToolBarHelper::preferences('com_djcatalog2', '500');

$ordering = ($this->lists['order'] == 'ordering');

?>
<form action="index.php" method="post" name="adminForm">
<div id="editcell">
	<table class="adminlist">
	<thead>
		<tr>
			<th width="5">
				<?php echo JText::_( 'COM_DJCATALOG2_NUM' ); ?>
			</th>
			<th width="20">
				<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $this->items ); ?>);" />
			</th>
			<th width="75" align="center">
				<?php echo JText::_('COM_DJCATALOG2_IMAGE'); ?>
			</th>
			<th class="title">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_NAME', 'name', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="5%" nowrap="nowrap">
				<?php echo JHTML::_('grid.sort',  'COM_DJCATALOG2_PUBLISHED', 'published', $this->lists['order_Dir'], $this->lists['order'] ); ?>
			</th>
			<th width="8%" nowrap="nowrap">
				<?php echo JHTML::_('grid.sort',   'COM_DJCATALOG2_ORDER', 'ordering', @$this->lists['order_Dir'], @$this->lists['order'] ); ?>
				<?php if ($ordering) echo JHTML::_('grid.order',  $this->items ); ?>
			</th>
			<th width="1%" nowrap="nowrap">
				<?php echo JText::_('COM_DJCATALOG2_ID'); ?>
			</th>
		</tr>
	</thead>
	<tbody>
	<?php
	$k = 0; 
	$i = 0;
	$n = count( $this->items );
	$rows = &$this->items;
	foreach($this->items as $row)
	{
		//$row = &$this->items[$i];

		$link 	= JRoute::_( 'index.php?option=com_djcatalog2&task=editCategory&cid[]='. $row->id );

		$checked 	= JHTML::_('grid.id',   $i, $row->id );
		$published 	= JHTML::_('grid.published', $row, $i);

		?>
		<tr class="<?php echo "row$k"; ?>">
			<td>
				<?php echo $i + 1 + $this->pagination->limitstart;?>
			</td>
			<td>
				<?php echo $checked; ?>
			</td>
			<td align="center">
				<?php 
					$field_controller	= new DJCatalogImage();
					$images = $field_controller->getImages($row->image_url);
				?>
				<?php 
				if ($images) { ?><img src="<?php echo $images[0]['thumb']; ?>" alt="<?php echo $row->name; ?>" /><?php }
				else { ?><img src="<?php echo str_replace('/administrator', '', JURI::base()).'components/com_djcatalog2/theme/images/noimage.jpg'; ?>" alt="" /><?php }?>
			</td>
			<td>
				<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_DJCATALOG2_EDIT_CATEGORY_TOOLTIP' );?>::<?php echo $this->escape($row->name); ?>&lt;br&gt;&lt;br&gt;<img src=&quot;<?php echo $images[0]['thumb'];?>&quot;/>">
					<a href="<?php echo $link; ?>">
						<?php echo ($row->treename); ?></a></span>
			</td>
			<td align="center">
				<?php echo $published;?>
			</td>
			<td class="order" nowrap="nowrap">
				<span><?php echo $this->pagination->orderUpIcon( $i, $row->parent_id == 0 || $row->parent_id == @$rows[$i-1]->parent_id, 'orderup', 'Move Up', $ordering); ?></span>
				<span><?php echo $this->pagination->orderDownIcon( $i, $n, $row->parent_id == 0 || $row->parent_id == @$rows[$i+1]->parent_id, 'orderdown', 'Move Down', $ordering ); ?></span>
				<?php $disabled = $ordering ?  '' : 'disabled="disabled"'; ?>
				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" <?php echo $disabled ?> class="text_area" style="text-align: center" />
			</td>
			<td align="center">
				<?php echo $row->id; ?>
			</td>
		</tr>
		<?php
		$k = 1 - $k;
		 $i++;
	}
	?>
	</tbody>
	</table>
</div>

	<input type="hidden" name="option" value="com_djcatalog2" />
	<input type="hidden" name="view" value="categories" />
	<input type="hidden" name="task" value="showCategories" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php echo DJCATFOOTER; ?>