<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die( 'Restricted access' );

class TableItems extends JTable
{
	var $id = null;
	var $cat_id = null;
	var $producer_id = null;
	var $name = null;
	var $alias = null;
	var $description = null;
	var $intro_desc = null;
	var $price = 0;
	var $image_url = null;
	var $files_url = null;
	var $metakey = null;
	var $metadesc = null;
	var $published = null;
	var $ordering = null;
	var $params = null;

	function __construct(&$db)
	{
		parent::__construct( '#__djc2_items', 'id', $db );
	}
	function bind($array, $ignore = '')
	{	
		if (key_exists( 'params', $array ) && is_array( $array['params'] ))
		{
			$registry = new JRegistry();
			$registry->loadArray($array['params']);
			$array['params'] = $registry->toString();
		}
		
		if(empty($array['alias'])) {
			$array['alias'] = $array['name'];
		}
		$array['alias'] = JFilterOutput::stringURLSafe($array['alias']);
		if(trim(str_replace('-','',$array['alias'])) == '') {
			$datenow =& JFactory::getDate();
			$array['alias'] = $datenow->toFormat("%Y-%m-%d-%H-%M-%S");
		}
		
		return parent::bind($array, $ignore);
	}
}
?>