<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.helper');
jimport( 'joomla.application.component.model');


class DJCatalog2ModelProducers extends JModel {

	var $_list = null;
	var $_data = null;
	var $_pagination = null;
	var $_total = null;
	
	function __construct()
	{
		parent::__construct();
		global $option;
		
		$app =& JFactory::getApplication();
		
		$task = JRequest::getVar('task');
		
		$limit		= $app->getUserStateFromRequest( 'global.list.limit', 'limit', $app->getCfg('list_limit'), 'int' );
		$limitstart	= $app->getUserStateFromRequest( $option.$task.'.limitstart', 'limitstart', 0, 'int' );

		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
	}
	function getList()
	{
		if (empty($this->_list))
		{
			$query = $this->_buildQuery();
			$this->_list = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}

		return $this->_list;
	}
	function getPagination()
	{
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}
	function getTotal()
	{
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}
	function _buildQuery()
	{
		$where		= $this->_buildContentWhere();
		$orderby	= $this->_buildContentOrderBy();

		$query = ' SELECT i.* '
			. ' FROM #__djc2_producers AS i '
			. $where
			. $orderby
		;

		return $query;
	}
	function _buildContentOrderBy()
	{
		global $option;
		
		$app =& JFactory::getApplication();
		
		$task = JRequest::getVar('task');

		$filter_order		= $app->getUserStateFromRequest( $option.$task.'filter_order',		'filter_order',		'i.ordering',	'cmd' );
		$filter_order_Dir	= $app->getUserStateFromRequest( $option.$task.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );

		if ($filter_order == 'i.ordering'){
			$orderby 	= ' ORDER BY i.ordering '.$filter_order_Dir;
		} else {
			$orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir.' , i.ordering ';
		}

		return $orderby;
	}

	function _buildContentWhere()
	{
		global $option;
		
		$app =& JFactory::getApplication();
		
		$task = JRequest::getVar('task');
		$db					=& JFactory::getDBO();
		$filter_state		= $app->getUserStateFromRequest( $option.$task.'filter_state',		'filter_state',		'',				'word' );
		$filter_order		= $app->getUserStateFromRequest( $option.$task.'filter_order',		'filter_order',		'i.ordering',	'cmd' );
		$filter_order_Dir	= $app->getUserStateFromRequest( $option.$task.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		$search				= $app->getUserStateFromRequest( $option.$task.'search',			'search',			'',				'string' );
		$search				= JString::strtolower( $search );

		$where = array();

		if ($search) {
			$where[] = 'LOWER(i.name) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		}
		if ( $filter_state ) {
			if ( $filter_state == 'P' ) {
				$where[] = 'i.published = 1';
			} else if ($filter_state == 'U' ) {
				$where[] = 'i.published = 0';
			}
		}

		$where 		= ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );

		return $where;
	}
	function publish($cid = array(), $publish = 1)
	{
		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );

			$query = 'UPDATE #__djc2_producers '
				. ' SET published = '.(int) $publish
				. ' WHERE id IN ( '.$cids.' )'
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}	
		return true;
	}
	function move($direction)
	{
		$row =& $this->getTable();
		$array = JRequest::getVar('cid', array(0), '', 'array');
		$id = ((int)$array[0]);
		
		if (!$row->load($id)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->move( $direction)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		return true;
	}
	function saveorder($cid = array(), $order)
	{
		$row =& $this->getTable();

		for( $i=0; $i < count($cid); $i++ )
		{
			$row->load( (int) $cid[$i] );
			echo'<pre>';print_r($row);echo '</pre><hr />';
			if ($row->ordering != $order[$i])
			{
				$row->ordering = $order[$i];
				
				if (!$row->store(false)) {
					$this->setError($this->_db->getErrorMsg());
					return false;
				}
				echo'<pre>';print_r($row);echo '</pre><hr />';
			}
		}
		$row->reorder();
		echo'<hr /><pre>';print_r($row);echo '</pre>';

		return true;
	}
	function delete($cid = array())
	{
		if (count( $cid ))
		{
			$cids = implode(',', $cid);
			
			$this->_db->setQuery("SELECT COUNT(*) FROM #__djc2_items WHERE producer_id IN ( ".$cids." )");
			if ($this->_db->loadResult() > 0) {
				$this->setError(JText::_('Cannot delete selected Producer(s)'));
				return false;
			}
			
			$query = "SELECT image_url FROM #__djc2_producers WHERE id IN ( ".$cids." )";
			$this->_db->setQuery($query);
			$rows = $this->_db->loadObjectList();
			foreach($rows as $row) {
				$field_controllerImage	= new DJCatalogImage();
				$field_controllerImage->prepareToDelete($row->image_url);
			}
			
	        $query = "DELETE FROM #__djc2_producers WHERE id IN ( ".$cids." )";
	        $this->_db->setQuery($query);
	        if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}	
		return true;
	}
	function &getData()
	{
		if (!$this->_loadData()) {
			$this->_initData();
		}
		return $this->_data;
	}
	function _loadData() {
		if (empty($this->_data))
		{
			$array = JRequest::getVar('cid', array(0), '', 'array');
			$edit	= JRequest::getVar('edit',true);
			if($edit) {
				$id = (int)$array[0];
				$query = 'SELECT * '.
						' FROM #__djc2_producers ' .
						' WHERE id = '.(int)$id;
				$this->_db->setQuery($query);
				$this->_data = $this->_db->loadObject();
			}
			return (boolean) $this->_data;
		}
		return true;
	}
	function _initData()
	{
		if (empty($this->_data))
		{
			$producer = new stdClass();
			$producer->id = 0;
			$producer->name = null;
			$producer->alias = null;
			$producer->description = null;
			$producer->image_url = null;
			$producer->published = 1;
			$producer->ordering = 0;
			$this->_data = $producer;
			return (boolean) $this->_data;
		}
		return true;
	}
	function store($data)
	{
		$fieldImage = new stdClass;
		$fieldImage->name = 'image_url';
		$fieldImage->value = $data['image_url'];
		
		$field_controllerImage	= new DJCatalogImage();
		$params = &JComponentHelper::getParams( 'com_djcatalog2' );
		$valueImage = null;
		$field_controllerImage->prepareToSave($valueImage, $fieldImage, $params);
		$data['image_url'] = $valueImage;
		
		$row =& $this->getTable();

		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		if (!$row->id) {
			$row->ordering = $row->getNextOrder();
		}

		if (!$row->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return true;
	}
	function recreateThumbnails($cid = array())
	{
		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );

			$query = 'SELECT image_url FROM #__djc2_producers'
				. ' WHERE id IN ( '.$cids.' )'
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
			$items = $this->_db->loadObjectList();
			$path = JPATH_SITE.DS.'images'.DS.'djcatalog';
			$params = &JComponentHelper::getParams( 'com_djcatalog2' );
			$imageProcessor	= new DJCatalogImage();
			
			foreach($items as $item) {
				$images = explode(';',$item->image_url);
				foreach($images as $filename) {
					$imageProcessor->processImages($path, $filename, $params);
				}
			}
		}	
		return true;
	}
}
?>
