<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.helper');
jimport( 'joomla.application.component.model');


class DJCatalog2ModelCategories extends JModel {

	var $_list = null;
	var $_data = null;
	var $_pagination = null;
	var $_total = null;
	
	function __construct()
	{
		parent::__construct();
	}
	function getList($type = 0)
	{
		global $option;
		
		$app =& JFactory::getApplication();
		
		if (!empty($this->_list)) {
			return $this->_list;
		}
		$task = JRequest::getVar('task');
		$filter_order		= $app->getUserStateFromRequest( $option.$task.'filter_order',		'filter_order',		'ordering',	'cmd' );
		$filter_order_Dir	= $app->getUserStateFromRequest( $option.$task.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		
		if ($filter_order) {
			$orderby = ' ORDER BY '.$filter_order .' '. $filter_order_Dir .', parent_id, ordering';
		} else {
			$orderby = ' ORDER BY parent_id, ordering';
		}
		
		
		$db		=& $this->getDBO();
		$query = "SELECT * "
				."FROM #__djc2_categories "
				.$orderby;
				
		$db->setQuery($query);
		$list = $db->loadObjectList();
		
		// If there is a db query error, throw a HTTP 500 and exit
		if ($db->getErrorNum()) {
			JError::raiseError( 500, $db->stderr() );
			return false;
		}
		
		/*$tree = new CatTree();
		$tree->buildTree($list);
		$root=&$tree->getRoot();
		getCategoryList($root, $this->_list);
		*/
		
		$rows = $db->loadObjectList();

		// establish the hierarchy of the menu
		$children = array();
		// first pass - collect children
		foreach ($rows as $v )
		{
			$pt = $v->parent_id;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
		// second pass - get an indent list of the items
		$list = treerecurse(0, '', array(), $children, 100,0,$type);
		
		jimport('joomla.html.pagination');
		$this->_pagination = new JPagination( $this->getTotal(), 1, 0 );
		
		$list = array_slice( $list, $this->_pagination->limitstart, $this->_pagination->limit );
		
		$this->_list = $list;
		
		return $this->_list;
	}
	function getPagination()
	{
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), 1, 0);
		}

		return $this->_pagination;
	}
	function getTotal() {
		if (empty($this->_total)) {
			$this->_db->setQuery("SELECT COUNT(*) FROM #__djc2_categories");
			$this->_total = $this->_db->loadResult();
		}
		return $this->_total;
	}
	function publish($cid = array(), $publish = 1)
	{
		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );

			$query = 'UPDATE #__djc2_categories'
				. ' SET published = '.(int) $publish
				. ' WHERE id IN ( '.$cids.' )'
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}	
		return true;
	}
	function move($direction)
	{
		$row =& $this->getTable();
		$array = JRequest::getVar('cid', array(0), '', 'array');
		$id = ((int)$array[0]);
		
		if (!$row->load($id)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->move( $direction, ' parent_id = '.(int) $row->parent_id )) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		return true;
	}
	function saveorder($cid = array(), $order)
	{
		$row =& $this->getTable();
		$groupings = array();

		for( $i=0; $i < count($cid); $i++ )
		{
			$row->load( (int) $cid[$i] );
			$groupings[] = $row->parent_id;

			if ($row->ordering != $order[$i])
			{
				$row->ordering = $order[$i];
				if (!$row->store()) {
					$this->setError($this->_db->getErrorMsg());
					return false;
				}
			}
		}

		$groupings = array_unique( $groupings );
		foreach ($groupings as $group){
			$row->reorder('parent_id = '.(int) $group);
		}

		return true;
	}
	function delete($cid = array())
	{
		if (count( $cid ))
		{
			$this->_db->setQuery("SELECT * FROM #__djc2_categories");
			$catlist = $this->_db->loadObjectList();
	    	$tree = new CatTree();
			$tree->buildTree($catlist);
	    	$root = &$tree->getRoot();
			$categoryList = array();
			foreach($cid as $catid){
				$newList = getChildrenList($root,$catid);
				$categoryList = array_merge($categoryList, $newList);
			}
			$categoryList = array_unique($categoryList);
			$cids = implode(',', $categoryList);
			
			$this->_db->setQuery("SELECT COUNT(*) FROM #__djc2_items WHERE cat_id IN ( ".$cids." )");
			if ($this->_db->loadResult() > 0) {
				$this->setError(JText::_('Cannot delete selected Category(s)'));
				return false;
			}
			
			$query = "SELECT image_url FROM #__djc2_categories WHERE id IN ( ".$cids." )";
			$this->_db->setQuery($query);
			$rows = $this->_db->loadObjectList();
			foreach($rows as $row) {
				$field_controllerImage	= new DJCatalogImage();
				$field_controllerImage->prepareToDelete($row->image_url);
			}
			
	        $query = "DELETE FROM #__djc2_categories WHERE id IN ( ".$cids." )";
	        $this->_db->setQuery($query);
	        if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}	
		return true;
	}
	function &getData()
	{
		if (!$this->_loadData()) {
			$this->_initData();
		}
		return $this->_data;
	}
	function _loadData() {
		if (empty($this->_data))
		{
			$array = JRequest::getVar('cid', array(0), '', 'array');
			$edit	= JRequest::getVar('edit',true);
			if($edit) {
				$id = (int)$array[0];
				$query = 'SELECT * '.
						' FROM #__djc2_categories ' .
						' WHERE id = '.(int)$id;
				$this->_db->setQuery($query);
				$this->_data = $this->_db->loadObject();
			}
			return (boolean) $this->_data;
		}
		return true;
	}
	function _initData()
	{
		if (empty($this->_data))
		{
			$category = new stdClass();
			$category->id = 0;
			$category->parent_id = null;
			$category->name = null;
			$category->alias = null;
			$category->description = null;
			$category->image_url = null;
			$category->published = 1;
			$category->ordering = 0;
			$this->_data = $category;
			return (boolean) $this->_data;
		}
		return true;
	}
	function store($data)
	{
		$fieldImage = new stdClass;
		$fieldImage->name = 'image_url';
		$fieldImage->value = $data['image_url'];
		
		$field_controllerImage	= new DJCatalogImage();
		$params = &JComponentHelper::getParams( 'com_djcatalog2' );
		$valueImage = null;
		$field_controllerImage->prepareToSave($valueImage, $fieldImage, $params);
		$data['image_url'] = $valueImage;
		$row =& $this->getTable();

		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		if (!$row->id) {
			$where = 'parent_id = ' . (int) $row->parent_id ;
			$row->ordering = $row->getNextOrder( $where );
		}

		if (!$row->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		$this->_data = $row;
		return true;
	}
	function recreateThumbnails($cid = array())
	{
		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );

			$query = 'SELECT image_url FROM #__djc2_categories'
				. ' WHERE id IN ( '.$cids.' )'
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
			$items = $this->_db->loadObjectList();
			$path = JPATH_SITE.DS.'images'.DS.'djcatalog';
			$params = &JComponentHelper::getParams( 'com_djcatalog2' );
			$imageProcessor	= new DJCatalogImage();
			
			foreach($items as $item) {
				$images = explode(';',$item->image_url);
				foreach($images as $filename) {
					$imageProcessor->processImages($path, $filename, $params);
				}
			}
		}	
		return true;
	}
}
?>
