<?php 
/**
 * @version 2.1
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://design-joomla.eu
 * @author email contact@design-joomla.eu
 * @developer Michal Olczyk - michal.olczyk@design-joomla.eu
 *
 *
 * DJ-Catalog2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-Catalog2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
 *
 */
 
defined('_JEXEC') or die('Restricted access');
JHTML::_('behavior.modal');
class DJCatalogImage {
    function renderInput($field, $label) {
        $out = '<td align="right" class="key">'.$label.'</td>'.'<td>';
        $path = str_replace('/administrator', '', JURI::base()).'images/djcatalog/';
        if ($field->value) {
            $images = explode(";", $field->value);
            $order = 1;
            foreach ($images as $image) {
                if ($image && $image != '') {
                    $out .= '<div><input type="text" name="order_'.$field->name.'[]" value="'.$order.'" class="text_area" size="5" style="margin-bottom: 4px;"/><br />'.'<a class="modal" href="'.$path.$image.'">'.'<img src="'.$path.$this->_getFileNoExt($image).'_s.'.end(explode(".", $image)).'" alt="'.$image.'"/>'.'</a></div>'.'<div><input type="checkbox" name="delete_'.$field->name.'[]" value="'.$image.'" />'.JText::_('COM_DJCATALOG2_CHECK_TO_DELETE').' <strong>'.$image.'</strong></div><br />';
                    $order++;
                }
            }
        } else {
            $out .= JText::_('COM_DJCATALOG2_NO_IMAGES_INCLUDED').'<br />';
        }
        $out .= '<div id="uploader_'.$field->name.'"><input type="file" name="file_'.$field->name.'[]" />'.'</div><br/><a href="#" onclick="addImage_'.$field->name.'(); return false;" >'.JText::_('COM_DJCATALOG2_ADD_IMG_LINK').'</a>';
        $out .= '<script type="text/javascript">'.'function addImage_'.$field->name.'(){'.'var inputdiv = document.createElement(\'input\');'.'inputdiv.setAttribute(\'name\',\'file_'.$field->name.'[]\');'.'inputdiv.setAttribute(\'type\',\'file\');'.'var ni = $(\'uploader_'.$field->name.'\');'.'ni.appendChild(document.createElement(\'br\'));'.'ni.appendChild(inputdiv);'.'}'.'</script>';
        
        $out .= '</td>';
        
        return $out;
    }
    
    function prepareToSave(&$value, $field, $params) {
        $value = $field->value;
        $imagesToSaveTemp = ($field->value != '') ? explode(';', $field->value) : array();
        if ($n = count($imagesToSaveTemp)) {
            $order = JRequest::getVar('order_'.$field->name, array(), 'post', 'array');
            $orderedImages = array();
            if (count($order == $n)) {
                for ($i = 0; $i < $n; $i++) {
                    $img = new stdClass ();
                    $img->order = intval($order[$i]);
                    $img->src = $imagesToSaveTemp[$i];
                    $orderedImages[] = $img;
                }
                usort($orderedImages, array($this, '_orderImages'));
                $imagesToSaveTemp = array();
                foreach ($orderedImages as $orderedImage) {
                    $imagesToSaveTemp[] = $orderedImage->src;
                }
            }
        }
        $imagesToSave = array();
        // fixing errors from previous version of djcatalog :)
        foreach ($imagesToSaveTemp as $temp)
            if ($temp && $temp != '')
                $imagesToSave[] = $temp;
        // if file checked to be deleted...
        $fieldsToDeleteArray = JRequest::getVar('delete_'.$field->name, array(), 'post', 'array');
        $fieldsToDelete = implode(';', $fieldsToDeleteArray);
        $this->prepareToDelete($fieldsToDelete);
        foreach ($fieldsToDeleteArray as $fieldToDelete) {
            foreach ($imagesToSave as $key=>$image) {
                if ($image == $fieldToDelete)
                    unset($imagesToSave[$key]);
            }
        }
        
        $file = JRequest::get('files');
        
        $path = JPATH_SITE.DS.'images'.DS.'djcatalog';
        
        if (!file_exists($path) || !is_dir($path)) {
            if (!mkdir($path))
                return;
        }
        
        for ($i = 0; $i < count($file['file_'.$field->name]['name']); $i++) {
            if ($file['file_'.$field->name]['name'][$i] && substr($file['file_'.$field->name]['type'][$i], 0, 5) == "image") {
            
                $filename = strtolower($file['file_'.$field->name]['name'][$i]);
                if (file_exists($path.DS.$filename)) {
                    $filename = date('Ymd_His', time()).'_'.$filename;
                }
                $tmp_path = $file['file_'.$field->name]['tmp_name'][$i];
                
                move_uploaded_file($tmp_path, $path.DS.$filename);
                $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_s', 75, 45, true);
                if ($this->processImages($path, $filename, $params)) {
                    $imagesToSave[] = $filename;
                }
                
            }
        }
        $value = implode(';', $imagesToSave);
    }
    function processImages($path, $filename, $params) {
        $resize = intval($params->get('resize', 0));
        
        $width = $params->get('width', 303);
        $height = $params->get('height', 226);
        
        $medium_width = $params->get('th_width', 150);
        $medium_height = $params->get('th_height', 110);
        
        $small_width = $params->get('smallth_width', 75);
        $small_height = $params->get('smallth_height', 55);
        
        if (file_exists($path.DS.$this->_getFileNoExt($filename).'_s.'.end(explode(".", $filename)))) {
            unlink($path.DS.$this->_getFileNoExt($filename).'_s.'.end(explode(".", $filename)));
        }
        $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_s', 75, 45, true);
        
        if (file_exists($path.DS.$this->_getFileNoExt($filename).'_t.'.end(explode(".", $filename)))) {
            unlink($path.DS.$this->_getFileNoExt($filename).'_t.'.end(explode(".", $filename)));
        }
        
        if (file_exists($path.DS.$this->_getFileNoExt($filename).'_l.'.end(explode(".", $filename)))) {
            unlink($path.DS.$this->_getFileNoExt($filename).'_l.'.end(explode(".", $filename)));
        }
        
        if (file_exists($path.DS.$this->_getFileNoExt($filename).'_m.'.end(explode(".", $filename)))) {
            unlink($path.DS.$this->_getFileNoExt($filename).'_m.'.end(explode(".", $filename)));
        }
        switch ($resize) {
            case 1: {
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_l', $width, 0);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_m', $medium_width, 0);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_t', $small_width, 0);
                    break;
                }
                
            case 2: {
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_l', 0, $height);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_m', 0, $medium_height);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_t', 0, $small_height);
                    break;
                }
                
            case 3: {
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_l', $width, $height);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_m', $medium_width, $medium_height);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_t', $small_width, $small_height);
                    break;
                }
            case 4: {
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_l', $width, $height, true);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_m', $medium_width, $medium_height, true);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_t', $small_width, $small_height, true);
                    break;
                }
                
            case 0:
            default: {
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_l', $width, $height, true);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_m', $medium_width, $medium_height, true);
                    $this->_resizeImage($path.DS.$filename, $path.DS.$this->_getFileNoExt($filename).'_t', $small_width, $small_height, true);
                    break;
                }
        }
        
        return true;
    }
    function prepareToDelete($field) {
        if ($field) {
            $path = JPATH_SITE.DS.'images'.DS.'djcatalog';
            $images = explode(';', $field);
            
            foreach ($images as $image) {
                if (file_exists($path.DS.$image))
                    unlink($path.DS.$image);
                    
                if (file_exists($path.DS.$this->_getFileNoExt($image).'_l.'.end(explode(".", $image))))
                    unlink($path.DS.$this->_getFileNoExt($image).'_l.'.end(explode(".", $image)));
                    
                if (file_exists($path.DS.$this->_getFileNoExt($image).'_t.'.end(explode(".", $image))))
                    unlink($path.DS.$this->_getFileNoExt($image).'_t.'.end(explode(".", $image)));
                    
                if (file_exists($path.DS.$this->_getFileNoExt($image).'_s.'.end(explode(".", $image))))
                    unlink($path.DS.$this->_getFileNoExt($image).'_s.'.end(explode(".", $image)));
                    
                if (file_exists($path.DS.$this->_getFileNoExt($image).'_m.'.end(explode(".", $image))))
                    unlink($path.DS.$this->_getFileNoExt($image).'_m.'.end(explode(".", $image)));
            }
        }
    }
    
    function _getFileNoExt($filename) {
        $fileParts = preg_split("/\./", $filename);
        $fileNoExt = '';
        for ($i = 0; $i < count($fileParts) - 1; $i++)
            $fileNoExt .= $fileParts[$i];
        return $fileNoExt;
    }
    function _resizeImage($path, $newpath, $nw = 0, $nh = 0, $keep_ratio = false) {
    
        if (!$path || !$newpath)
            return false;
        if (!list($w, $h, $type, $attr) = getimagesize($path)) {
            return false;
        }
        $ext = '';
        
        $OldImage = null;
        
        switch ($type) {
            case 1:
                $OldImage = imagecreatefromgif($path);
                $ext = 'gif';
                break;
            case 2:
                $OldImage = imagecreatefromjpeg($path);
                $ext = 'jpg';
                break;
            case 3:
                $OldImage = imagecreatefrompng($path);
                $ext = 'png';
                break;
            default:
                return false;
                break;
        }
        
        if ($nw == 0 && $nh == 0) {
            $nw = 75;
            $nh = (int) (floor(($nw * $h) / $w));
        } elseif ($nw == 0) {
            $nw = (int) (floor(($nh * $w) / $h));
        } elseif ($nh == 0) {
            $nh = (int) (floor(($nw * $h) / $w));
        }
        if ($keep_ratio) {
            $x_ratio = $nw / $w;
            $y_ratio = $nh / $h;
            
            if (($x_ratio * $h) < $nh) {
                $nh = ceil($x_ratio * $h);
            } else {
                $nw = ceil($y_ratio * $w);
            }
        }
        
        // check if ratios match
        $_ratio = array($w / $h, $nw / $nh);
        if ($_ratio[0] != $_ratio[1]) { // crop image
        
            // find the right scale to use
            $_scale = min((float) ($w / $nw), (float) ($h / $nh));
            
            // coords to crop
            $cropX = (float) ($w - ($_scale * $nw));
            $cropY = (float) ($h - ($_scale * $nh));
            
            // cropped image size
            $cropW = (float) ($w - $cropX);
            $cropH = (float) ($h - $cropY);
            
            $crop = ImageCreateTrueColor($cropW, $cropH);
            if ($type == 3 || $type == 1) {
                imagecolortransparent($crop, imagecolorallocate($crop, 0, 0, 0));
                imagealphablending($crop, false);
                imagesavealpha($crop, true);
            }
            // crop the middle part of the image to fit proportions
            ImageCopy($crop, $OldImage, 0, 0, (int) ($cropX / 2), (int) ($cropY / 2), $cropW, $cropH);
        }
        
        // do the thumbnail
        $NewThumb = ImageCreateTrueColor($nw, $nh);
        if ($type == 3 || $type == 1) {
            imagecolortransparent($NewThumb, imagecolorallocate($NewThumb, 0, 0, 0));
            imagealphablending($NewThumb, false);
            imagesavealpha($NewThumb, true);
        }
        if (isset($crop)) { // been cropped
            ImageCopyResampled($NewThumb, $crop, 0, 0, 0, 0, $nw, $nh, $cropW, $cropH);
            ImageDestroy($crop);
        } else { // ratio match, regular resize
            ImageCopyResampled($NewThumb, $OldImage, 0, 0, 0, 0, $nw, $nh, $w, $h);
        }
        
        $thumb_path = $newpath.'.'.$ext;
        if (is_file($thumb_path))
            unlink($thumb_path);
        switch ($type) {
            case 1:
                imagegif($NewThumb, $thumb_path);
                break;
            case 2:
                imagejpeg($NewThumb, $thumb_path, 85);
                break;
            case 3:
                imagepng($NewThumb, $thumb_path);
                break;
        }
        
        ImageDestroy($NewThumb);
        ImageDestroy($OldImage);
        
        return true;
    }
    function _orderImages($img1, $img2) {
        return (int) ($img1->order - $img2->order);
    }
    function getImages($field) {
        if ($field) {
            $path = str_replace('/administrator', '', JURI::base()).'images/djcatalog';
            $names = explode(';', $field);
            $images = array();
            
            foreach ($names as $filename) {
                $images[] = array('original'=>$path.'/'.$filename, 'large'=>$path.'/'.$this->_getFileNoExt($filename).'_l.'.end(explode(".", $filename)), 'medium'=>$path.'/'.$this->_getFileNoExt($filename).'_m.'.end(explode(".", $filename)), 'small'=>$path.'/'.$this->_getFileNoExt($filename).'_t.'.end(explode(".", $filename)), 'thumb'=>$path.'/'.$this->_getFileNoExt($filename).'_s.'.end(explode(".", $filename)));
            }
            return $images;
        } else
            return false;
    }
}
?>
