<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die('Restricted access');
    class DJCatalogFile {
    	function renderInput($field,$label) {
			$out = '<td align="right" class="key">'.$label.'</td>'
					. '<td>';
			$path = str_replace('/administrator', '', JURI::base()).'media/djcatalog/';
			if ($field->value) {
				$files = explode(";",$field->value);
				$order = 1;
				foreach ($files as $file) {
					if ($file && $file != '') {
						$out .= '<div><input type="text" name="order_'.$field->name.'[]" value="'.$order.'" class="text_area" size="5" style="margin-bottom: 4px;"/><br /><a target="_blank" href="'.$path.$file.'">['.strtoupper(end(explode(".", $file))).'] '.$file.'</a></div>'
								. '<div><input type="checkbox" name="delete_'.$field->name.'[]" value="'.$file.'" />'.JText::_('COM_DJCATALOG2_CHECK_TO_DELETE').' <strong>'.$file.'</strong></div><br />';
						$order++;
					}
				}
			}
			else {
				$out .= JText::_('COM_DJCATALOG2_NO_FILES_INCLUDED').'<br />';
			}
			$out .= '<div id="uploader_'.$field->name.'"><input type="file"  name="file_'.$field->name.'[]" />'
					.'</div><br/><a href="#" onclick="addFile_'.$field->name.'(); return false;" >'.JText::_('COM_DJCATALOG2_ADD_FILE_LINK').'</a>';
			$out .= '<script type="text/javascript">'
					.'function addFile_'.$field->name.'(){'
					.'var inputdiv = document.createElement(\'input\');'
					.'inputdiv.setAttribute(\'name\',\'file_'.$field->name.'[]\');'
					.'inputdiv.setAttribute(\'type\',\'file\');'
					.'var ni = $(\'uploader_'.$field->name.'\');'
					.'ni.appendChild(document.createElement(\'br\'));'
					.'ni.appendChild(inputdiv);'
					.'}'
					.'</script>';
			
			$out .= '</td>';
			
			return $out;
    	}
		
		function prepareToSave(&$value, $field, $params) {
			$value = $field->value;
			$filesToSaveTemp = ($field->value != '') ? explode(';', $field->value) : array();
			if ($n = count($filesToSaveTemp)) {
				$order = JRequest::getVar( 'order_'.$field->name, array(), 'post', 'array' );
				$orderedFiles = array();
				if (count($order == $n)) {
					for($i = 0; $i < $n; $i++) {
						$file = new stdClass();
						$file->order = intval($order[$i]);
						$file->src = $filesToSaveTemp[$i];
						$orderedFiles[] = $file;
					}
					usort($orderedFiles, array($this, '_orderFiles'));
					$filesToSaveTemp = array();
					foreach($orderedFiles as $orderedFile) {
						$filesToSaveTemp[] = $orderedFile->src;
					}
				}
			}
			$filesToSave = array();
			// fixing errors from previous version of djcatalog :)
			foreach ($filesToSaveTemp as $temp)
					if ($temp && $temp != '')
						$filesToSave[] = $temp;
			// if file checked to be deleted...
			$fieldsToDeleteArray = JRequest::getVar( 'delete_'.$field->name, array(), 'post', 'array' );
			$fieldsToDelete	= implode(';',$fieldsToDeleteArray);
			$this->prepareToDelete($fieldsToDelete);
			foreach($fieldsToDeleteArray as $fieldToDelete) {
				foreach($filesToSave as $key => $file) {
					if ($file == $fieldToDelete)
						unset($filesToSave[$key]);
				}
			}
			$file = null;
			$file = JRequest::get('files');
			for ($i = 0; $i < count($file['file_'.$field->name]['name']); $i++) {
				if ($file['file_'.$field->name]['name'][$i]) { 
					$path = JPATH_SITE.DS.'media'.DS.'djcatalog';
					
					if (!file_exists($path) || !is_dir($path)) {
						if (!mkdir($path))
							return;
					}
					$filename = $file['file_'.$field->name]['name'][$i];
					if (file_exists($path.DS.$filename)) {
						$filename = date('Ymd_His', time()).'_'.$filename;
					}
					$tmp_path = $file['file_'.$field->name]['tmp_name'][$i];
					
					move_uploaded_file($tmp_path, $path.DS.$filename);
					$filesToSave[] = $filename;
				}
			}
			$value = implode(';',$filesToSave);
		}
		function prepareToDelete($field) {
			if ($field) {
				$path = JPATH_SITE.DS.'media'.DS.'djcatalog';
				$files = explode(';',$field);
				
				foreach($files as $file){
					if (file_exists($path.DS.$file))
						unlink($path.DS.$file);
				}
			}
		}
		
		function _getFileNoExt($filename) {
			$fileParts = preg_split("/\./", $filename);
			$fileNoExt ='';
			for ($i = 0; $i < count($fileParts)-1; $i++) 
				$fileNoExt .= $fileParts[$i];
			return $fileNoExt;
		}
		function getFiles($field) {
			if ($field) {
			$path = str_replace('/administrator', '', JURI::base()).'media/djcatalog';
			$names = explode(';',$field);
			$files = array();
			
			foreach($names as $filename) {
				$files[] = array (
							'path' => $path.'/'.$filename,
							'name' => $filename
							);
			}
			return $files;
			}
			else return false;
		}
		function _orderFiles($file1, $file2){
			return (int)($file1->order - $file2->order);
		}
    }
?>
