<?php 
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

class Category
{
    var $id;
    var $name;
	var $alias;
    var $parent_id;
    var $published;
    var $children;

    function __construct()
    {
        $this->id = 0;
        $this->name = '';
		$this->alias = '';
        $this->parent_id = null;
        $this->published = 1;
        $this->children = array ();
    }
    function Category()
    {
        $this->__construct();
    }

    function setCategory($id, $name, $alias, $parent_id, $published = 0)
    {
        $this->id = $id;
        $this->name = $name;
		$this->alias = $alias;
        $this->parent_id = $parent_id;
        $this->published = $published;
    }
    function getChildren()
    {
        return $this->children;
    }
}

class CatTree
{
    var $node;

    function __construct()
    {
        $this->node = new Category();
    }

    function CatTree()
    {
        $this->__construct();
    }

    function setCatTree( & $category)
    {
        $this->node = $category;
    }

    function addChild(&$child)
    {
        $this->node->children[$child->id] = $child;
    }

    function & getRoot()
    {
        return $this->node;
    }

    function buildTree( $categoryList)
    {
        if (is_null($categoryList)) return;
        foreach ($categoryList as $category)
        {
            if ($this->node->id == $category->parent_id)
            {
                $newCategory = new Category();
                $newCategory->setCategory($category->id, $category->name, $category->alias, $category->parent_id, $category->published);
                $newNode = new CatTree();
                $newNode->setCatTree($newCategory);
                //$this->addChild($newCategory);
                $newNode->buildTree($categoryList);
				$this->addChild($newNode->node);
            }
        }
    }
}

class DjOptionCategory
{
    var $text;
    var $value;
    var $disable;

    function __construct()
    {
        $text = null;
        $value = null;
        $disable = null;
    }
    function DjOptionCategory()
    {
        $this->__construct();
    }
}

function getCategoryList( & $root,&$categoryList, $level = 0, $position = 0)
{
    $children = $root->getChildren();
    foreach ($children as $category)
    {
        $catprefix = '';
        for ($i = 0; $i < $level; $i++)
        $catprefix .= ' - ';
		
		$newcategory = new stdClass();
		$newcategory->id = $category->id;
		$newcategory->parent_id = $category->parent_id;
		$newcategory->name = $catprefix.$category->name;
		$newcategory->published = $category->published;
		
		$categoryList[] = $newcategory;
		$position++;
		getCategoryList($category, $categoryList, $level+1, $position);
	}
	return true;
}
function renderOptionList( & $root)
{
    $optionList[0] = JHTML::_('select.option', '0', JText::_('COM_DJCATALOG2_SELECT_ROOT_CAT'));
    getOptionList($root, $optionList);
    return $optionList;
}
function getOptionList( & $root, & $optionList, $level = 0)
{
    $children = $root->getChildren();
    foreach ($children as $category)
    {
        $catprefix = '';
        for ($i = 0; $i < $level; $i++)
        $catprefix .= ' - ';
        $category->name = $catprefix.$category->name;
        $option = new DjOptionCategory();
        $option->value = $category->id;
        $option->text = $category->name;
        $option->disable = null;
        $optionList[] = $option;
        getOptionList($category, $optionList, $level+1);
    }
}
function renderCategoryFilter( & $root)
{
    $optionList[0] = JHTML::_('select.option', '0', '- '.JText::_('COM_DJCATALOG2_SELECT_CATEGORY').' -');
    getOptionList($root, $optionList);
    return $optionList;
}

function getChildrenList( & $root, $catid)
{
    $children = $root->getChildren();
	$childrenList = array();
	$found = false;
    if ( isset ($children[$catid]))
    {
		$childrenList[] = $catid;
        buildChildrenList($children[$catid], $childrenList);
		return $childrenList;
    }
    else
    {
        foreach ($children as $category)
        {
			$childrenList = getChildrenList($category, $catid);
			if (isset($childrenList)) {
				$found = true;
				break;
			}
        }
    }
	if ($found) return $childrenList;
}

function buildChildrenList(&$root, &$childrenList) {
	$children = $root->getChildren(); 
	
	foreach ($children as $id => $category) {
		$childrenList[] = $id;
		buildChildrenList($category, $childrenList);
	}
}

function treerecurse( $id, $indent, $list, &$children, $maxlevel=9999, $level=0, $type=1 )
	{
		if (@$children[$id] && $level <= $maxlevel)
		{
			foreach ($children[$id] as $v)
			{
				$id = $v->id;

				if ( $type ) {
					$pre 	= '<sup>|_</sup>&nbsp;';
					$spacer = '.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				} else {
					$pre 	= '- ';
					$spacer = '&nbsp;&nbsp;';
				}

				if ( $v->parent_id == 0 ) {
					$txt 	= $v->name;
				} else {
					$txt 	= $pre . $v->name;
				}
				$pt = $v->parent_id;
				$list[$id] = $v;
				$list[$id]->treename = "$indent$txt";
				$list[$id]->children = count( @$children[$id] );
				$list = treerecurse( $id, $indent . $spacer, $list, $children, $maxlevel, $level+1, $type );
			}
		}
		return $list;
	}
