<?php
/**
* @version 2.1
* @package DJ-Catalog2
* @copyright Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.
* @license http://www.gnu.org/licenses GNU/GPL
* @author url: http://design-joomla.eu
* @author email contact@design-joomla.eu
* @developer Michal Olczyk - michal.olczyk@design-joomla.eu
*
*
* DJ-Catalog2 is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* DJ-Catalog2 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
*
*/

defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class DJCatalog2Controller extends JController
{
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask('addCategory', 'editCategory');
		$this->registerTask('addItem', 'editItem');
		$this->registerTask('addProducer', 'editProducer');
	}

	function display( ) {
		JRequest::setVar( 'layout', 'default'  );
		JRequest::setVar( 'view'  , 'cpanel');
		JRequest::setVar( 'edit', false );
		parent::display();
	}
	function cpanel() {
		JRequest::setVar( 'layout', 'default'  );
		JRequest::setVar( 'view'  , 'cpanel');
		JRequest::setVar( 'edit', false );
		parent::display();
	}
	function unpublish() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'categories': $this->unpublishCategory(); break;
			case 'items': $this->unpublishItem(); break;
			case 'producers': $this->unpublishProducer(); break;
			case 'default': break;
		}
	}
	function publish() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'categories': $this->publishCategory(); break;
			case 'items': $this->publishItem(); break;
			case 'producers': $this->publishProducer(); break;
			case 'default': break;
		}
	}
	function cancel() {
		$view = JRequest::getVar('view');
		$link = 'index.php?option=com_djcatalog2&task=';
		switch ($view) {
			case 'categories': $link .= 'showCategories'; break;
			case 'items': $link .= 'showItems'; break;
			case 'producers': $link .= 'showProducers'; break;
			case 'default': break;
		}
		$this->setRedirect($link);
	}
	function apply() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'items': $this->saveItem(); break;
			case 'categories': $this->saveCategory(); break;
			case 'producers': $this->saveProducer(); break;
			case 'default': break;
		}
	}
	function orderup() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'items': $this->orderupItem(); break;
			case 'categories': $this->orderupCategory(); break;
			case 'producers': $this->orderupProducer(); break;
			case 'default': break;
		}
	}
	function orderdown() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'items': $this->orderdownItem(); break;
			case 'categories': $this->orderdownCategory(); break;
			case 'producers': $this->orderdownProducer(); break;
			case 'default': break;
		}
	}
	function saveorder()
	{
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'items': $this->saveorderItem(); break;
			case 'categories': $this->saveorderCategory(); break;
			case 'producers': $this->saveorderProducer(); break;
			case 'default': break;
		}
	}
	function recreateThumbnails() {
		$view = JRequest::getVar('view');
		switch ($view) {
			case 'items': $this->recreateItemThumbnails(); break;
			case 'categories': $this->recreateCategoryThumbnails(); break;
			case 'producers': $this->recreateProducerThumbnails(); break;
			case 'default': break;
		}
	}
	/* ------------------------------------------------------- */
	/* CATEGORY section */
	// show list of categories
	function showCategories() {
		//JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'default'  );
		JRequest::setVar( 'view'  , 'categories');
		JRequest::setVar( 'edit', false );
		
		parent::display();
	}
	// edit single category
	function editCategory() {
		JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar( 'view'  , 'categories');
		if (JRequest::getCmd('task') == 'editCategory')
			JRequest::setVar( 'edit', true );
		else 
			JRequest::setVar( 'edit', false );
		
		parent::display();
	}
	
	// publish category
	function publishCategory() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_PUBLISH' ) );
		}

		$model = $this->getModel('categories');
		if(!$model->publish($cid, 1)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories' );
	}
	// unpublish category
	function unpublishCategory() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_UNPUBLISH' ) );
		}

		$model = $this->getModel('categories');
		if(!$model->publish($cid, 0)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories' );
	}
	
	// save category
	function saveCategory()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$post	= JRequest::get('post');
		$cid	= JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$post['id'] = (int) $cid[0];
		$post['description'] = JRequest::getVar( 'description', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$model = $this->getModel('categories');

		if ($model->store($post)) {
			$msg = JText::_( 'COM_DJCATALOG2_CATEGORY_SAVED' );
		} else {
			$msg = JText::_( 'COM_DJCATALOG2_ERROR_SAVING' ).': '.JText::_('COM_DJCATALOG2_CATEGORY');
		}

		$data = $model->getData();
		$task = JRequest::getCmd('task');
		$link = '';
		if ($task == 'saveCategory')
			$link = 'index.php?option=com_djcatalog2&task=showCategories';
		elseif($task == 'apply')
			$link = 'index.php?option=com_djcatalog2&task=editCategory&cid[]='.(int) $data->id;
		$this->setRedirect($link, $msg);
	}
	
	// delete category
	function deleteCategory() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_DELETE' ) );
		}

		$model = $this->getModel('categories');
		if(!$model->delete($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories' );
	}
	function orderupCategory()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('categories');
		$model->move(-1);

		$link = 'index.php?option=com_djcatalog2&task=showCategories';
		$this->setRedirect($link);
	}

	function orderdownCategory()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('categories');
		$model->move(1);

		$link = 'index.php?option=com_djcatalog2&task=showCategories';
		$this->setRedirect($link);
	}
	function saveorderCategory()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$order 	= JRequest::getVar( 'order', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		JArrayHelper::toInteger($order);

		$model = $this->getModel('categories');
		$model->saveorder($cid, $order);

		$msg = JText::_( 'COM_DJCATALOG2_ORDERING_SAVED' );
		$link = 'index.php?option=com_djcatalog2&task=showCategories';
		$this->setRedirect($link, $msg);
	}
	function recreateCategoryThumbnails() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_ITEM_TO_RECREATE_THUMBS ' ) );
		}
		
		$model = $this->getModel('categories');
		if(!$model->recreateThumbnails($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories',$model->getError() );
		}
		
		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showCategories' );
	}
	/* ------------------------------------------------------- */
	/* PRODUCER section */
	// show list of producers
	function showProducers() {
		//JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'default'  );
		JRequest::setVar( 'view'  , 'producers');
		JRequest::setVar( 'edit', false );
		
		parent::display();
	}
	// edit single producer
	function editProducer() {
		JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar( 'view'  , 'producers');
		if (JRequest::getCmd('task') == 'editProducer')
			JRequest::setVar( 'edit', true );
		else 
			JRequest::setVar( 'edit', false );
		
		parent::display();
	}
	
	// publish producer
	function publishProducer() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_PUBLISH' ) );
		}

		$model = $this->getModel('producers');
		if(!$model->publish($cid, 1)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers' );
	}
	// unpublish producer
	function unpublishProducer() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_UNPUBLISH' ) );
		}

		$model = $this->getModel('producers');
		if(!$model->publish($cid, 0)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers' );
	}
	
	// save producer
	function saveProducer()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$post	= JRequest::get('post');
		$cid	= JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$post['id'] = (int) $cid[0];
		$post['description'] = JRequest::getVar( 'description', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$model = $this->getModel('producers');

		if ($model->store($post)) {
			$msg = JText::_( 'COM_DJCATALOG2_PRODUCER_SAVED' );
		} else {
			$msg = JText::_( 'COM_DJCATALOG2_ERROR_SAVING' ).': '.JText::_('COM_DJCATALOG2_PRODUCER');
		}
		
		$data = $model->getData();
		$task = JRequest::getCmd('task');
		$link = '';
		if ($task == 'saveProducer')
			$link = 'index.php?option=com_djcatalog2&task=showProducers';
		elseif($task == 'apply')
			$link = 'index.php?option=com_djcatalog2&task=editProducer&cid[]='.(int) $data->id;
		
		$this->setRedirect($link, $msg);
	}
	
	// delete producer
	function deleteProducer() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_DELETE' ) );
		}

		$model = $this->getModel('producers');
		if(!$model->delete($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers',$model->getError() );
		}

		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers' );
	}
	function orderupProducer()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('producers');
		$model->move(-1);

		$link = 'index.php?option=com_djcatalog2&task=showProducers';
		$this->setRedirect($link);
	}

	function orderdownProducer()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('producers');
		$model->move(1);

		$link = 'index.php?option=com_djcatalog2&task=showProducers';
		$this->setRedirect($link);
	}
	function saveorderProducer()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$order 	= JRequest::getVar( 'order', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		JArrayHelper::toInteger($order);

		$model = $this->getModel('producers');
		$model->saveorder($cid, $order);

		$msg = JText::_( 'COM_DJCATALOG2_ORDERING_SAVED' );
		$link = 'index.php?option=com_djcatalog2&task=showProducers';
		$this->setRedirect($link, $msg);
	}
	function recreateProducerThumbnails() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_ITEM_TO_RECREATE_THUMBS ' ) );
		}
		
		$model = $this->getModel('producers');
		if(!$model->recreateThumbnails($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers',$model->getError() );
		}
		
		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showProducers' );
	}
	/* ------------------------------------------------------- */
	/* ITEM section */
	function showItems() {
		//JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'default'  );
		JRequest::setVar( 'view'  , 'items');
		JRequest::setVar( 'edit', false );
		parent::display();
	}
	// edit single Item
	function editItem() {
		JRequest::setVar( 'hidemainmenu', 1 );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar( 'view'  , 'items');
		if (JRequest::getCmd('task') == 'editItem')
			JRequest::setVar( 'edit', true );
		else 
			JRequest::setVar( 'edit', false );
		
		parent::display();
	}
	
	// publish Item
	function publishItem() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_PUBLISH' ) );
		}

		$model = $this->getModel('items');
		if(!$model->publish($cid, 1)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showItems',$model->getError() );
		}

		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link);
	}
	// unpublish Item
	function unpublishItem() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_UNPUBLISH' ) );
		}

		$model = $this->getModel('items');
		if(!$model->publish($cid, 0)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showItems',$model->getError() );
		}
		
		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link);
	}
	
	// save Item
	function saveItem()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$post	= JRequest::get('post');
		$cid	= JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$post['id'] = (int) $cid[0];
		$post['description'] = JRequest::getVar( 'description', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$post['intro_desc'] = JRequest::getVar( 'intro_desc', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$model = $this->getModel('items');

		if ($model->store($post)) {
			$msg = JText::_( 'COM_DJCATALOG2_ITEM_SAVED' );
		} else {
			$msg = JText::_( 'COM_DJCATALOG2_ERROR_SAVING' ).': '.JText::_('COM_DJCATALOG2_ITEM');
		}
		
		$data = $model->getData();
		$task = JRequest::getCmd('task');
		$link = '';
		if ($task == 'saveItem')
			$link = 'index.php?option=com_djcatalog2&task=showItems';
		elseif($task == 'apply')
			$link = 'index.php?option=com_djcatalog2&task=editItem&cid[]='.(int) $data->id;
		$this->setRedirect($link, $msg);
	}
	
	// delete Item
	function deleteItem() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_AN_ITEM_TO_DELETE' ) );
		}

		$model = $this->getModel('items');
		if(!$model->delete($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showItems',$model->getError() );
		}

		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link);
	}
	// odrderup & orderdown Item
	function orderupItem()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('items');
		$model->move(-1);

		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link);
	}

	function orderdownItem()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$model = $this->getModel('items');
		$model->move(1);

		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link);
	}
	function saveorderItem()
	{
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$order 	= JRequest::getVar( 'order', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		JArrayHelper::toInteger($order);

		$model = $this->getModel('items');
		$model->saveorder($cid, $order);

		$msg = JText::_( 'COM_DJCATALOG2_ORDERING_SAVED' );
		$link = 'index.php?option=com_djcatalog2&task=showItems';
		$this->setRedirect($link, $msg);
	}
	function recreateItemThumbnails() {
		JRequest::checkToken() or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'COM_DJCATALOG2_SELECT_ITEM_TO_RECREATE_THUMBS ' ) );
		}
		
		$model = $this->getModel('items');
		if(!$model->recreateThumbnails($cid)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2&task=showItems',$model->getError() );
		}
		
		$this->setRedirect( 'index.php?option=com_djcatalog2&task=showItems' );
	}
}
?>