<?php
/**
* @author design-joomla.eu
* @email sales@design-joomla.eu
* @version 2.0
* @package Xmap
* @license GNU/GPL
* @description Xmap plugin for DJ Catalog component
*/

defined( '_JEXEC' ) or die( 'Restricted access.' );

class xmap_com_djcatalog2 {

	/*
	* This function is called before a menu item is printed. We use it to set the
	* proper uniqueid for the item and indicate whether the node is expandible or not
	*/
	function prepareMenuItem(&$node) {
		$link_query = parse_url( $node->link );
		parse_str( html_entity_decode($link_query['query']), $link_vars);
		$view = JArrayHelper::getValue($link_vars,'view','');
		if ( $view == 'item') {
			$id = intval(JArrayHelper::getValue($link_vars,'id',0));
			if ( $id ) {
				$node->uid = 'com_djcatalog2item'.$id;
				$node->expandible = false;
			}
		}
		else if ( $view == 'producer') {
			$id = intval(JArrayHelper::getValue($link_vars,'pid',0));
			if ( $id ) {
				$node->uid = 'com_djcatalog2producer'.$id;
				$node->expandible = false;
			}
		} elseif ( $view == 'items') {
            $cid = intval(JArrayHelper::getValue($link_vars,'cid',0));
            $node->uid = 'com_djcatalog2items'.$cid;
            $node->expandible = true;
        } elseif ( $view == 'itemstable' ) {
			$cid = intval(JArrayHelper::getValue($link_vars,'cid',0));
			$node->uid = 'com_djcatalog2itemstable'.$cid;
			$node->expandible = true;
		}
	}

	function getTree( &$xmap, &$parent, &$params) {
		$link_query = parse_url( $parent->link );
		parse_str( html_entity_decode($link_query['query']), $link_vars );
		$view = JArrayHelper::getValue($link_vars,'view',0);

		$menu =& JSite::getMenu();
		$menuparams = $menu->getParams($parent->id);

		if ( $view == 'items' ) {
			    $cid = intval(JArrayHelper::getValue($link_vars,'cid',0));
		} elseif ( $view == 'itemstable' ) {  
                $cid = intval(JArrayHelper::getValue($link_vars,'cid',0));
        } else { // Only expand category menu items
			return;
		}

		$include_items = JArrayHelper::getValue( $params, 'include_items',1,'' );
		$include_items = ( $include_items == 1
				  || ( $include_items == 2 && $xmap->view == 'xml')
				  || ( $include_items == 3 && $xmap->view == 'html')
				  ||   $xmap->view == 'navigator');
		$params['include_items'] = $include_items;
		
		$include_categories = JArrayHelper::getValue( $params, 'include_categories',1,'' );
		$include_categories = ( $include_categories == 1
				  || ( $include_categories == 2 && $xmap->view == 'xml')
				  || ( $include_categories == 3 && $xmap->view == 'html')
				  ||   $xmap->view == 'navigator');
		$params['include_categories'] = $include_categories;

		$priority = JArrayHelper::getValue($params,'cat_priority',$parent->priority,'');
		$changefreq = JArrayHelper::getValue($params,'cat_changefreq',$parent->changefreq,'');
		if ($priority  == '-1')
			$priority = $parent->priority;
		if ($changefreq  == '-1')
			$changefreq = $parent->changefreq;

		$params['cat_priority'] = $priority;
		$params['cat_changefreq'] = $changefreq;

		$priority = JArrayHelper::getValue($params,'item_priority',$parent->priority,'');
		$changefreq = JArrayHelper::getValue($params,'item_changefreq',$parent->changefreq,'');
		if ($priority  == '-1')
			$priority = $parent->priority;

		if ($changefreq  == '-1')
			$changefreq = $parent->changefreq;

		$params['item_priority'] = $priority;
		$params['item_changefreq'] = $changefreq;

		xmap_com_djcatalog2::getCategoryTree($xmap, $parent, $params, $cid, $view );
		if ( $params['include_items'] && $params['include_categories']) {
    		xmap_com_djcatalog2::getCategoryItems( $xmap, $parent, $params, $cid );
		}

	}

	function getCategoryTree ( &$xmap, &$parent, &$params, $cid, $view='items') {
		$db = &JFactory::getDBO();
		
        if ( $params['include_categories']) {
            $query = ' SELECT c.id, c.name,'.
                     ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug' .
                     ' FROM #__djc2_categories c '.
                     ' WHERE c.published=1 AND c.parent_id='.$cid.' '.
                     ' ORDER by c.ordering ';

            $db->setQuery($query);
            $cats = $db->loadObjectList();
            $xmap->changeLevel(1);
            foreach($cats as $cat) {
                $node = new stdclass;
                $node->id   = $parent->id;
                $node->uid  = $parent->uid .$view.$cat->id;
                $node->name = $cat->name;
                $node->link = 'index.php?option=com_djcatalog2&amp;view='.$view.'&amp;cid='.$cat->catslug;
                $node->priority   = $params['cat_priority'];
                $node->changefreq = $params['cat_changefreq'];
                $node->expandible = true;
				
                if ( $xmap->printNode($node) !== FALSE ) {
                	if ( $params['include_items']) {
                		xmap_com_djcatalog2::getCategoryItems( $xmap, $parent, $params, $cat->id );
					}
                    xmap_com_djcatalog2::getCategoryTree( $xmap, $parent, $params, $cat->id, $view );
                }
            }
            $xmap->changeLevel(-1);
        }
	}
		
	function getCategoryItems ( &$xmap, &$parent, &$params, $cid) {
    	$db = &JFactory::getDBO();
		if ( $params['include_items']) {
		    $query = ' SELECT i.id, i.name, c.id AS category_id, '.
		             ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug, ' .
		             ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(":", c.id, c.alias) ELSE c.id END as catslug'.
		             ' FROM #__djc2_items i '.
					 ' LEFT JOIN #__djc2_categories c ON c.id=i.cat_id '.
		             ' WHERE c.published=1 AND i.published=1 AND i.cat_id='.$cid.' '.
		             ' ORDER by i.ordering ';
	
		    $db->setQuery($query);
		    $items = $db->loadObjectList();
		    $xmap->changeLevel(1);
		    foreach($items as $item) {
			    $node = new stdclass;
			    $node->id   = $parent->id;
			    $node->uid  = $parent->uid.'item'.$item->id;
			    $node->name = $item->name;
			    $node->link = 'index.php?option=com_djcatalog2&amp;view=item&amp;id='.$item->slug . "&amp;cid=" . $item->catslug;
			    $node->priority   = $params['item_priority'];
			    $node->changefreq = $params['item_changefreq'];
			    $node->expandible = false;
			    $xmap->printNode($node);
		    }
		    $xmap->changeLevel(-1);
		}
    }
}
